package lucasslf.radar;

import java.awt.geom.Point2D;

import lucasslf.LucasslfBot;
import lucasslf.utility.ScannedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public class BasicRadar extends Radar {
	
	

	public BasicRadar(LucasslfBot robot) {
		super(robot);
	}
	
	public void doRun(){
		if (Math.abs(getRobot().getRadarTurnRemaining()) < 0.000001 && getRobot().getOthers() > 0) {
			if (getRobot().getTime() > 9)
				System.out.println("Lost radar lock");
			getRobot().setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		}
		
		getRobot().execute();
	}

	public void onHitRobot(HitRobotEvent e) {
		getRobot().lastScannedRobot.energy -= 0.6;

	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {

	}

	public void onBulletHit(BulletHitEvent e) {
		double power = e.getBullet().getPower();
		double damage = 4.0 * power;
		if (power > 1)
			damage += 2.0 * (power - 1.0);
		getRobot().lastScannedRobot.energy -= damage;

	}

	public void onHitByBullet(HitByBulletEvent e) {
		getRobot().lastScannedRobot.energy += 3 * e.getBullet().getPower();

	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double enemyAbsoluteBearing = getRobot().getHeadingRadians() + e.getBearingRadians();
		double ex = getRobot().getX() + Math.sin(enemyAbsoluteBearing) * e.getDistance();
		double ey = getRobot().getY() + Math.cos(enemyAbsoluteBearing) * e.getDistance();
		Point2D enemyLocation = new Point2D.Double(ex, ey);
		getRobot().lastScannedRobot = new ScannedRobot();
		getRobot().lastScannedRobot.energy = e.getEnergy();
		getRobot().lastScannedRobot.name = e.getName();
		getRobot().lastScannedRobot.bearing = enemyAbsoluteBearing;
		getRobot().lastScannedRobot.time = e.getTime();
		getRobot().lastScannedRobot.velocity = e.getVelocity();
		getRobot().lastScannedRobot.position = enemyLocation;
		getRobot().setTurnRadarRightRadians(robocode.util.Utils.normalRelativeAngle(enemyAbsoluteBearing
				- getRobot().getRadarHeadingRadians()) * 2);
	}

}
