package bvh.micro;

import java.awt.*;
import robocode.*;
/**
/**
 * Svadilfari - a robot by Bart van Hest
 *
 * "Svadilfari is the smart and powerful horse of the giant Hrimthurs (Blast).
 *  Svadilfari is the father of Sleipnir, born out of Loki who, in his disguise
 *  as a mare, tried to lure Svadilfari away from his work on the walls
 *  surrounding Asgard."
 *
 * Wijzigingshistorie v0.1 (20-02-2003):
 *  - linaire doelschatter o.b.v. schatting gemiddelde snelheid doel (0.8*vActueel).
 *
 * Wijzigingshistorie v0.1 (07-02-2003):
 *  - een eigen naam gegeven omdat de overeenkomsten met Sleipnir compleet zijn verdwenen.
 *
 * In de nieuwe traditie van "perceptual bot"'s is dit een (over)gesimplificeerde
 * versie van Sleipnir: niet tegen wanden botsen en linaire doelpositie schatter
 * zonder dat tussentijds informatie wordt opgeslagen.
 *
 * Wijzigingshistorie v0.42 (14-01-2003):
 *  - weer sneller schieten (zoals v0.40).
 *  - sneller draaien
 *
 * Wijzigingshistorie v0.41 (10-01-2003):
 *  - Minder snel schieten (kost veel energie).
 *
 * Wijzigingshistorie v0.4 (09-01-2003):
 *  - weer terug naar een random beweging (gebaseeerd op Darwin, Scientific American, may 1989).
 *
 * Wijzigingshistorie v0.3 (24-12-2002):
 *  - ?
 *
 * Wijzigingshistorie v0.2 (24-12-2002):
 *  - beweging gebaseerd op positie t.o.v. tegenstander (probleem op afstand pm. 500..).
 *
 * Wijzigingshistorie v0.1 (05-12-2002): codesize 270 (not a nano-bot, grrr...)
 *  - Gebaseerd op Sleipnir v0.3.
 *
*/
public class Svadilfari extends AdvancedRobot {

/* instance (object) variables */
   final int[]    xMove = {0, 2, 2, 0,-2,-2};  // steps to make in x-dir. when moving in certain direction
   final int[]    yMove = {2, 1,-1,-2,-1, 1};  // steps to make in y-dir. when moving in certain direction

   public void run() {
// initiatie onafhankelijke tank/kanon/radar beweging:
      setAdjustGunForRobotTurn(true);
      setAdjustRadarForGunTurn(true);

// start main loop:
      do {
         turnRadarRightRadians(1);
      } while (true);
   }

   public void onScannedRobot(ScannedRobotEvent e) {
      double doelRichting  = e.getBearingRadians() + getHeadingRadians();

// Stuur tank:
      if ( getDistanceRemaining() < 2 && getTurnRemaining() == 0 ) {

         int direction = 0;
         double r      = 10*Math.random();
// determine next position:
         if      ((r >= 0    ) & (r < 0.741)) direction = 0;
         else if ((r >= 0.741) & (r < 2.963)) direction = 1;
         else if ((r >= 2.963) & (r < 4.444)) direction = 2;
         else if ((r >= 4.444) & (r < 4.815)) direction = 3;
         else if ((r >= 4.815) & (r < 6.296)) direction = 4;
         else if ((r >= 6.296) & (r < 9.259)) direction = 5;
         direction = ( (int)(getHeading()/30D) + direction) % 6;

         double xBot    = getX();
         double yBot    = getY();

         double xNw = xBot + 45 * xMove[ direction ];
         double yNw = yBot + 45 * yMove[ direction ];
         xNw = Math.min(getBattleFieldWidth()  - 65, Math.max(65, xNw));
         yNw = Math.min(getBattleFieldHeight() - 65, Math.max(65, yNw));

         double draai = bepaalRichting(xNw, yNw, xBot, yBot) - getHeadingRadians();
         r = bepaalAfstand(xNw, yNw, xBot, yBot);
         if( Math.abs(draai) > Math.PI/2) {
           draai = angle_180(draai+Math.PI);
           r = -r;
        }
/*
         double draai = bepaalRichting(xNw, yNw, xBot, yBot) - getHeadingRadians();
         if (e.getBearingRadians() > 0 && draai > 0) draai -= Math.PI;
         if (e.getBearingRadians() < 0 && draai < 0) draai += Math.PI;
         draai = angle_180(draai);
*/
         setTurnRightRadians( draai );
         setAhead( r );
      }

// Stuur radar:
      setTurnRadarRightRadians( -5*getRadarTurnRemaining() );

// Stuur kanon (lineare doel positie schatter) en vuur:
      double kanonVuurkracht = Math.max(Math.min(400/e.getDistance(), 3), 0.1);
      double lineare_schatter= angle_180(Math.asin(0.8*e.getVelocity()/(20-3*kanonVuurkracht)*Math.sin(e.getHeadingRadians()-doelRichting))
                               + doelRichting
                               - getGunHeadingRadians());

      setTurnGunRightRadians(lineare_schatter);
      if (getGunHeat()==0
       && Math.abs(getGunTurnRemaining()) < 3
       && getEnergy() > 3) fire(kanonVuurkracht);
   }

/******************************************************************************
* Utils:
******************************************************************************/
/**
* normaliseer richting:
*/
   public static double angle_180(double ang) {
      return Math.atan2(Math.sin(ang), Math.cos(ang));
   }

/**
* bepaal richting van bot tot doel-positie
*/
   public static double bepaalRichting(double Xd, double Yd, double Xb, double Yb ) {
      return Math.atan2( (Xd - Xb), (Yd - Yb) );
   }

/**
* bepaal afstand van bot tot doel-positie
*/
   public static double bepaalAfstand(double Xd, double Yd, double Xb, double Yb ) {
      return (Math.sqrt((Xd-Xb)*(Xd-Xb)+(Yd-Yb)*(Yd-Yb)));
   }
}