package zyx.nano;

import static java.lang.Math.random;
import static java.lang.Math.PI;
import static java.lang.Math.abs;
import static java.lang.Math.asin;
import static java.lang.Math.min;
import static java.lang.Math.max;

import java.awt.Color;

import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RedBull extends AdvancedRobot {
  private static final double H_PI = PI / 2;
  public void run() {
    setAdjustGunForRobotTurn(true);
    setAdjustRadarForGunTurn(true);
    setColors(new Color(44, 33, 141), new Color(174, 189, 186), Color.RED, new Color(210, 207, 77), null);
    while ( true ) {
      if ( getRadarTurnRemainingRadians() == 0 ) setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
      execute();
    }
  }
  public void onScannedRobot(ScannedRobotEvent event) {
    double bearing = getHeadingRadians() + event.getBearingRadians();
    setTurnRadarRightRadians(Utils.normalRelativeAngle(bearing - getRadarHeadingRadians()) * 1.99);
    double t = Utils.normalRelativeAngle(bearing - getHeadingRadians());
    if ( abs(t) > H_PI ) {
      setTurnRightRadians(Utils.normalRelativeAngle(t + PI));
      setAhead(Double.NEGATIVE_INFINITY);
    } else {
      setTurnRightRadians(t);
      setAhead(Double.POSITIVE_INFINITY);
    }
    double power = max(min(400 / event.getDistance(), 3), 0.1);
    bearing += (random() * 0.25 - 0.125) * asin(8 / Rules.getBulletSpeed(power));
    setTurnGunRightRadians(Utils.normalRelativeAngle(bearing - getGunHeadingRadians()));
    setFire(power);
  }
}
