/*
 * Created on 29/03/2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package axeBots.util;

import java.util.zip.DataFormatException;

/**
 * @author Marcos
 * 
 * To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Generation - Code and Comments
 */
public class Triangle {

	private double angs[] = new double[3];
	private double sides[] = new double[3];

	/**
	 *  
	 */
	public Triangle() {
		super();
		for (int i = 0; i < angs.length; i++) {
			angs[i] = Double.NaN;
			sides[i] = Double.NaN;
		}
	}

	/**
	 *  
	 */
	public Triangle(double angs[], double sides[]) {
		this();
		this.angs = angs;
		this.sides = sides;
	}

	public double getAngle(int index) {
		return angs[index];
	}

	public double getSide(int index) {
		return sides[index];
	}

	public void compute() throws DataFormatException {
		double rate = Double.NaN;
		int angsq = 0;
		int sidesq = 0;
		int angsum = 0;
		//conta angulos, lados e soma dos angulos
		for (int i = 0; i < angs.length; i++) {
			if (!Double.isNaN(angs[i])) {
				angsq++;
				angsum += angs[i];
				
			}
			if (!Double.isNaN(sides[i])) {
				sidesq++;
			}
		}
		//lei dos senos
		if (angsq >= 2 && sidesq >= 1) {
			//calcula angulo que falta e rate
			for (int i = 0; i < angs.length; i++) {
				if (Double.isNaN(angs[i])) {
					angs[i] = 180D - angsum;
				}
				if (!Double.isNaN(sides[i])) {
					rate = Math.sin(Math.toRadians( angs[i])) / sides[i];
				}
			}
			//calcula os lados
			for (int i = 0; i < angs.length; i++) {
				if (Double.isNaN(sides[i])) {
					sides[i] = Math.sin(Math.toRadians( angs[i])) * (1D/rate);
				}
			}
		} else {
			throw new DataFormatException(
					"Sao necessarios ao menos 2 angulos e um lado para o calculo");
		}
		//implementar a lei dos cossenos
		//A^2 = B^2 + C^2 - 2*B*C*COS(a)
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "Triangle. angles: a:"+angs[0]+" b:"+angs[1]+" c:"+angs[2]+"\r\nsides A:"+sides[0]+" B:"+sides[1]+" C:"+sides[2];
	}
}
