package theo.simple.surf;
import theo.simple.Bones;
import theo.simple.wave.Wave;
import theo.simple.utils.botUtils;
import theo.simple.enemy.Enemy;
import theo.simple.surf.vect.Vector;
import java.util.*;
import java.awt.geom.Point2D;
import robocode.*;
import robocode.util.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
/**
 * SHandler - a class by Damij
 */
public class SHandler {

	AdvancedRobot bot;
	
	List<Enemy> _enemyList;
	
	List<Wave> _waveList;
	
	List<Double> _neighborList;
	
	Enemy target;
	
	ScannedRobotEvent sre;
	
	Wave currWave,lastWave;
	
	double bPower,bSpeed,
		latDirection,lastLatDirection,
		velocity,driveTheta,
		lastBPower,surfMagnitude;
	
	double[] stats,lastStats;
	
	long currTime;
	
	int opps;

	Point2D.Double pos, midPoint;
	
	HashMap<String,Point2D.Double> _enemyLocationMap;
	HashMap<String,Vector> _forceMap;
	HashMap<String,Double> _statsBuffer;
	HashMap<double[],Double> _statsMap;
	
	private static final double wallSections;

	private static final double botWeight,wallWeight,bulletWeight,midWeight,mgConstant;
	private static Point2D.Double[][] wallPoints;
	
	private static final int NUM_NEIGHBORS,SHOT_TIMER;
	
	
	static{
		wallSections = 600d/15d;
		wallPoints = new Point2D.Double[(int)wallSections+3][(int)wallSections+3];
		botWeight = 2000.0d;//1296.0d;
		wallWeight = 600.0;//396.0d;//23.5d;
		bulletWeight = 155.0d;//1000.0d;//324.0;//101.0;//45.0d;//33.0d;//1000.0d/11.0d;
		midWeight = 1000.0d;//2750.0d;
		mgConstant = 150.0d;//250.0d;
		NUM_NEIGHBORS = 7;
		SHOT_TIMER = 15;
	}
		

	public SHandler(AdvancedRobot bot){
		this.bot = bot;
		this._enemyLocationMap = new HashMap<String,Point2D.Double>();
		this._waveList = new ArrayList<Wave>();
		this._neighborList = new ArrayList<Double>();
		this._forceMap = new HashMap<String,Vector>();
		this._statsMap = new HashMap<double[],Double>();
		this.stats = new double[10];
		this._statsBuffer = new HashMap<String,Double>();
		double battleWidth = this.bot.getBattleFieldWidth();
		double battleHeight = this.bot.getBattleFieldHeight();
		double horizontalSectionLength = battleWidth/wallSections;
		double verticalSectionLength = battleHeight/wallSections;
		for(int p = 2; p < wallPoints[0].length; p ++){
			wallPoints[0][p] = new Point2D.Double();
			wallPoints[0][p].x = ((double)p-2)*horizontalSectionLength;
			wallPoints[0][p].y = 0.0d;
			wallPoints[p][0] = new Point2D.Double();
			wallPoints[p][0].x = 0.0d;
			wallPoints[p][0].y = ((double)p-2)*verticalSectionLength;
			wallPoints[1][p] = new Point2D.Double();
			wallPoints[1][p].x = ((double)p-2)*horizontalSectionLength;
			wallPoints[1][p].y = battleHeight;
			wallPoints[p][1] = new Point2D.Double();
			wallPoints[p][1].x = battleWidth;
			wallPoints[p][1].y = ((double)p-2)*verticalSectionLength;
		}
		this.midPoint = Bones.midPoint;
	}
	
	public void update(Enemy target, ArrayList<Enemy> _enemyList, ScannedRobotEvent sre){
		this.target = target;
		this._enemyList = _enemyList;
		this.sre = sre;
		
		this.currTime = this.bot.getTime();
		this.pos = new Point2D.Double(this.bot.getX(),this.bot.getY());
		this.lastLatDirection = this.latDirection;
		this.velocity = this.bot.getVelocity();
		if(this.velocity!=0.0){
			this.latDirection = (this.velocity*target.absBearing<0?-1:1);
		} else this.latDirection = this.lastLatDirection;
		this.opps = this.bot.getOthers();

		if(target.energyDelta <= 3.0 && target.energyDelta > 0.0){
			this.bPower = target.energyDelta;
			this.bSpeed = botUtils.bSpeed(this.bPower);
		}
		else{
			this.bPower = 0.0;
			this.bSpeed = 20.0;
		}
		
		this.checkWaveSpawn();

		if(currWave!=null&&!currWave.equals(lastWave)){
			lastWave = currWave;
			currWave._neighborList = this.setNeighbors(currWave);
			currWave.heavyAngle = this.getHeaviestAngle(currWave);
		}
		
		this.updateWaves();
		this.speculateForces();
		this.generateHeat();
		this.findLeastLudicrous();
		this.setStats();
		this.partyOnDude();
		
		this.lastStats = this.stats;
		
	}
	
	private List<Double> setNeighbors(Wave wave){
		return botUtils.findNearestSurfNeighbors(
				wave.stats.clone(), _statsMap, NUM_NEIGHBORS);
	}
	
	private void checkWaveSpawn(){
		if(this.bPower!=0.0 && this.opps <= 2){
			this.lastBPower = this.bPower;
			this.spawnWave(true);
			this.currWave = this.getClosestSurfableWave();
		}
		else if(this.bot.getTime()%SHOT_TIMER==0){
			if(this._statsBuffer.get("positionX")!=null){
				this.spawnWave(false);
			}
		}
	}
	
	private void setStats(){
		this._statsBuffer.put("positionX", this.pos.x);
		this._statsBuffer.put("positionY", this.pos.y);
		this._statsBuffer.put("absAngle", botUtils.absAngle(target.pos,this.pos));
		this._statsBuffer.put("absBearing", botUtils.absBearing(target.pos,this.pos));
		this._statsBuffer.put("latDirection", this.latDirection);
		this._statsBuffer.put("targetX", this.target.pos.x);
		this._statsBuffer.put("targetY", this.target.pos.y);
		
		this.stats[0] = target.distance/1000d;
		this.stats[1] = 36d/target.distance;
		this.stats[2] = botUtils.bSpeed(this.lastBPower)/20.0;
		this.stats[3] = bot.getVelocity()/8.0;
		
		for(int i = 0; i < this.stats.length; i ++){
			this.stats[i] = botUtils.limit(0d,Math.abs(this.stats[i]),1d);
		}
	}
	
	private void spawnWave(boolean isReal){
		Wave wave = new Wave();
		wave.zeroPoint = (Point2D.Double)new Point2D.Double(this._statsBuffer.get("positionX"),this._statsBuffer.get("positionY")).clone();
		wave.startPoint = (Point2D.Double)new Point2D.Double(this._statsBuffer.get("targetX"),this._statsBuffer.get("targetY")).clone();
		wave.absAngle = this._statsBuffer.get("absAngle");
		wave.absBearing = this._statsBuffer.get("absBearing");
		wave.maxEscapeAngle = Math.asin(8.0/this.bSpeed)*this._statsBuffer.get("latDirection");
		wave.latDirection = this._statsBuffer.get("latDirection");
		wave.shotTime = currTime - 1;
		wave.velocity = this.bSpeed;
		wave.distTraveled = wave.velocity;
		wave.isReal = isReal;
		wave.stats = this.lastStats.clone();
		wave.bPower = this.bPower;
		wave._neighborList = this.setNeighbors(wave);
		wave.heavyAngle = this.getHeaviestAngle(wave);
		_waveList.add(wave);
	}
	
	private void updateWaves(){
		for(int w = 0; w < _waveList.size(); w++){
			Wave toProp = _waveList.get(w);
			toProp.setDistTraveled((this.currTime-toProp.shotTime)*toProp.velocity);
			if(toProp.distTraveled>toProp.startPoint.distance(pos)){
				_waveList.remove(toProp);
				w--;
			}
		}
	}
	
	private void speculateForces(){
		 this.setMaps();
		 this.setWallForces();
		 if(this.opps <= 2){
			 this.setBulletForces();
		 }
	}
	
	private void setMaps(){
		for(int e = 0; e < _enemyList.size(); e++){
			Enemy toLocate = _enemyList.get(e);
			_enemyLocationMap.put(toLocate.name,toLocate.pos);
			_forceMap.put(toLocate.name,this.defineVector(target.pos,botWeight));
		}
	}
	
	private void setWallForces(){
		String spotName;
		for(int p = 2; p < wallPoints[0].length; p ++){
			Vector v = this.defineVector(wallPoints[0][p],wallWeight);
			spotName = "top".concat(new Integer(p).toString());
			_forceMap.put(spotName,v);
			v = this.defineVector(wallPoints[p][0],wallWeight);
			spotName = "left".concat(new Integer(p).toString());
			_forceMap.put(spotName,v);
			v = this.defineVector(wallPoints[p][1],wallWeight);
			spotName = "right".concat(new Integer(p).toString());
			_forceMap.put(spotName,v);
			v = this.defineVector(wallPoints[1][p],wallWeight);
			spotName = "bottom".concat(new Integer(p).toString());
			_forceMap.put(spotName,v);
		}
		Vector v = this.defineVector(this.midPoint,midWeight);
		_forceMap.put("mid",v);
	}
	
	private void setBulletForces(){
		Point2D.Double bulletPos;
		int i = 0; String spotName;
		Object[] keySet = _forceMap.keySet().toArray().clone();
		for(int f = 0; f < keySet.length; f ++){
			Object val = keySet[f];
			String name = val.toString();
			try{
				Integer tookey = Integer.parseInt(name);
				if(tookey >= 0){
					_forceMap.remove(val);
				}
			}
			catch(NumberFormatException e){}
		}
		for(Wave wave : _waveList){
			if(!wave.equals(currWave)&&wave.isReal){
				bulletPos = botUtils.project(wave.startPoint,wave.distTraveled,wave.heavyAngle);
				//bulletPos = botUtils.project(wave.startPoint,wave.startPoint.distance(this.pos),wave.heavyAngle);
				Vector v = this.defineVector(bulletPos,bulletWeight*wave.bPower);
				spotName = new Integer(i).toString();
				_forceMap.put(spotName,v);
				i++;
			}
		}
//		bulletPos = botUtils.project(wave.startPoint,wave.distTraveled,wave.heavyAngle);
		if(currWave!=null){
		/*	for(Double offset : currWave._neighborList){
			//	if(wave.equals(currWave)){
			//	bulletPos = botUtils.project(currWave.startPoint,currWave.startPoint.distance(this.pos),this.getAngleForOffset(currWave,offset));
				bulletPos = botUtils.project(currWave.startPoint,currWave.distTraveled,this.getAngleForOffset(currWave,offset));
				//bulletPos = botUtils.project(wave.startPoint,wave.startPoint.distance(this.pos),wave.heavyAngle);
				Vector v = this.defineVector(bulletPos,bulletWeight/(double)NUM_NEIGHBORS/*wave.bPower*///);
			/*	spotName = "currNeighb".concat(new Integer(i).toString());
				_forceMap.put(spotName,v);
				i++;
				//}
			}*/
			bulletPos = botUtils.project(currWave.startPoint,currWave.startPoint.distance(this.pos),currWave.heavyAngle);
			Vector v = this.defineVector(bulletPos,bulletWeight*currWave.bPower);
			spotName = "current";
			_forceMap.put(spotName,v);
			//Point2D.Double midPoint = botUtils.project(currWave.startPoint,currWave.distTraveled,currWave.absBearing);
			//v = this.defineVector(midPoint,bulletWeight*currWave.bPower);
			//spotName = "midWeight";
			//_forceMap.put(spotName,v);
		}
	}
	
	private Vector defineVector(Point2D.Double loc, double weight){
		Vector v = new Vector();
		v.source = (Point2D.Double)loc.clone(); v.target = this.pos;
		v.distance = v.source.distance(v.target);
		v.magnitude = botUtils.force(v.distance, mgConstant*weight);
		v.direction = botUtils.absAngle(v.source,v.target);
		v.unit = new double[2];
		v.unit[0] = (v.target.x-v.source.x)/v.distance;
		v.unit[1] = (v.target.y-v.source.y)/v.distance;
		v.forceVector = new double[2];
		v.forceVector[0] = v.unit[0]*v.magnitude;
		v.forceVector[1] = v.unit[1]*v.magnitude;
		return (Vector)v;//.doClone();
	}
	
	private void generateHeat(){
		double forceX = 0, forceY = 0, runningRatio = 0;
		for(Vector v : _forceMap.values()){
			forceX += //v.magnitude*Math.sin(v.direction);
				v.forceVector[0];
			forceY += //v.magnitude*Math.cos(v.direction);
				v.forceVector[1];
		}
		this.driveTheta = Utils.normalAbsoluteAngle(Math.atan2(forceX,forceY));
		this.surfMagnitude = Math.sqrt(forceX*forceX + forceY*forceY);
	}
	
	private void findLeastLudicrous(){
		
	}
	
	private void partyOnDude(){
		double turnAmount = Utils.normalRelativeAngle(this.driveTheta-bot.getHeadingRadians());
		double goDir = 1;
		if(Math.abs(turnAmount)>Math.PI/2.0){
			goDir = -1;
			turnAmount = turnAmount+Math.PI;
		}
		bot.setTurnRightRadians(Utils.normalRelativeAngle(turnAmount));
		bot.setAhead(/*56*/ 36*goDir*Math.signum(this.surfMagnitude));
	}
	
	public void onHit(Bullet e){
		Wave resultWave = this.getHitWave(e);
		if(resultWave!=null){
			_statsMap.put(resultWave.stats.clone(),this.getOffset(resultWave));
		}
		else{
			System.out.println("We dropped a wave Sir");
		}
	}
	
	private Wave getHitWave(Bullet e){
		Wave incidentWave = null; double distDelta, minDist = 1000000.0;
		Point2D.Double bulletPos = new Point2D.Double(e.getX(),e.getY());
		for(int i = 0; i < _waveList.size(); i ++){
			Wave test = _waveList.get(i);
			distDelta = Math.abs(test.distTraveled - bulletPos.distance(test.startPoint));
			if(distDelta < minDist && e.getPower() - test.bPower < 0.1){
				incidentWave = test;
			}
		}
		return incidentWave;
	}
	
	private double getOffset(Wave wave){
		return Utils.normalRelativeAngle(botUtils.absBearing(wave.startPoint,this.pos)-wave.absBearing)/wave.maxEscapeAngle;
	}

	public void onWin(WinEvent e){
		_waveList.clear();
	}
	
	public void onDeath(DeathEvent e){
		_waveList.clear();
	}
	
	private double getHeaviestAngle(Wave dWave){
		double heavyAngle = dWave.absAngle, botWidth = target.botWidth/2.0;
		double density, maxDensity = 0.0d;
		for(Double offset : dWave._neighborList){
			double angleA = getAngleForOffset(dWave, offset);
			density = 0;
			for(Double offset2 : dWave._neighborList){
			//	if(offset2!=offset){
					double angleB = getAngleForOffset(dWave, offset);
					double ratio = Utils.normalRelativeAngle(angleB-angleA)/botWidth;
					density += Math.pow(Math.E,-0.5d*ratio*ratio);
			//	}
			}
			if(density > maxDensity){
				maxDensity = density;
				heavyAngle = angleA;
			}
		}
		return Utils.normalAbsoluteAngle(heavyAngle);
	}
	
	private Wave getClosestSurfableWave(){
		Wave incidentWave = null; double distDelta = 0, minDist = 1000000.0d;
		for(int i = 0; i < _waveList.size(); i ++){
			Wave test = _waveList.get(i);
			distDelta = Math.abs(test.distTraveled - this.pos.distance(test.startPoint));
			if(distDelta < minDist && distDelta > test.velocity && test.isReal){
				incidentWave = test;
			}
		}
		return incidentWave;
	}

	private double getAngleForOffset(Wave wave, double offset){
		return Utils.normalRelativeAngle(Math.asin(8.0/wave.velocity)*offset*wave.latDirection + wave.absBearing);
	}
	
	public void onPaint(Graphics2D g){
		for (Wave toPaint : _waveList){
			if(toPaint.isReal){
				double radius = toPaint.distTraveled + toPaint.velocity;
				g.setColor((toPaint.isReal?Color.white:Color.yellow));
				if(toPaint.equals(currWave)) g.setColor(Color.blue);
				g.drawOval(new Double(toPaint.startPoint.x - radius).intValue(),
					new Double(toPaint.startPoint.y - radius).intValue(),
						new Double(radius*2).intValue(), new Double(radius*2).intValue());
				g.setColor(Color.green);
				Point2D.Double midBin = new Point2D.Double((radius*Math.sin(toPaint.absBearing) + toPaint.startPoint.x),
											(radius*Math.cos(toPaint.absBearing) + toPaint.startPoint.y));
				g.drawOval((int)midBin.x-5,(int)midBin.y-5,10,10);
			}
		}
		g.setColor(Color.red); double maxMag = 0.0d;
		for (Vector v : _forceMap.values()){
			if(v.magnitude>maxMag){
				maxMag = v.magnitude;
			}
		}
		double ratio;
		for (Vector v : _forceMap.values()){
			ratio = v.magnitude/maxMag;
			g.setColor(new Color((int)(100d*ratio)+100, 200-(int)(135d*ratio), 200-(int)(125d*ratio)));
			g.drawLine((int)v.source.x,(int)v.source.y,(int)v.target.x,(int)v.target.y);
		}
	}

}
