package kawigi.spare.parts;
import robocode.*;
import kawigi.spare.util.*;
/**
 * IterativeCircularPredictingGun - an implementation of circular prediction aiming
 */
public class IterativeCircularPredictingGun extends Gun implements java.io.Serializable
{
	private transient double power;
	public IterativeCircularPredictingGun(AdvancedRobot robot)
	{
		super(robot);
	}
	
	public void onEvent(Event e)
	{
	}
	
	public ChooserBullet getVirtualBullet(EnemyState target)
	{
		if (target == null)
			return null;
		if (robot.getEnergy() >= 15 || target.getEnergy() == 0)
			power = 3;
		else
			power = .2*robot.getEnergy();
		double myx = robot.getX(), myy = robot.getY();
		double bulletv = 20-3*power;
		double wamba = target.getRecentAverageAngularVelocity();
		double vel = target.getRecentAverageVelocity();
		double heading = target.getHeading();
		double bulletdistance = 0;
		double ex = target.getX();
		double ey = target.getY();
		while(bulletdistance < Math.sqrt((ex-myx)*(ex-myx)+(ey-myy)*(ey-myy)))
		{
			bulletdistance += bulletv;
			heading += wamba;
			ex += vel*Math.sin(heading);
			ey += vel*Math.cos(heading);
			if (ex < 18 || ex > robot.getBattleFieldWidth()-18 || ey < 18 | ey > robot.getBattleFieldHeight()-18)
			{
				double timeAvailable = bulletdistance/bulletv;
				double neededspeed = Math.sqrt((ex-myx)*(ex-myx)+(ey-myy)*(ey-myy))/timeAvailable;
				if (neededspeed <= 19.7)
					power = (20-neededspeed)/3;
				else
					power = .1;
				break;	//hit the wall
			}
		}
		double theta = Math.atan2(ex-myx, ey-myy);
		return new ChooserBullet(target.getName(), myx, myy, theta, power, this, robot.getTime());
	}
}
