package ags.rougedc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;

import robocode.Event;

import ags.rougedc.painters.*;
import ags.rougedc.base.*;
import ags.rougedc.movement.Surfing;
import ags.rougedc.radar.BasicRadar;
import ags.rougedc.gun.FlammeRouge;

/**
 * @author Alexander Schultz
 */
public class RougeDC extends InformedBotBase {
    private BasicRadar radar;
    private Surfing surf;
    private FlammeRouge gun;
    
    @Override
    public void init() {
        super.init();
        
        // Set colors
        this.setColors(new Color(200, 0, 15), // Body color
                       new Color(235, 110, 0), // Scan color
                       new Color(167, 50, 104), // Gun color
                       new Color(255, 152, 23)); // Radar color
        
        radar = new BasicRadar(getStatus(), getEnemies());
        surf = new Surfing(getRules(), getStatus(), getEnemies(), getEnemyWaveManager());
        gun = new FlammeRouge(getRules(), getStatus(), getEnemies());
    }

    /* (non-Javadoc)
     * @see ags.rougedc.base.BotBase#runTick(java.util.List)
     */
    @Override
    public void runTick(List<Event> events) {
        super.runTick(events);
        
        radar.run(getRadarActor());
        surf.run(getMovementActor()); // TURN OFF FOR TC2K7
        //final long t = System.nanoTime();
        gun.run(getGunActor());
        //System.out.println("Gun time:"+(System.nanoTime() - t));
    }
    
    @Override
    public void _onPaint(Graphics2D g) {
        WavePainter.paint(g, Color.RED, getEnemyWaveManager().getAll());
        GraphPainter.paintEnemyProfile(g, 1, 1, 70, 250, gun);
        WavePainter.paint(g, Color.CYAN, gun.getWaves());
    }
    
    // RAIKO TC TEST BELOW - Uncomment to test raiko gun in a targeting challenge
    /*
    private ags.rougedc.gun.RaikoTCGun raiko;
    
    @Override
    public void run() {
        raiko = new ags.rougedc.gun.RaikoTCGun(this);
        raiko.run();
    }
    
    @Override
    public void onScannedRobot(robocode.ScannedRobotEvent e) {
        raiko.onScannedRobot(e);
    }
    */
}
