/*
 * Created on Nov 27, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package dans;



import robocode.*;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashMap;


/**
 * @author Danny
 *
 * Cinnamon.java
 * Created on Nov 27, 2003
 * 
 */
public class Cinnamon extends AdvancedRobot {
AGravEngine testEngine; //The AntiGrav Engine, Described in AGravEngine.java
static Enemy CurTarget=new Enemy();//The Current Target, See Enemy Class
double lastEnergy=0;
double lastBearing=0;
double lastHeading=0;
static double hits=0;
static double misses=0;
static double shots=0;
static double hitBullet=0;
static HashMap enemyBox=new HashMap();
public int MAX_VELOCITY;

	public void run(){ 
		MAX_VELOCITY=8;
		Color cinnamon=new Color(170,90,5);
		setColors(cinnamon,cinnamon,cinnamon);
		testEngine= new AGravEngine(getBattleFieldWidth(),getBattleFieldHeight());// declares the AntiGrav Engine and gives it the height and width of the battle field
		testEngine.setWallForce(1000000000.0); //sets the force of the walls
		testEngine.setWallDropoff(1.1);//sets the drop off distance for the walls
		testEngine.setPointDropoff(0.2);//sets the drop off distance for the GravPoints
		GravPoint centerPoint; // A GravPoint in the Center of the battle field
		GravPoint corner1, corner2, corner3, corner4; // Corner GravPoints
		centerPoint= new GravPoint((getBattleFieldWidth()/2),(getBattleFieldHeight()/2), -500000.0);// declares the GravPoints...
		corner1=new GravPoint(0,0,-50000.0);//...
		corner2=new GravPoint(0,getBattleFieldHeight(),-50000.0);//...
		corner3=new GravPoint(getBattleFieldWidth(),0,-50000.0);//...
		corner4=new GravPoint(getBattleFieldWidth(),getBattleFieldHeight(),-50000.0);//...
		testEngine.addPoint(corner1,corner2,corner3,corner4);//Adding GravPoints...
		testEngine.addPoint(centerPoint);//...
		setAdjustGunForRobotTurn(true);//set the Gun to adjust for the turning of the robot
		setAdjustRadarForGunTurn(true);
		setTurnRadarRight(Double.POSITIVE_INFINITY);		
		do{
			doAGMove();
			execute();
			
		}while(true);
		
	}
	/**
	 * What happens upon detecting another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e){	
		if(enemyBox.containsKey(e.getName())){
			Enemy t= new Enemy();
			t.setTo((Enemy)enemyBox.get(e.getName()));
			enemyBox.remove(e.getName());
			t.update(getX(),getY(),RobocodeUtils.calcPoint(RobocodeUtils.normalizeHeading(e.getBearingRadians()+getHeadingRadians()),getX(),getY(),e.getDistance()),getTime(),e.getHeadingRadians(),e.getEnergy(),e.getVelocity(),getHeading());
			enemyBox.put(t.getName(),t);
			CurTarget.setTo(t);
		}
		else{
			Enemy t= new Enemy(getX(),getY(),RobocodeUtils.calcPoint(RobocodeUtils.normalizeHeading(e.getBearingRadians()+getHeadingRadians()),getX(),getY(),e.getDistance()),e.getName(),getTime(),e.getHeadingRadians(),e.getEnergy(),e.getVelocity());
			enemyBox.put(t.getName(),t);
			CurTarget.setTo(t);
		}
		setTurnRadarLeft(getRadarTurnRemaining());
		double[] veloArray=new double[50000];
		veloArray=CurTarget.getVeloArray();
		int count=CurTarget.getCount();
		double targetBearing = e.getBearingRadians() + getHeadingRadians();
		int pointer = (int) (e.getVelocity()*Math.sin(e.getHeadingRadians()-targetBearing));
		StringBuffer pattern=new StringBuffer();
		pattern.append(CurTarget.getPattern());	
		int len = 30;
		do { pointer = pattern.lastIndexOf(pattern.substring(Math.max(pattern.length()-len,0)),pattern.length()-100);
		} while (--len*pointer < -1); 
		pointer += len;
		setTurnGunRightRadians(Math.sin(((veloArray[Math.min(pointer + (int)e.getDistance() /(int) Math.round(20-(3*Math.max(Math.min(e.getEnergy()/4,3),0.1))), count)] - veloArray[pointer]) / e.getDistance () + targetBearing) - getGunHeadingRadians()));
		if(getEnergy()>Math.min(e.getEnergy()/4,3)){ 
			setFire(e.getEnergy()/4);
	}
		if(lastEnergy-e.getEnergy()>=0.1&&lastEnergy-e.getEnergy()<=3){
			GravPoint firePoint1= new GravPoint(RobocodeUtils.calcPoint(RobocodeUtils.normalizeHeading(e.getBearingRadians()+getHeadingRadians()),getX(),getY(),e.getDistance()/5).getX(),RobocodeUtils.calcPoint(RobocodeUtils.normalizeHeading(e.getBearingRadians()+getHeadingRadians()),getX(),getY(),e.getDistance()/5).getY(),RobocodeUtils.randomInRange(-25000,-1000000),getTime(),5);
			GravPoint firePoint2= new GravPoint(RobocodeUtils.randomInRange(getX()+100,getX()-100),RobocodeUtils.randomInRange(getY()+100,getY()-100),RobocodeUtils.randomInRange(-25000,-1000000),getTime(),5);
			testEngine.addPoint(firePoint1,firePoint2);
			lastEnergy=e.getEnergy();	
		}
	}
	/**Calculates the  point that the robot should move to 
	*/
	public void doAGMove() {
		int randNum=(int)(Math.round(10*Math.random()));
		if(randNum>=3&&randNum<=7){
		}
		else if(randNum<3){
			if(MAX_VELOCITY!=4){
			MAX_VELOCITY--;
			}
		}
		else if(randNum>7){
			if(MAX_VELOCITY!=8){
				MAX_VELOCITY++;
			}
		}
		setMaxVelocity(MAX_VELOCITY);
		double x=getX();
		double y=getY();		
		GravPoint randomPoint1= new GravPoint(RobocodeUtils.randomInRange(getBattleFieldWidth(),0),RobocodeUtils.randomInRange(getBattleFieldHeight(),0),RobocodeUtils.randomInRange(-25000,-1000000),getTime(),5);
		GravPoint randomPoint2= new GravPoint(RobocodeUtils.randomInRange(getBattleFieldWidth(),0),RobocodeUtils.randomInRange(getBattleFieldHeight(),0),RobocodeUtils.randomInRange(-25000,-1000000),getTime(),5);
		GravPoint randomPoint3= new GravPoint(RobocodeUtils.randomInRange(getBattleFieldWidth(),0),RobocodeUtils.randomInRange(getBattleFieldHeight(),0),RobocodeUtils.randomInRange(-25000,-1000000),getTime(),5);
		testEngine.addPoint(randomPoint1,randomPoint2);		
		testEngine.addPoint(randomPoint3);
		testEngine.update(x,y,getTime());
		Point2D destination=new Point2D.Double(x-testEngine.getXForce(),y-testEngine.getYForce());
		
		goTo(destination);
	
	}
	/**Calculates in what direction and how far the robot should move
	*/
	private void goTo(Point2D destination) {
		Point2D location = new Point2D.Double(getX(), getY());
		double distance = location.distance(destination);
		double angle = normalRelativeAngle(absoluteBearing(location, destination) - getHeadingRadians());
		if (Math.abs(angle) > 90) {
			distance *= -1;
			if (angle > 0) {
				angle -= 180;
			}
			else {
				angle += 180;
			}
		}
		
		setTurnRightRadians(angle);
		setAhead(distance);
	
	
	}
	/**	The following 5 Methods calculate the hit percent for the battle so far, onBulletHit(),onBulletMissed(),onBulletHitBullet(),onDeath(),onWin().
	*/
	public void onBulletHit(BulletHitEvent e){
		hits++;
		shots++;
	}
	public void onBulletMissed(BulletMissedEvent e){
		misses++;
		shots++;
	}
	public void onBulletHitBullet(BulletHitBulletEvent e){
		misses++;
		hitBullet++;
		shots++;
	} 
	public void onDeath(DeathEvent e){
		double hitPercent=Math.round((hits/shots)*100);	
		double bulletToBulletPer=Math.round((hitBullet/shots)*100);
		double missPercent=Math.round((misses/shots)*100);
		System.out.println("We shot "+shots+" times.");
		System.out.println("We hit "+hits+" times.");
		System.out.println("We missed "+misses+" times.");
		System.out.println("We hit other bullets "+hitBullet+" times.");
		System.out.println("We hit " + hitPercent+" % of the time.");
		System.out.println("We missed " + missPercent+" % of the time.");
		System.out.println("We hit other bullets "+bulletToBulletPer+" % of the time.");
		System.out.println("We had a "+hits/misses+" hit/miss ratio.");
	}
	public void onWin(WinEvent e){
		double hitPercent=Math.round((hits/shots)*100);	
		double bulletToBulletPer=Math.round((hitBullet/shots)*100);
		double missPercent=Math.round((misses/shots)*100);
		System.out.println("We shot "+shots+" times.");
		System.out.println("We hit "+hits+" times.");
		System.out.println("We missed "+misses+" times.");
		System.out.println("We hit other bullets "+hitBullet+" times.");
		System.out.println("We hit " + hitPercent+" % of the time.");
		System.out.println("We missed " + missPercent+" % of the time.");
		System.out.println("We hit other bullets "+bulletToBulletPer+" % of the time.");
		System.out.println("We had a "+hits/misses+" hit/miss ratio.");
		stop();
		turnGunRight(getHeading()-getGunHeading());
		for(int f=0;f<=10;f++){
		turnRadarLeft(30);
		ahead(20);
		turnRight(30);
		turnLeft(30);
		ahead(20);
		turnLeft(30);
		turnRight(30);
		}
	}
	/**Turns an angle like 540 degrees into a number between -180 thru 180
	*/
	private double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
	/**Turns an angle like 540 degrees into a number between 0-360
	*/
	private double normalRelativeAngle(double angle) {
		return Math.atan2(Math.sin(angle), Math.cos(angle)); 
	}
  
}



