package sch;

import robocode.*;
import java.util.*;

public class AntiGravityStrategy extends SimpleStrategy implements Constants {

	private final String strategyName="Anti Gravity Strategy";
	private double timeCounter;
	private double goodness;
	private List randGravPointList;
	private double fieldHeight;
	private double fieldWidth;
	
	public AntiGravityStrategy () {
		super();
		timeCounter=0;
		randGravPointList=new ArrayList();
	}
	
	public void initialize () {
		fieldHeight=myBot.getBattleFieldHeight();
		fieldWidth=myBot.getBattleFieldWidth();
	}
	public void reinitialize () {
		timeCounter=0;
		randGravPointList=new ArrayList();
		fieldHeight=myBot.getBattleFieldHeight();
		fieldWidth=myBot.getBattleFieldWidth();
	}
	
	public String getName() {return strategyName;}
	
	public void setMovement() {
		List gravPointList;
		GravPoint currGravPoint;
		double gravityPower;
		

		gravPointList=new ArrayList();
		Bot target=enemyManager.getCurrentTarget();
		for (Iterator i=enemyManager.getEnemyList().values().iterator();i.hasNext();) {
			Bot currentBot=(Bot) i.next();
			if (currentBot.isAlive()) {
				if (currentBot==target)
					gravityPower=TARGET_GRAVITY_FACTOR;
				else
					gravityPower=ENEMY_GRAVITY_FACTOR;
				currGravPoint=new GravPoint(currentBot.getPos().x,currentBot.getPos().y,gravityPower,BOT_GRAV_POINT);
				gravPointList.add(currGravPoint);
			}
		}
		
		//Randomic gravity point

		if (timeCounter==RANDOM_POINT_CHANGE_INTERVAL){
			randGravPointList=new ArrayList();
			double randX;
			double randY;
			for (int i=0;i<RANDOM_POINT_NUM;i++) {
				randX=Math.random()*fieldHeight;
				randY=Math.random()*fieldWidth;
				gravityPower=RANDOM_POINT_MIN_POWER+Math.random()*(RANDOM_POINT_MAX_POWER-RANDOM_POINT_MIN_POWER);
				currGravPoint=new GravPoint(randX,randY,gravityPower,RANDOM_GRAV_POINT);
				randGravPointList.add(currGravPoint);
			}
			timeCounter=0;
		}
		timeCounter++;
		
		gravPointList.addAll(randGravPointList);

		
		//Center gravity point
		
		gravityPower=((myBot.getOthers()*1000)/(fieldHeight*fieldWidth))*CENTER_DENSITY_GRAVITY_FACTOR;
		currGravPoint=new GravPoint(fieldHeight/2,fieldWidth/2,-gravityPower,CENTER_GRAV_POINT);
		gravPointList.add(currGravPoint);
		
		
   		double xforce = 0;
	    double yforce = 0;
	    double force;
	    double targetBearing;
		
		if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) System.out.println("------------------------------");
		for (Iterator i=gravPointList.listIterator();i.hasNext();) {
			currGravPoint=(GravPoint) i.next();
			if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) System.out.println(currGravPoint);
			force=currGravPoint.getPower()/Math.pow(BotMath.getRange(myBot.getX(),myBot.getY(),currGravPoint.getX(),currGravPoint.getY()),currGravPoint.getType());
			targetBearing=BotMath.absBearing(myBot.getX(), myBot.getY(), currGravPoint.getX(),currGravPoint.getY());
		    xforce += Math.sin(targetBearing) * force;
		    yforce += Math.cos(targetBearing) * force;
		}

	    xforce += -5000/Math.pow(myBot.getBattleFieldWidth() - myBot.getX(), 3);
	    xforce += 5000/Math.pow(myBot.getX(), 3);
	    yforce += -5000/Math.pow(myBot.getBattleFieldHeight() - myBot.getY(), 3);
	    yforce += 5000/Math.pow(myBot.getY(), 3);		
	
		goTo(myBot.getX()+xforce,myBot.getY()+yforce);
		gravPointList=null;
	}

	public double getGoodness() {
		if (myBot.getOthers()!=0)
			return 10.0;
		else
			return 0.0;
		}

}