package cjm.chalk;

import robocode.*;

public class TreeGun extends BaseGun {
	
	static final double BAND_WIDTH = 6.0d;
	
	Tree _tree;
	java.awt.geom.Rectangle2D.Double _walls;	
	AdvancedRobot _robot;	
	double[] _weights;
	
	public int Count = 0;
	
	public TreeGun(AdvancedRobot robot){
		_tree = new Tree(
				new int[] { 
						Scan.LAT_VEL, 
						Scan.ADV_VEL,
						Scan.ACCEL, 
						Scan.VEL_CHNG, 
						Scan.DIST, 
						Scan.WALL_F, 
						Scan.WALL_B
						}, 				
				100,
				new double[] { 0.5d, 0.0d, 0.5d, 0.5d, 0.5d, 0.5d, 0.5d}
				);	
		_weights = new double[] { 1d, 1d, 1d, 1d, 1d, 1d, 1d};
		_walls = new java.awt.geom.Rectangle2D.Double(10d, 10d, robot.getBattleFieldWidth() - 20d, robot.getBattleFieldHeight() - 20d);
		_robot = robot;
	}	

	@Override
	void addScan(Scan s) {
		_tree.addDataNode(s);
		Count++;	
	}


	@Override
	double projectBearing(Scan scan, double x, double y, double enemyHeading) {			
		
		double theBearing, projectedX, projectedY, projectedDistance;
		double distance = scan.Distance;
		Scan[] bestNodes = _tree.getCluster(scan, 50, _weights);
		int results = 0;
		for(int i = 0; i < bestNodes.length; i++){
			if(bestNodes[i] != null){
				results++;
			}
		}
		
		if(results > 0){
			
			//calculate density on observed bearings
			int bestIndex = 0;
			double bestDensity = 0;
			
			for(int i = results; --i >= 0;){
				
				double density = 0;
				double u;
				for(int j = results; --j >= 0;){
					density += Math.exp(
								(
									u = (bestNodes[i].Bearing - bestNodes[j].Bearing) / BAND_WIDTH
								) 
								* u 
								* -0.5d
							);
				}		
			
				
				if(density > bestDensity){
					bestDensity = density;
					bestIndex = i;
				}
			}				
				
			theBearing = (bestNodes[bestIndex].BearingRadians * scan.MaxAngle) / bestNodes[bestIndex].MaxAngle;
			projectedDistance = distance + bestNodes[bestIndex].DistanceDelta;
			projectedX = x + Math.sin(enemyHeading + theBearing) * projectedDistance;
			projectedY = y + Math.cos(enemyHeading + theBearing) * projectedDistance;
			if(_walls.contains(projectedX, projectedY)){
				return theBearing;
			}
		
		}
		return Double.MAX_VALUE;
	}

}
