package simonton;

import robocode.*;
import robocode.util.*;

// This uses guess factors like GFNano, but distances itself instead of
// segmenting on distance.  
//
// Version 2.0: now segements on average accelleration over the last n ticks!
// 				codesize: 249.
//
// Version 2.1: segementing on lateral velocity now, instead of velocity.
//			    smoother, less aggressive distancing (for codesize).
//				codesize: 248.
//
// Version 2.2: still smooth, but now *more* agressive distancing.
//				conserve energy until getting closer to our target.
//				picked up some space by constructing needed segment on the fly.
//				now a SlowBot.
//				codesize: 249.
//
// Version 3.1: back to smaller (less agressive) distancing.
//				junked energy management.
//				squeezed GF codesize a bit more.
//				no more cannibalism!
//				codesize: 249.
public class GFNano_D extends AdvancedRobot {
	static final int numSegments = 2;
	static final double firePower = 3;
	static final double fireSpeed = 20 - 3 * firePower;
	// best as a multiple of fireSpeed
	static final double targetDistance = 220; 
	static final double enemyBulletSpeed = 11;
	static final double travel = (8 * targetDistance / enemyBulletSpeed - 16);
	static final double maxAttack = 35 * Math.PI / 180;
	// WARNING: hangTime MUST be at least 17!! (to accomodate all enemy speeds)
	static final int hangTime = (int) (targetDistance / fireSpeed);
	
	static StringBuilder enemyHistory = new StringBuilder();
//	static int mDir = 3;

	public void run() {
		setAdjustGunForRobotTurn(true);
		setTurnRadarRight(Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		double tmp;
 		int gf, start, cur, total;
 		int[] gfs;
 		
 		// fire.
 		setFire(3);
// 		setFire(700 / (tmp = e.getDistance()));
		
 		// move.
		setTurnRightRadians(
//			Math.atan2(targetDistance - e.getDistance(), 5) 
////			Math.atan2(targetDistance - tmp, 5) 
//				* (tmp = e.getVelocity())
//				* (maxAttack / (Math.PI / 2) / 8)
//			Math.signum(targetDistance - e.getDistance()) 
////			Math.signum(targetDistance - tmp) 
//				* getVelocity() 
////				* (tmp = e.getVelocity()) 
//				* (maxAttack / 8)
			(targetDistance - e.getDistance()) * getVelocity() / 6000
//			(targetDistance - tmp) * (tmp = getVelocity()) / 6000
//			+ Math.cos(e.getBearingRadians()));
			+ Math.cos(tmp = e.getBearingRadians()));
// 		setAhead(e.getVelocity() * mDir);
// 		setAhead(tmp * 3);
		if (getDistanceRemaining() == 0) {
			setAhead((Math.random() - .5) * (2 * travel));
		}

 		// memorize.
		StringBuilder history = 
			enemyHistory.insert(
				0,
				(char) (
					gf = 
						(int) (
//							tmp 
							e.getVelocity() 
								* Math.sin(
						    		e.getHeadingRadians() 
//						    		- (	tmp = 
//						    				e.getBearingRadians()
//						    				+ getHeadingRadians())))
						    		- (	tmp += getHeadingRadians())))
			            + 8));

		// think.
		gfs = new int[start = hangTime];
//		gfs = new int[(int) (e.getDistance() / hangTime)];
		try {
			do {
				start = 
					history.indexOf(
						history.substring(0, numSegments), start + 1);
				total = cur = 0;
				try {
					do {
						if (gfs[gf] < gfs[cur]) {
							gf = cur;
						}
//						if (gfs[gf] <= gfs[cur]) {
//							setTurnGunRightRadians(
//								Utils.normalRelativeAngle(
//									tmp 
//									+ ((gf = cur) - 8) / fireSpeed 
//									- getGunHeadingRadians()));
//						}
						total += history.charAt(start - ++cur);
					} while (true);
				} catch (ArrayIndexOutOfBoundsException doneLooping) {}
				++gfs[total / hangTime];
			} while (true);
		} catch (StringIndexOutOfBoundsException doneSearching) {}
		
		// aim.
		setTurnGunRightRadians(
			Utils.normalRelativeAngle(
				tmp + (gf - 8) / fireSpeed - getGunHeadingRadians()));
		
		// look.
		setTurnRadarLeft(getRadarTurnRemaining());
	}
//	
//	public void onHitWall(HitWallEvent e) {
//		mDir = -mDir;
//	}
}
