package ag.battledata;

import ag.Gir;

import java.util.Iterator;
import java.util.Vector;

/**
 * Manages the battle Data
 * @author Andree Grosse
 */
public class DataBattle
{
	private Gir mGir;
	private Vector<DataRobot> mRobots;
	
	/**
	 * Constructor
	 */
	public DataBattle(Gir gir){
		mGir = gir;
		mRobots = new Vector<DataRobot>();
		addNewRobot(mGir.getName(), 100.0, false);
	}
	//	 ####################### setter & getter #######################
	
	/**
	 * Returns the 'Robots' vector
	 * @return the 'Robots' vector 
	 */
	public Vector<DataRobot> getRobots(){
		return mRobots;
	}
		
	// ######################### public #########################

	/**
	 * Adds a data-snapshot to a robot's data vector
	 * @return The DataRobot object for the robot "name"
	 */
	public DataRobot addDataRobotSnapshot(String name, long tick, double x, double y, 
			DataVector direction, double velocity, double energy) {

		DataRobot robot = getRobotByName(name);
		
		// add snapshot if this is new data
		if(robot.getData().isEmpty() || tick > robot.getData().lastElement().getTick()){
			DataRobotSnapshot snap = new DataRobotSnapshot(tick, x, y, 
					direction, velocity, energy);
			robot.addDataRobotSnapshot(snap);
		}
		return robot;
	}
	
	/**
	 * Retrieves the DataRobot Object for an robot
	 * @param name The robots name
	 * @return The DataRobot-Object if it exists, otherwise null
	 */
	public DataRobot getRobotByName(String name){
		DataRobot robot;
  		Iterator<DataRobot> i = mRobots.iterator();
  		while (i.hasNext()){
			robot = i.next();
    		if(name.equals(robot.getName()))			
				return robot;
		}
  		// Robot does not exist (so it must be an enemy) - create a new one
  
  		return addNewRobot(name, 100.0, !mGir.isTeammate(name));
	}
	
	/**
	 * Removes old snapshots from a robots data vector if
	 * there are more than 40 snapshots
	 */
	public void removeOldData() {
  		Iterator<DataRobot> i = mRobots.iterator();
  		DataRobot robot;
  		while (i.hasNext()){
  			robot = i.next();
  			if(robot.getDead() && robot.getVirtualBullets().size() == 0){
  	  			// remove robot if he is dead and all his bullets are gone
  				i.remove();
  			}
  			else{
  				// remove old data if there is too much
  				robot.removeOldData();
  			}
		}
	
	}
		
	/**
	* Adds a Robot - the robot must not exist in the dataset
	*/
	public DataRobot addNewRobot(String name, double energy, boolean enemy){
		DataRobot robot = new DataRobot(name, enemy); 

		if(enemy){
			mGir.getMovement().readDodgeNet(robot);
			mGir.getMovement().writeDodgeDataFile(robot);
		}
		mRobots.add(robot);
		
		return robot;
	}	
	
	// ######################### private #########################


	
}
