package jk.precise.move;

import jk.precise.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;

import robocode.*;
import robocode.util.Utils;

import jk.mega.KDTree;

public class PreciseSurfDC {
   static final boolean LEARN_FROM_MISSES = false;
   static final double MISS_WEIGHT = 5;
   
   static final boolean DISABLE_PRECISE_WALL_HITS = true;
   //makes funny things happen with wallsmoothing
	
  
   
   static double[] weightWeights = new double[]{1, 1, 1};
   static final double[][] weights = new double[][]{
      {//anti-simple-guns
            10,//latVel
            4,//advVel
            2,//dist
            1,//accel
            0,//dl10
            2,//forWall
            0,//revWall
            0,//tsdChange
            0,//tsDecel
         	0//time
         	   }
         		,
         {//anti-simple-gf-guns
            10,//latVel
            0,//advVel
            3,//dist
            5,//accel
            0,//dl10
            4,//forWall
            0,//revWall
            0,//tsdChange
            3,//tsDecel
         	10//time
         	   }
         		,
         {//anti-complex-guns
            10,//latVel
            4,//advVel
            4,//dist
            7,//accel
            2,//dl10
            5,//forWall
            2,//revWall
            3,//tsdChange
            3,//tsDecel
         	1//time
         	   }
      		};



   MoveState current;
   AdvancedRobot bot;
   
   static KDTree.WeightedManhattan<TreeScan> hitsTree = new KDTree.WeightedManhattan<TreeScan>(10/*dimensions*/);
   static KDTree.WeightedManhattan<HitRange> missesTree = new KDTree.WeightedManhattan<HitRange>(10/*dimensions*/);
   
   static int bulletInteractions = 0;
   static double bulletInteractionsWeight = bulletInteractions*(bulletInteractions + 1);
   static int bulletsHit = 0;
   static int bulletsMissed = 0;
   
   ArrayList<DCWave> waves;
   
   Rectangle2D.Double field = new Rectangle2D.Double(18,18,800 - 18*2, 600 - 18*2);
   
   double enemyEnergy = 100;
   Point2D.Double pivotPoint;
   
   ArrayList<Point2D.Double> paintPoints = new ArrayList<Point2D.Double>();
   ArrayList<WaveHitRange> paintRanges = new ArrayList<WaveHitRange>();

   public PreciseSurfDC(AdvancedRobot bot){
      this.bot = bot;
      waves = new ArrayList<DCWave>();
      System.out.print("move weights: ");
      for(int i = 0; i < weightWeights.length; i++)
         System.out.print(((int)(weightWeights[i]*10000)/100.0) + "   ");
      System.out.println("\nenemy hitrate: " + (int)(bulletsHit*10000.0/(bulletsHit + bulletsMissed))/100.0 + "%");
   }
   public void noScanTick(){
   
      MoveState ms = new MoveState(current);
      ms.position = new Point2D.Double(bot.getX(), bot.getY());
      ms.velocity = bot.getVelocity();
      ms.heading = bot.getHeadingRadians();
      ms.enemyPosition = current.enemyPosition;
      ms.distance = ms.position.distance(ms.enemyPosition);
      ms.bearing = Trig.absoluteBearing(ms.position,ms.enemyPosition);
      ms.treeLocation = current.treeLocation;
      ms.time = bot.getTime();
      double latVel = ms.velocity*Trig.sin(ms.bearing - ms.heading);
      if(latVel != 0.0)
         ms.direction = Math.signum(latVel);
      else
         ms.direction = ms.getXBack(1).direction;
         
      current = ms;
      updateWaves(0);
      move();
   
   }

   public void onScannedRobot(ScannedRobotEvent e){
      updateState(e);
      updateWaves(enemyEnergy - (enemyEnergy = e.getEnergy()));
      // double hitrate = bulletsHit*100.0/(bulletsHit + bulletsMissed);
      // if(hitrate < 4 && bot.getRoundNum() > 5)
         // LEARN_FROM_MISSES = true;
      // else
         // LEARN_FROM_MISSES = false;
      move();
   }
   public void onHitByBullet(HitByBulletEvent e){
   
      bulletsHit++;
      
      logEnemyBullet(e.getBullet(), false);
   
      enemyEnergy += e.getBullet().getPower()*3;
   
   }  
   public void onBulletHitBullet(BulletHitBulletEvent e){
   
      logEnemyBullet(e.getHitBullet(), true);
   
   }  
   public void onBulletHit(BulletHitEvent e){
      double power = e.getBullet().getPower();
      double damage = 4*power;
      if(power > 1)
         damage += 2*(power - 1);
         
      enemyEnergy -= damage;
   
   }
   public void onHitRobot(HitRobotEvent e){
      enemyEnergy -= 0.6;
   }
   public void onPaint(java.awt.Graphics2D g) {
      // g.setColor(Color.red);
      // if(pivotPoint != null)
         // g.drawOval((int)(pivotPoint.x - 1),(int)(pivotPoint.y - 1), 2, 2);
         
      g.setColor(Color.white);
      Iterator<Point2D.Double> it = paintPoints.iterator();
      while(it.hasNext()){
         Point2D.Double p = it.next();
         g.drawOval((int)(p.x - 1),(int)(p.y - 1), 2, 2);
      }
      paintPoints.clear();
      
   
   	
      if(waves != null){
         Iterator<DCWave> i = waves.iterator();
         while(i.hasNext()){
            DCWave w = i.next();
            if(!w.surfable)
               continue;  
         	
            final double width = 0.01;
         	
            double maxDanger = 0;
            for(double d = -1; d < 1; d +=width){
               maxDanger = Math.max(maxDanger,getDanger(d,w));
            }
            // g.drawString("max danger:" + maxDanger,100*waves.indexOf(w),35);
           
            for(double d = -1; d <= 1; d += width){
               double danger = getDanger(d,w)/maxDanger;
               if(danger > 0.9)
                  g.setColor(Color.red);
               else if(danger > 0.6)
                  g.setColor(Color.orange);
               else if(danger > 0.3)
                  g.setColor(Color.yellow);
               else if(danger > 0.1)
                  g.setColor(Color.green);
               else if(danger > 0)
                  g.setColor(Color.blue);
               else
                  g.setColor(Color.white);
            
            
            
               Point2D.Double p1 = Trig.project(w.firePosition,
                  w.bearing + (d - width/2)*w.MEA*w.direction,
                  w.distanceTraveled);
               Point2D.Double p2 = Trig.project(w.firePosition,
                  w.bearing + (d + width/2)*w.MEA*w.direction,
                  w.distanceTraveled);
               g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
            }
         }  
      }
      
      if(paintRanges.size() > 0){
         g.setColor(Color.white);
         Iterator<WaveHitRange> i = paintRanges.iterator();
         while(i.hasNext()){
            WaveHitRange hr = i.next();
            DCWave w = hr.wave;
            Point2D.Double p1 = Trig.project(w.firePosition,
                  w.bearing + hr.minGF*w.MEA*w.direction,
                  w.distanceTraveled - w.bulletVelocity);
            Point2D.Double p2 = Trig.project(w.firePosition,
                  w.bearing + hr.maxGF*w.MEA*w.direction,
                  w.distanceTraveled - w.bulletVelocity);
            g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
         }  
         paintRanges.clear();
      }
   	
   }
   void move(){
      ArrayList<DCWave> surfableWaves = getSurfableWaves();
      if(surfableWaves.size() > 0)
         doSurfing(surfableWaves);
      else
         doOrbitalMovement();
   }
   int minDangerDir = 1;
   void doSurfing(ArrayList<DCWave> surfableWaves){
   
      double dangerForward,dangerStopped, dangerReverse;
   //direction - forward
      switch(minDangerDir){
         case 1:
            dangerForward = getDanger(surfableWaves,1, Double.POSITIVE_INFINITY);
            dangerStopped = getDanger(surfableWaves,0, dangerForward);   
            dangerReverse = getDanger(surfableWaves,-1, Math.min(dangerForward,dangerStopped));
            break;
         case -1:
            dangerReverse = getDanger(surfableWaves,-1, Double.POSITIVE_INFINITY);
            dangerStopped = getDanger(surfableWaves,0, dangerReverse);   
            dangerForward = getDanger(surfableWaves,1, Math.min(dangerReverse,dangerStopped));
            break;
         default:
            dangerStopped = getDanger(surfableWaves,0, Double.POSITIVE_INFINITY); 
            dangerForward = getDanger(surfableWaves,1, dangerStopped);
            dangerReverse = getDanger(surfableWaves,-1, Math.min(dangerForward,dangerStopped));
      
      }
               
      
      // System.out.println("stopped danger: " + dangerStopped);
   		
      // {
      //    
      //   
         // double minTimeToHit = Double.POSITIVE_INFINITY;
         // Iterator<DCWave> i = surfableWaves.iterator();
         // while(i.hasNext()){
            // DCWave w = i.next();
            // double timeToHit = current.position.distance(w.firePosition)/w.bulletVelocity
               //  + (w.fireTime - current.time);
            // if(timeToHit < minTimeToHit){
               // pivotPoint = w.firePosition;
               // minTimeToHit = timeToHit;
            // }
         // }
      // }
      pivotPoint = current.enemyPosition;
      boolean move = true;
      double goAngle = Trig.absoluteBearing(pivotPoint, current.position);
      
      if(dangerForward == dangerReverse && dangerReverse == dangerStopped){
         
         DCWave closest = null;
         double minTimeToHit = Double.POSITIVE_INFINITY;
         Iterator<DCWave> i = surfableWaves.iterator();
         while(i.hasNext()){
            DCWave w = i.next();
            double timeToHit = current.position.distance(w.firePosition)/w.bulletVelocity
                + (w.fireTime - current.time);
            if(timeToHit < minTimeToHit){
               closest = w;
               minTimeToHit = timeToHit;
            }
         }
         if(closest != null){
            surfableWaves.remove(closest);
            // System.out.println("removing wave from surf");
         }
         if(surfableWaves.size() == 0)
            doOrbitalMovement();
         else
            doSurfing(surfableWaves);
         return;
      }
      else
         if(dangerForward <= dangerReverse && dangerForward <= dangerStopped){
            goAngle = Trig.wallSmoothing(current.position, goAngle + getOffset(current.distance), 1);
            minDangerDir = 1;  
         	// System.out.println("going right");
         }
         else if(dangerReverse <= dangerForward && dangerReverse <= dangerStopped){
            goAngle = Trig.wallSmoothing(current.position, goAngle - getOffset(current.distance), -1);
            minDangerDir = -1;
            // System.out.println("going left");
         }	
         else// if(dangerStopped <= dangerForward && dangerStopped <= dangerReverse)
         {
            goAngle = Trig.wallSmoothing(current.position, goAngle + current.direction*getOffset(current.distance), current.direction);
            move = false;
            minDangerDir = 0;
            // System.out.println("going 'stop'");
         }
      
      setBackAsFront(goAngle,move);
   }
   void doOrbitalMovement(){
      double headingRadians = current.heading;
      double stick =Math.max(121,Math.min(current.distance,160));
      double  goAngle, revGoAngle, revOffset, offset;
      offset = revOffset = Math.PI/2 + (current.distance<500?1-
         current.distance/500:-0.01);
      Point2D.Double endPoint, revEndPoint;
      int count = 0;
   
      while(!field.
         contains(Trig.project(current.position,goAngle = current.bearing - current.direction*(offset -= 0.02), stick))
          && count++ < 50);
      endPoint = Trig.project(current.position,goAngle, 8);
      
   	
      int revCount = 0;
      	 
      while(!field.
         contains(Trig.project(current.position,revGoAngle = current.bearing + current.direction*(revOffset -= 0.02), stick))
          && revCount++ < 50);
      revEndPoint = Trig.project(current.position,revGoAngle, 8);
      
   
      if( offset < revOffset){
         goAngle = revGoAngle;
      }
      
      bot.setAhead(50*Trig.cos(goAngle -= headingRadians));
      bot.setTurnRightRadians(Math.tan(goAngle));
   
   }
   void setBackAsFront(double goAngle, boolean move) {
      double angle = Utils.normalRelativeAngle(goAngle - current.heading);
      if (Math.abs(angle) > (Math.PI/2)) {
         if (angle < 0) 
            bot.setTurnRightRadians(Math.PI + angle);
         else 
            bot.setTurnLeftRadians(Math.PI - angle);
         
         if(move)
            bot.setBack(100);
      } 
      else {
         bot.setTurnRightRadians(angle);
         if(move)
            bot.setAhead(100);
      }
      if(!move)
         bot.setAhead(0);
   }

   double getOffset(double distance){
      return (Math.PI/2 - 1) + (1/475.0)*Math.max(200,distance);
   }
	
	//CREDIT: uses code from the WaveSurfing tutorial
   double getDanger(ArrayList<DCWave> surfableWaves, double direction, double minOtherDanger){
      HashMap<DCWave, WaveHitRange> hits = new HashMap<DCWave, WaveHitRange>();
      
   //  public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
      Point2D.Double predictedPosition = current.position;
      double predictedVelocity = current.velocity;
      double predictedHeading = current.heading;
      double maxTurning, moveAngle, moveDir;
      boolean move = true;
      int predictedTime = (int)current.time;
      boolean wavePassed = false;
      Point2D.Double pivotPoint = current.enemyPosition;
      // {
         // double minTimeToHit = Double.POSITIVE_INFINITY;
         // Iterator<DCWave> it = surfableWaves.iterator();
         // while(it.hasNext()){
            // DCWave w = it.next();
            // double timeToHit = predictedPosition.distance(w.firePosition)/w.bulletVelocity
               //  + (w.fireTime - predictedTime);
            // if(timeToHit < minTimeToHit){
               // pivotPoint = w.firePosition;
               // minTimeToHit = timeToHit;
            // }
         // }
      // }
      if(direction == 0){
         move = false;
         direction = current.direction;
      }
      do {    
         moveAngle =
             Trig.wallSmoothing(predictedPosition, 
             Trig.absoluteBearing(pivotPoint, predictedPosition) + 
             direction * getOffset(pivotPoint.distance(predictedPosition)),
             direction)
             - predictedHeading;
        
      
         if(Trig.cos(moveAngle) < 0) {
            moveAngle += Math.PI;
            moveDir = -1;
         }
         else
            moveDir = 1;
            
         maxTurning = Math.PI/18 - Math.PI/240*Math.abs(predictedVelocity);
      
         moveAngle =  Math.max(-maxTurning, Math.min(Utils.normalRelativeAngle(moveAngle), maxTurning));
      
         
         predictedHeading = Utils.normalAbsoluteAngle(predictedHeading
             +moveAngle);
      
         if(move){
            predictedVelocity += 
               (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
            predictedVelocity = Math.max(-8, Math.min(predictedVelocity, 8));
         }
         else{
            predictedVelocity = Math.signum(predictedVelocity)
               *(Math.abs(predictedVelocity) - Math.min(2,Math.abs(predictedVelocity)));
         }
         
         predictedPosition = Trig.project(predictedPosition, predictedHeading, 
             predictedVelocity);
         if(!field.contains(predictedPosition)){
            Point2D.Double lastPredictedPosition = Trig.project(predictedPosition,
                  predictedHeading, -predictedVelocity);
            if(!DISABLE_PRECISE_WALL_HITS){
            
            //make general form linear equation Ax + By = K
               double A = lastPredictedPosition.y - predictedPosition.y;
               double B = predictedPosition.x - lastPredictedPosition.x;
               double K = A*predictedPosition.x + B*predictedPosition.y;
            	
            //get intersection point for wall we passed through
               int outcode = field.outcode(predictedPosition.x,predictedPosition.y);
               if((outcode&Rectangle2D.OUT_LEFT) != 0){
                  predictedPosition.x = field.x + 1E-5;
                  if(B!=0)
                  //impossible for B == 0 because then it 
                  //couldn't have been projected out on this wall. 
                  //but check just in case
                     predictedPosition.y = (K - A*predictedPosition.x)/B;
                  if(field.contains(predictedPosition))
                     outcode = 0;
               }
               else if((outcode&Rectangle2D.OUT_RIGHT) != 0){
                  predictedPosition.x = field.x + field.width - 1E-5;
                  if(B!=0)
                     predictedPosition.y = (K - A*predictedPosition.x)/B;
                  if(field.contains(predictedPosition))
                     outcode = 0;
               }
               if((outcode&Rectangle2D.OUT_TOP) != 0){
                  predictedPosition.y = field.y + field.height - 1E-5;
                  if(A!=0)//same deal for A
                     predictedPosition.y = (K - B*predictedPosition.y)/A;
               }
               else if((outcode&Rectangle2D.OUT_BOTTOM) != 0){
                  predictedPosition.y = field.y + 1E-5;
                  if(A!=0)
                     predictedPosition.y = (K - B*predictedPosition.y)/A;
               }
            }
            else
               predictedPosition = lastPredictedPosition;
               
            predictedVelocity = 0;
         }
         paintPoints.add(predictedPosition);
         
         predictedTime++;
      
         double minTimeToHit = Double.POSITIVE_INFINITY;
         
         Iterator<DCWave> it = surfableWaves.iterator();
         while(it.hasNext()){
            DCWave w = it.next();
            PreciseWave pw = new PreciseWave();
            pw.bulletVelocity = w.bulletVelocity;
            pw.distanceTraveled = (predictedTime - w.fireTime)*w.bulletVelocity;
            pw.fireLocation = w.firePosition;
          
            // double timeToHit = (predictedPosition.distance(w.firePosition) - pw.distanceTraveled)
               // /w.bulletVelocity;
            // if(timeToHit < minTimeToHit){
               // pivotPoint = w.firePosition;
               // minTimeToHit = timeToHit;
            // }
         	
            int CODE = PreciseUtils.intersects(predictedPosition,pw);
            if(CODE == PreciseUtils.PASSED){
               wavePassed = true;
               //break;
            }
            // if(CODE == PreciseUtils.NOT_REACHED)
               // continue;
            else if(CODE == PreciseUtils.INTERSECTION){
               double danger = Math.min(
                        get2ndWaveMinDanger(surfableWaves,
                        w,
                        predictedPosition,
                        predictedVelocity,
                        predictedHeading,
                        direction,
                        predictedTime),
                        
                        get2ndWaveMinDanger(surfableWaves,
                        w,
                        predictedPosition,
                        predictedVelocity,
                        predictedHeading,
                        -direction,
                        predictedTime));
                  
               return danger ;                 
            }
         
         }
      } while(!wavePassed);
      
   
      return 0;
      
   }
   
	//CREDIT: uses code from the WaveSurfing tutorial
   double get2ndWaveMinDanger(ArrayList<DCWave> surfableWaves,
    DCWave firstWave,
    Point2D.Double predictedPosition,
    double predictedVelocity,
    double predictedHeading,
     double direction,
     int predictedTime){
     
      HashMap<DCWave, WaveHitRange> hits = new HashMap<DCWave, WaveHitRange>();
      ArrayList<WaveHitRange> predictedHits = new ArrayList<WaveHitRange>();
   //  public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
      double maxTurning, moveAngle, moveDir;
      boolean move = true;
   
      boolean wavePassed = false;
      double minDanger = Double.POSITIVE_INFINITY;
      Point2D.Double pivotPoint = current.enemyPosition;
      // {
         // double minTimeToHit = Double.POSITIVE_INFINITY;
         // Iterator<DCWave> it = surfableWaves.iterator();
         // while(it.hasNext()){
            // DCWave w = it.next();
            // double timeToHit = predictedPosition.distance(w.firePosition)/w.bulletVelocity
               //  + (w.fireTime - predictedTime);
            // if(timeToHit < minTimeToHit){
               // pivotPoint = w.firePosition;
               // minTimeToHit = timeToHit;
            // }
         // }
      // }
   
      do {    
         moveAngle =
             Trig.wallSmoothing(predictedPosition, 
             Trig.absoluteBearing(pivotPoint, predictedPosition) + 
             direction * getOffset(pivotPoint.distance(predictedPosition)),
             direction)
             - predictedHeading;
        
      
         if(Trig.cos(moveAngle) < 0) {
            moveAngle += Math.PI;
            moveDir = -1;
         }
         else
            moveDir = 1;
            
         maxTurning = Math.PI/18 - Math.PI/240*Math.abs(predictedVelocity);
      
         moveAngle =  Math.max(-maxTurning, Math.min(Utils.normalRelativeAngle(moveAngle), maxTurning));
      
         
         predictedHeading = Utils.normalAbsoluteAngle(predictedHeading
             +moveAngle);
      
        
         predictedVelocity += 
               (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
         predictedVelocity = Math.max(-8, Math.min(predictedVelocity, 8));
      
         
         predictedPosition = Trig.project(predictedPosition, predictedHeading, 
             predictedVelocity);
         if(!field.contains(predictedPosition)){
            Point2D.Double lastPredictedPosition = Trig.project(predictedPosition,
                  predictedHeading, -predictedVelocity);
            if(!DISABLE_PRECISE_WALL_HITS){
            
                             //make general form linear equation Ax + By = K
               double A = lastPredictedPosition.y - predictedPosition.y;
               double B = predictedPosition.x - lastPredictedPosition.x;
               double K = A*predictedPosition.x + B*predictedPosition.y;
            	
            //get intersection point for wall we passed through
               int outcode = field.outcode(predictedPosition.x,predictedPosition.y);
               if((outcode&Rectangle2D.OUT_LEFT) != 0){
                  predictedPosition.x = field.x + 1E-5;
                  if(B!=0)
                  //impossible for B == 0 because then it 
                  //couldn't have been projected out on this wall. 
                  //but check just in case
                     predictedPosition.y = (K - A*predictedPosition.x)/B;
                  if(field.contains(predictedPosition))
                     outcode = 0;
               }
               else if((outcode&Rectangle2D.OUT_RIGHT) != 0){
                  predictedPosition.x = field.x + field.width - 1E-5;
                  if(B!=0)
                     predictedPosition.y = (K - A*predictedPosition.x)/B;
                  if(field.contains(predictedPosition))
                     outcode = 0;
               }
               if((outcode&Rectangle2D.OUT_TOP) != 0){
                  predictedPosition.y = field.y + field.height - 1E-5;
                  if(A!=0)//same deal for A
                     predictedPosition.y = (K - B*predictedPosition.y)/A;
               }
               else if((outcode&Rectangle2D.OUT_BOTTOM) != 0){
                  predictedPosition.y = field.y + 1E-5;
                  if(A!=0)
                     predictedPosition.y = (K - B*predictedPosition.y)/A;
               }
            }
            else
               predictedPosition = lastPredictedPosition;
            predictedVelocity = 0;
         }
         paintPoints.add(predictedPosition);
         
         predictedTime++;
         
         minDanger = Math.min(minDanger,
            get2ndWaveStopDanger(
            surfableWaves,
            firstWave,
            predictedPosition,
            predictedVelocity,
            predictedHeading,
            direction,
            predictedTime)
            );
      
         double minTimeToHit = Double.POSITIVE_INFINITY;
         
         Iterator<DCWave> it = surfableWaves.iterator();
         while(it.hasNext()){
            DCWave w = it.next();
            PreciseWave pw = new PreciseWave();
            pw.bulletVelocity = w.bulletVelocity;
            pw.distanceTraveled = (predictedTime - w.fireTime)*w.bulletVelocity;
            pw.fireLocation = w.firePosition;
         
            int CODE = PreciseUtils.intersects(predictedPosition,pw);
            if(CODE == PreciseUtils.PASSED){
               if(w != firstWave || surfableWaves.size() == 1)
                  wavePassed = true;
               //break;
            }
            // if(CODE == PreciseUtils.NOT_REACHED)
               // continue;
            else if(CODE == PreciseUtils.INTERSECTION){
               double[] range = PreciseUtils.getIntersectionRange(predictedPosition,pw);
               range[0] = Utils.normalRelativeAngle(range[0] - w.bearing)/w.MEA*w.direction;
               range[1] = Utils.normalRelativeAngle(range[1] - w.bearing)/w.MEA*w.direction;
               if(!hits.containsKey(w)){
                  WaveHitRange whr = new WaveHitRange();
                  whr.wave = w;
                  whr.minGF = Math.min(range[0], range[1]);
                  whr.maxGF = Math.max(range[0], range[1]);
                  whr.width = whr.maxGF - whr.minGF;
                  whr.center = (whr.maxGF + whr.minGF)*0.5;
                  whr.distance = pw.distanceTraveled;
                  hits.put(w,whr);
               }
               else{
                  WaveHitRange whr = hits.get(w);
                  whr.minGF = Math.min(whr.minGF,Math.min(range[0], range[1]));
                  whr.maxGF = Math.max(whr.maxGF,Math.max(range[0], range[1]));
                  whr.width = whr.maxGF - whr.minGF;
                  whr.center = (whr.maxGF + whr.minGF)*0.5;
                  whr.distance = pw.distanceTraveled;
               }
               
            }
         
         }
      } while(!wavePassed && surfableWaves.size() != 0);
      
      Iterator<WaveHitRange> dit = hits.values().iterator();
      double danger = 0;
      double firstDanger = 0;
      while(dit.hasNext()){
         WaveHitRange whr = dit.next();
         double d = getDanger(whr);
         if(whr.wave == firstWave)
            firstDanger += d;
         else
            danger += d;
         paintRanges.add(whr);  
      }
         
      return Math.min(minDanger,danger) + firstDanger;
   
   }
   double get2ndWaveStopDanger(ArrayList<DCWave> surfableWaves,
    DCWave firstWave,
    Point2D.Double predictedPosition,
    double predictedVelocity,
    double predictedHeading,
     double direction,
     int predictedTime){
     
      HashMap<DCWave, WaveHitRange> hits = new HashMap<DCWave, WaveHitRange>();
      
   //  public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
      double maxTurning, moveAngle, moveDir;
      boolean move = true;
      boolean wavePassed = false;
      Point2D.Double pivotPoint = current.enemyPosition;
      // {
         // double minTimeToHit = Double.POSITIVE_INFINITY;
         // Iterator<DCWave> it = surfableWaves.iterator();
         // while(it.hasNext()){
            // DCWave w = it.next();
            // double timeToHit = predictedPosition.distance(w.firePosition)/w.bulletVelocity
               //  + (w.fireTime - predictedTime);
            // if(timeToHit < minTimeToHit){
               // pivotPoint = w.firePosition;
               // minTimeToHit = timeToHit;
            // }
         // }
      // }
      
      move = false;
      do {    ///////TODOOOOO
         if(Math.abs(predictedVelocity) > 0.001){
            moveAngle =
               Trig.wallSmoothing(predictedPosition, 
               Trig.absoluteBearing(pivotPoint, predictedPosition) + 
               direction * getOffset(pivotPoint.distance(predictedPosition)),
               direction)
               - predictedHeading;
         
         
            if(Trig.cos(moveAngle) < 0) {
               moveAngle += Math.PI;
               moveDir = -1;
            }
            else
               moveDir = 1;
            
            maxTurning = Math.PI/18 - Math.PI/240*Math.abs(predictedVelocity);
         
            moveAngle =  Math.max(-maxTurning, Math.min(Utils.normalRelativeAngle(moveAngle), maxTurning));
         
         
            predictedHeading = Utils.normalAbsoluteAngle(predictedHeading
               +moveAngle);
         
         
            predictedVelocity = Math.signum(predictedVelocity)
               *(Math.abs(predictedVelocity) - Math.min(2,Math.abs(predictedVelocity)));
            	
         
            predictedPosition = Trig.project(predictedPosition, predictedHeading, 
               predictedVelocity);
            if(!field.contains(predictedPosition)){
               Point2D.Double lastPredictedPosition = Trig.project(predictedPosition,
                  predictedHeading, -predictedVelocity);
               if(!DISABLE_PRECISE_WALL_HITS){
               
               //make general form linear equation Ax + By = K
                  double A = lastPredictedPosition.y - predictedPosition.y;
                  double B = predictedPosition.x - lastPredictedPosition.x;
                  double K = A*predictedPosition.x + B*predictedPosition.y;
               
               //get intersection point for wall we passed through
                  int outcode = field.outcode(predictedPosition.x,predictedPosition.y);
                  if((outcode&Rectangle2D.OUT_LEFT) != 0){
                     predictedPosition.x = field.x + 1E-5;
                     if(B!=0)
                     //impossible for B == 0 because then it 
                     //couldn't have been projected out on this wall. 
                     //but check just in case
                        predictedPosition.y = (K - A*predictedPosition.x)/B;
                     if(field.contains(predictedPosition))
                        outcode = 0;
                  }
                  else if((outcode&Rectangle2D.OUT_RIGHT) != 0){
                     predictedPosition.x = field.x + field.width - 1E-5;
                     if(B!=0)
                        predictedPosition.y = (K - A*predictedPosition.x)/B;
                     if(field.contains(predictedPosition))
                        outcode = 0;
                  }
                  if((outcode&Rectangle2D.OUT_TOP) != 0){
                     predictedPosition.y = field.y + field.height - 1E-5;
                     if(A!=0)//same deal for A
                        predictedPosition.y = (K - B*predictedPosition.y)/A;
                  }
                  else if((outcode&Rectangle2D.OUT_BOTTOM) != 0){
                     predictedPosition.y = field.y + 1E-5;
                     if(A!=0)
                        predictedPosition.y = (K - B*predictedPosition.y)/A;
                  }
               }
               else
                  predictedPosition = lastPredictedPosition;
               predictedVelocity = 0;
            }
         // paintPoints.add(predictedPosition);
         }
         predictedTime++;
      
         double minTimeToHit = Double.POSITIVE_INFINITY;
         
         Iterator<DCWave> it = surfableWaves.iterator();
         while(it.hasNext()){
            DCWave w = it.next();
            if(w == firstWave)
               continue;
            PreciseWave pw = new PreciseWave();
            pw.bulletVelocity = w.bulletVelocity;
            pw.distanceTraveled = (predictedTime - w.fireTime)*w.bulletVelocity;
            pw.fireLocation = w.firePosition;
          
            // double timeToHit = (predictedPosition.distance(w.firePosition) - pw.distanceTraveled)
               // /w.bulletVelocity;
            // if(timeToHit < minTimeToHit){
               // pivotPoint = w.firePosition;
               // minTimeToHit = timeToHit;
            // }
         	
            int CODE = PreciseUtils.intersects(predictedPosition,pw);
            if(CODE == PreciseUtils.PASSED){
               //wavePassed = true;
               Iterator<WaveHitRange> dit = hits.values().iterator();
               double danger = 0;
               while(dit.hasNext())
                  danger += getDanger(dit.next());
               return danger;
               //break;
            }
            // if(CODE == PreciseUtils.NOT_REACHED)
               // continue;
            if(CODE == PreciseUtils.INTERSECTION){
               double[] range = PreciseUtils.getIntersectionRange(predictedPosition,pw);
               range[0] = Utils.normalRelativeAngle(range[0] - w.bearing)/w.MEA*w.direction;
               range[1] = Utils.normalRelativeAngle(range[1] - w.bearing)/w.MEA*w.direction;
               if(!hits.containsKey(w)){
                  WaveHitRange whr = new WaveHitRange();
                  whr.wave = w;
                  whr.minGF = Math.min(range[0], range[1]);
                  whr.maxGF = Math.max(range[0], range[1]);
                  whr.width = whr.maxGF - whr.minGF;
                  whr.center = (whr.maxGF + whr.minGF)*0.5;
                  whr.distance = pw.distanceTraveled;
                  hits.put(w,whr);
               }
               else{
                  WaveHitRange whr = hits.get(w);
                  whr.minGF = Math.min(whr.minGF,Math.min(range[0], range[1]));
                  whr.maxGF = Math.max(whr.maxGF,Math.max(range[0], range[1]));
                  whr.width = whr.maxGF - whr.minGF;
                  whr.center = (whr.maxGF + whr.minGF)*0.5;
                  whr.distance = pw.distanceTraveled;
               }
               
            }
         
         }
      } while(!wavePassed && surfableWaves.size() > 1);
   
      return 0;
   }

	
	
	
   ArrayList<DCWave> getSurfableWaves(){
      ArrayList<DCWave> surfableWaves = new ArrayList<DCWave>(); 
      Iterator<DCWave> i = waves.iterator();
      while(i.hasNext()){
         DCWave w = i.next();
         if(!w.surfable)
            continue;
         PreciseWave pw = new PreciseWave();
         pw.bulletVelocity = w.bulletVelocity;
         pw.distanceTraveled = w.distanceTraveled;
         pw.fireLocation = w.firePosition;
         if(PreciseUtils.intersects(current.position,pw) != PreciseUtils.PASSED)
            surfableWaves.add(w);
      }
      return surfableWaves;
   }
   void logEnemyBullet(Bullet b, boolean bulletHitBullet){
   
      Point2D.Double hitPosition =  new Point2D.Double(b.getX(), b.getY()); 
      Iterator it = waves.iterator();
      boolean found = false;
      while (it.hasNext()) {
         DCWave w = (DCWave)it.next();
         
         if (Math.abs(w.distanceTraveled - hitPosition.distance(w.firePosition)) 
         <= 2*w.bulletVelocity
                  && Utils.isNear(b.getPower(),w.bulletPower)
            	  ) {
            logHit(w,hitPosition, bulletHitBullet);
            w.surfable = false;
            found = true;
         }
      }
      if(!found)
         System.out.println("UNIDENTIFIED BULLET");
   }
   void logHit(DCWave w, Point2D.Double p, boolean bulletHitBullet){
      TreeScan ts = new TreeScan();
      ts.GF = getFactor(w,p);
      // System.out.println("logging hit at GF: " + ts.GF);
      hitsTree.addPoint(w.treeLocation, ts);
         
      bulletInteractions++;
      bulletInteractionsWeight = bulletInteractions*(bulletInteractions + 1);
      if(bot.getRoundNum() < 5 || bulletHitBullet)
         updateWeights(w,p, bulletHitBullet);
      Iterator<DCWave> it = waves.iterator();
      while(it.hasNext()){
         DCWave wave = it.next();
         wave.scans.clear();
         wave.scans = getScans(wave.treeLocation);
      }
   }
   void logMiss(DCWave w, HitRange hr){
      TreeScan ts = new TreeScan();
      missesTree.addPoint(w.treeLocation, hr);
         
      // updateWeights(w,hr);
      if(LEARN_FROM_MISSES){
         Iterator<DCWave> it = waves.iterator();
         while(it.hasNext()){
            DCWave wave = it.next();
            wave.misses.clear();
            wave.misses = getMisses(wave.treeLocation);
         }
      }
   }
   double getFactor(DCWave w, Point2D.Double p){
      double angle = Utils.normalRelativeAngle(Trig.absoluteBearing(w.firePosition, p) - w.bearing);
      return angle/w.MEA*w.direction;
   }
   
   double getDanger(WaveHitRange waveHitRange){
    
      ArrayList<WaveHitRange> ranges = new ArrayList<WaveHitRange>();
      ranges.add(waveHitRange);
      /*Iterator<HitRange> it = waveHitRange.wave.noDanger.iterator();
   	
   	//subtract the 'zero' spots by making new ranges
      while(it.hasNext()){
         // System.out.println("iterating through noDanger");
         HitRange hr = it.next();
         Iterator<WaveHitRange> rangeIt = ranges.iterator();
         while(rangeIt.hasNext()){
            WaveHitRange whr = rangeIt.next();
            boolean minContained = whr.minGF < hr.minGF && hr.minGF < whr.maxGF;
            boolean maxContained = whr.minGF < hr.maxGF && hr.maxGF < whr.maxGF;
            boolean completeCover = hr.minGF < whr.minGF && hr.maxGF > whr.maxGF;
            // System.out.println("minContained: " + minContained);
            // System.out.println("maxContained: " + maxContained);
            // System.out.println("completeCover: " + completeCover);
         	
            if(minContained && maxContained){
               WaveHitRange minRange = new WaveHitRange();
               minRange.distance = whr.distance;
               minRange.minGF = whr.minGF;
               minRange.maxGF = hr.minGF;
               minRange.wave = whr.wave;
                   
               WaveHitRange maxRange = new WaveHitRange();
               maxRange.distance = whr.distance;
               maxRange.minGF = hr.maxGF;
               maxRange.maxGF = whr.maxGF;
               maxRange.wave = whr.wave;
               
               rangeIt.remove();
               ranges.add(minRange);
               ranges.add(maxRange);
               rangeIt = ranges.iterator();
               continue;
            }
            if(minContained){
               WaveHitRange minRange = new WaveHitRange();
               minRange.distance = whr.distance;
               minRange.minGF = whr.minGF;
               minRange.maxGF = hr.minGF;
               minRange.wave = whr.wave;
            
               rangeIt.remove();
               ranges.add(minRange);
               rangeIt = ranges.iterator();
               continue;
            }
            if(maxContained){       
               WaveHitRange maxRange = new WaveHitRange();
               maxRange.distance = whr.distance;
               maxRange.minGF = hr.maxGF;
               maxRange.maxGF = whr.maxGF;
               maxRange.wave = whr.wave;
               
               rangeIt.remove();
               ranges.add(maxRange);
               rangeIt = ranges.iterator();
               continue;
            }
            if(completeCover)
               rangeIt.remove();
         }
      }  
      */
      
      if(LEARN_FROM_MISSES){
         ArrayList<WaveHitRange> adjForMiss = new ArrayList<WaveHitRange>();
         Iterator<WaveHitRange> rangeIt = ranges.iterator();
         while(rangeIt.hasNext()){
            WaveHitRange whr = rangeIt.next();
         //for each range
         //get index of minGF miss
            int index = getIndex(whr.wave.misses,whr.minGF, whr.maxGF);
            if(index > -1){
               double lastMax = whr.minGF;
               double lastWeight;
               if(whr.wave.misses.get(0).point < lastMax)
                  lastWeight = 1/(1 + 20*whr.wave.misses.get(0).heightValue);
               else
                  lastWeight = 1;
               int K = whr.wave.misses.size();
               for(;lastMax < whr.maxGF && index < K; index++){
                  Indice i = whr.wave.misses.get(index);
               //make new range,
                  WaveHitRange r = new WaveHitRange();
                  r.wave = whr.wave;
                  r.minGF = lastMax;
                  r.maxGF = lastMax = Math.min(whr.maxGF,i.point); 
                  r.width = r.maxGF - r.minGF;
                  r.center = (r.maxGF + r.minGF)*0.5;
                  r.weight = lastWeight;
                  lastWeight = 1/(1 + MISS_WEIGHT*i.heightValue);
                  adjForMiss.add(r);
               }
               if(lastMax < whr.maxGF){
                  WaveHitRange r = new WaveHitRange();
                  r.wave = whr.wave;
                  r.minGF = lastMax;
                  r.maxGF = whr.maxGF; 
                  r.width = r.maxGF - r.minGF;
                  r.center = (r.maxGF + r.minGF)*0.5;
                  adjForMiss.add(r);
               }
            }
            else
               adjForMiss.add(whr);
         }
         ranges = adjForMiss;
      }
   
      double danger = 0;
      double totalWidth = 0;
      Iterator<WaveHitRange> rangeIt = ranges.iterator();
      while(rangeIt.hasNext()){
         WaveHitRange whr = rangeIt.next();
         Iterator<WaveScan> i = whr.wave.scans.iterator();
         double width_factor = 30.0*whr.wave.scans.size();
         double d = 0;
         while(i.hasNext()){
            WaveScan ws = i.next();
            // if(whr.minGF < ws.GF && ws.GF < whr.maxGF)
               // d += 2*ws.weight*whr.width/(1 + 
                  // width_factor*//'danger width' tuning factor
                  // (sqr(ws.GF - whr.center))
                  // );
            // else
            danger += ws.weight*whr.width/(1 + 
                  width_factor*//'danger width' tuning factor
                  (sqr(ws.GF - whr.center))
                  );
            totalWidth += whr.width;
         }
         danger += d*whr.weight;
      }
      // danger /= (0.01 + totalWidth);
   	
      return danger/(1 + waveHitRange.distance);
      /*waveHitRange.wave.bulletVelocity*
         Math.abs(current.time
         - waveHitRange.distance/waveHitRange.wave.bulletVelocity 
         - waveHitRange.wave.fireTime));*/
   }
   
   double sqr(double d){
      return d*d;
   }
      
   double getDanger(double GF, DCWave w){
      Iterator<HitRange> it = w.noDanger.iterator();
   	
      while(it.hasNext()){
         HitRange hr = it.next();
         if(hr.minGF <= GF && GF <= hr.maxGF)
            return 0;    
      } 
      
      double danger = 0;
      Iterator<WaveScan> i = w.scans.iterator();
      double width_factor = 30.0*w.scans.size();
      
      while(i.hasNext()){
         WaveScan ws = i.next();
      
         danger += ws.weight/(1 + 
                  width_factor*//'danger width' tuning factor
                  Math.abs(ws.GF - GF)*Math.abs(ws.GF - GF)
                  );
      }
      
      if(LEARN_FROM_MISSES){
         int missIndex = getIndex(w.misses,GF);
         if(missIndex != -1){
            danger /= 1 + MISS_WEIGHT*w.misses.get(missIndex).heightValue;
         }
      }
   	
   	
      return danger;
   }

	
   void updateState(ScannedRobotEvent e){
      MoveState ms = new MoveState(current);
      ms.velocity = bot.getVelocity();
      ms.heading = bot.getHeadingRadians();
      ms.distance = e.getDistance();
      ms.bearing = Utils.normalAbsoluteAngle(ms.heading + e.getBearingRadians());
      ms.position = new Point2D.Double(bot.getX(), bot.getY());
      ms.enemyPosition = Trig.project(ms.position, ms.bearing, ms.distance);
      ms.time = bot.getTime();
      double latVel = ms.velocity*Trig.sin(e.getBearingRadians());
      if(latVel != 0.0)
         ms.direction = Math.signum(latVel);
      else
         ms.direction = ms.getXBack(1).direction;
      latVel = Math.abs(latVel);
      
      double accel = 0.5*Math.signum(Math.abs(ms.velocity) - 
         Math.abs(ms.getXBack(1).velocity)) + 0.5;
      double advVel = Math.abs(ms.velocity*Trig.cos(e.getBearingRadians()));
      double dist = ms.distance;
      double dl10 = ms.position.distance(ms.getXBack(10).position);
      double dl20 = ms.position.distance(ms.getXBack(20).position);
      double forWall = Trig.wallDistance(ms.distance, ms.bearing, ms.direction, ms.enemyPosition);
      double revWall = Trig.wallDistance(ms.distance, ms.bearing, -ms.direction, ms.enemyPosition);
      double tsdChange = 0;
      MoveState m = ms;
      while(m != null && m.previous != null && m != m.previous
      && m.direction == m.previous.direction){
         m = m.previous;
         tsdChange+=1;
      }
      double tsDecel = 0;
      m = ms;
      while(m != null && m.previous != null && m != m.previous
      && Math.abs(m.velocity) >= Math.abs(m.previous.velocity)){
         m = m.previous;
         tsDecel+=1;
      }
      
      ms.treeLocation = new double[]{
            latVel/8,
            advVel/16 + 0.5,
            dist/1200,
            accel,
            dl10/(8*10),
            1/(1 + 3*Math.abs(forWall)),
            1/(1 + 3*Math.abs(revWall)),
            1/(1 + 25*tsdChange/dist),
            1/(1 + 25*tsDecel/dist),
            1/(1 + bulletInteractions)
            };
      current = ms;
   }

   void updateWaves(double energyDiff){
      
      if(0.09 < energyDiff && energyDiff <= 3){
         DCWave w = new DCWave();
         w.firePosition = current.getXBack(1).enemyPosition;
         MoveState m = current.getXBack(2);
         w.bearing = Utils.normalAbsoluteAngle(m.bearing + Math.PI);
         w.treeLocation = m.treeLocation;
         w.fireTime = current.time - 1;
         w.bulletPower = energyDiff;
         w.bulletVelocity = 20 - 3*energyDiff;
         w.MEA = Trig.maxEscapeAngle(w.bulletVelocity);
         w.direction = m.direction;
         w.scans = getScans(w.treeLocation);
         if(LEARN_FROM_MISSES)
            w.misses = getMisses(w.treeLocation);
         else
            w.misses = new ArrayList<Indice>();//prevent null pointer exceptions
         w.noDanger = new ArrayList<HitRange>();
         waves.add(w);
         // System.out.println("adding wave with " + w.scans.size() + " scans");
      }
      
      
      Iterator<DCWave> i = waves.iterator();
      while(i.hasNext()){
         DCWave w = i.next();
         PreciseWave pw = new PreciseWave();
         w.distanceTraveled = w.bulletVelocity*(current.time - w.fireTime);
         pw.bulletVelocity = w.bulletVelocity;
         pw.distanceTraveled = w.distanceTraveled - 2*pw.bulletVelocity;
         pw.fireLocation = w.firePosition;
         int CODE = PreciseUtils.intersects(current.position,pw);
         if(CODE == PreciseUtils.PASSED){
            if(w.surfable ){
               bulletsMissed++;
               if(w.noDanger.size() > 0)
                  logMiss(w, w.noDanger.get(0));
            }
            i.remove();
         }
         else{ 
            pw.distanceTraveled = w.distanceTraveled;
            CODE = PreciseUtils.intersects(current.position,pw);
            if(CODE == PreciseUtils.INTERSECTION){
            // System.out.println("adding intersection zero range");
               double[] range = PreciseUtils.getIntersectionRange(current.position,pw);
               range[0] = Utils.normalRelativeAngle(range[0] - w.bearing)/w.MEA*w.direction;
               range[1] = Utils.normalRelativeAngle(range[1] - w.bearing)/w.MEA*w.direction;
            
               if(w.noDanger.size() == 0){
                  HitRange hr = new HitRange();
                  hr.minGF = Math.min(range[0], range[1]);
                  hr.maxGF = Math.max(range[0], range[1]);
                  w.noDanger.add(hr);
               
               }
               else{
                  HitRange hr = w.noDanger.get(0);
                  hr.minGF = Math.min(hr.minGF,Math.min(range[0], range[1]));
                  hr.maxGF = Math.max(hr.maxGF,Math.max(range[0], range[1]));
               }
               
            
            }
         	
         }
      }
   }
   ArrayList<WaveScan> getScans(double[] tl){
   
      ArrayList<WaveScan> scans = new ArrayList<WaveScan>();
      
      for(int k = 0; k < weights.length; k++){
         final int seg = k;
      
         hitsTree.setWeights(weights[k]);
      
         ArrayList<KDTree.SearchResult<TreeScan>> cluster = hitsTree.nearestNeighbours(
            tl,Math.min((int)Math.ceil(Math.sqrt(hitsTree.size())),10));
         Iterator<KDTree.SearchResult<TreeScan>> it = cluster.iterator();
         WaveScan[] weightScans = new WaveScan[cluster.size()];
         double max = 1E-20;
         for(int i = 0; it.hasNext(); i++){
            KDTree.SearchResult<TreeScan> p = it.next();
            double weight = 1/(p.distance + 1E-15);
            max = Math.max(max,weight);
            weightScans[i] = new WaveScan(p.payload.GF, weight, k);
         }
         double scaleFactor = weightWeights[k]*weightWeights[k]/max;
         for(int i = 0, j = weightScans.length; i < j; i++){
            WaveScan w = weightScans[i];
            w.weight *= scaleFactor;
            scans.add(w);
         }
      	
      }
      // WaveScan w = new WaveScan(tl[0],weightWeights[3]*weightWeights[3],3);//linear
      // scans.add(w);
      // w = new WaveScan(0,weightWeights[4]*weightWeights[4],4);//head-on
      // scans.add(w);
      return scans;
   }
   ArrayList<Indice> getMisses(double[] tl){
   
      ArrayList<Indice> scans = new ArrayList<Indice>();
      
      for(int k = 0; k < weights.length; k++){
      
         missesTree.setWeights(weights[k]);
      
         ArrayList<KDTree.SearchResult<HitRange>> cluster = missesTree.nearestNeighbours(
            tl,Math.min((int)Math.ceil(Math.sqrt(missesTree.size())),10));
            
         Iterator<KDTree.SearchResult<HitRange>> it = cluster.iterator();
         Indice[] indices = new Indice[cluster.size()*2];
         double max = 0;
         for(int i = 0; it.hasNext(); i++){
            KDTree.SearchResult<HitRange> p = it.next();
            double weight = 1/(p.distance + 1E-5);
            indices[i*2] = new Indice(p.payload.minGF,weight,k);
            indices[i*2 + 1] = new Indice(p.payload.maxGF,-weight,k);
            max = Math.max(max,weight);
         }
         double scaleFactor = weightWeights[k]*weightWeights[k]/max;
         for(int i = 0; i < indices.length; i++){
            indices[i].value *= scaleFactor;
            scans.add(indices[i]);
         }
      }
      Collections.sort(scans);
      double max = 0, value = 0;
      Iterator<Indice> it = scans.iterator();
      while(it.hasNext()){
         Indice i = it.next();
         value += i.value;
         max = Math.max(max,value);
      }
      double invMax = 1/max;//multiply is faster than divide
      value = 0;//should already be 0, just in case
      it = scans.iterator();
      while(it.hasNext()){
         Indice i = it.next();
         i.value *= invMax;
         value += i.value;
         i.heightValue = value;
      }
      return scans;
   }

   void updateWeights(Bullet b, boolean bulletHitBullet){
      Point2D.Double hitPosition =  new Point2D.Double(b.getX(), b.getY()); 
      Iterator it = waves.iterator();
      
      while (it.hasNext()) {
         DCWave w = (DCWave)it.next();
         
         if (Math.abs(w.distanceTraveled - hitPosition.distance(w.firePosition)) 
         <= 2*w.bulletVelocity
                  && Utils.isNear(b.getPower(),w.bulletPower)
            	  ) {
            updateWeights(w,hitPosition,bulletHitBullet);
         }
      }
   }

   void updateWeights(DCWave w, Point2D.Double hitPosition, boolean bulletHitBullet){
      /*
      
      {//normalize all scan weights
         Iterator<DCWave> i = waves.iterator();
         while(i.hasNext()){
            DCWave wave = i.next();
            Iterator<WaveScan> it = wave.scans.iterator();
            while(it.hasNext()){
               WaveScan ws = it.next();
               ws.weight /= weightWeights[ws.weightingSystem]* weightWeights[ws.weightingSystem];
            }
         }
      }
    
      final double width_factor = 30.0*w.scans.size();
      double[] weightDanger = new double[weightWeights.length];
      int[] scanCount = new int[weightWeights.length];
      double GF = getFactor(w,hitPosition);
      Iterator<WaveScan> it = w.scans.iterator();
      while(it.hasNext()){
         WaveScan ws = it.next();
         weightDanger[ws.weightingSystem] += ws.weight/(1 + 
                  width_factor*
                  Math.abs(ws.GF - GF)*Math.abs(ws.GF - GF)
                  );
         scanCount[ws.weightingSystem]++;
      }
      
   
   //TODO:
   //somehow account for bias due to bot moving 
   //to areas that scans with higher weight affect
   //if this is not a bulletHitBullet event 
   //currently i just roll the stats slower if it is a hit-by-bullet
   // 
      double max = 0;
      for(int i = 0; i < weightDanger.length; i++){
         weightDanger[i]/=Math.sqrt(scanCount[i]);
         max = Math.max(weightDanger[i],max);
      }
      // double totalDanger = 0;
      // for(int i = 0; i < weightDanger.length; i++)
         // totalDanger += scanCount[i]>0?(weightDanger[i]/=scanCount[i]):0;  
   // 	
      // if(totalDanger != 0)
         // totalDanger = 4*weightDanger.length/totalDanger;
   	
      for(int i = 0; i < weightDanger.length; i++){
         // weightDanger[i] *= totalDanger;
         // weightDanger[i] = weightDanger[i] - 3;
         if(weightDanger[i] == max)
            weightDanger[i] = weightDanger.length;
         else
            weightDanger[i] = 0;
      }
   
      for(int i = 0; i < weightDanger.length; i++)
         weightWeights[i] = rollingAvg(weightWeights[i], Math.max(0,weightDanger[i]),
            40);
      
      {//re-adjust all scan weights
         Iterator<DCWave> i = waves.iterator();
         while(i.hasNext()){
            DCWave wave = i.next();
            it = wave.scans.iterator();
            while(it.hasNext()){
               WaveScan ws = it.next();
               ws.weight *= weightWeights[ws.weightingSystem]* weightWeights[ws.weightingSystem];
            }
         }
      }
      */
   }
   static double rollingAvg(double value, double newEntry, double depth) {
      return (value * depth + newEntry)/(depth + 1);
   }

//binary search for correct position in array
   static int getIndex(ArrayList<Indice> indices, double GF){
      int min = 0, max = indices.size();
      while(min < max){
         int guess = min + (max - min)/2;
         Indice i = indices.get(guess);
         if(i.point < GF)
            min = guess + 1;
         else
            max = guess;
      }
      if( min >= indices.size() || indices.get(0).point > GF)
         return -1;
   
      return min;
   }
   static int getIndex(ArrayList<Indice> indices, double minGF, double maxGF){
      int min = 0, max = indices.size();
      while(min < max){
         int guess = min + (max - min)/2;
         Indice i = indices.get(guess);
         if(i.point < minGF)
            min = guess + 1;
         else
            max = guess;
      }
      if( min >= indices.size() || indices.get(0).point > maxGF)
         return -1;
   
      return min;
   }




}


class MoveState{
   MoveState(MoveState m){
      previous = m;
   }
   MoveState previous;
   
   Point2D.Double position;
   double velocity, heading, bearing, distance;
   double direction = 1;
   long time;
   
   Point2D.Double enemyPosition; 
   
   double[] treeLocation;
   
   MoveState getXBack(int x){
      MoveState m = this;
      
      for(int i = 0; i < x; i++){
         if(m.previous == null)
            return m;
         m = m.previous;
      }
      
      return m;
   }
   
}
class HitRange{
   static final int MY_INTERSECTION = 0;
   static final int BULLET_INTERSECTION = 1;
   double minGF;
   double maxGF;
   double width;
   double center;
   int cause;
}

class WaveHitRange extends HitRange{
   DCWave wave;
   double distance;
   double weight = 1;
}
class TreeScan{
   
   double GF;
   
}
class WaveScan extends TreeScan{
   double weight;
   int weightingSystem;
   WaveScan (double GF, double weight, int ws){
      this.GF = GF;
      this.weight = weight;
      this.weightingSystem = ws;
   }
}
class DCWave {
   
   Point2D.Double firePosition;
   double bearing;
   double bulletPower, bulletVelocity, fireTime, distanceTraveled;
   double MEA, direction;
   
   double[] treeLocation;
   
   ArrayList<WaveScan> scans;
   ArrayList<Indice> misses;
   ArrayList<HitRange> noDanger;
   boolean surfable = true;
   
}
class Indice implements Comparable<Indice> {
   Indice(double p, double v, int w){
      point = p;
      value = v;
      weightingSystem = w;
   }
    
   double point, value, heightValue;
   int weightingSystem;
   public int compareTo(Indice i){
      
      return (int)Math.signum(point - i.point);
   }
}
