/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ahr.ice;

import java.awt.geom.*;

/**
 *
 * @author Alexander Russ
 */
public class FieldPoint extends Point2D.Double {

    public FieldPoint() {
    }

    public FieldPoint(double x, double y) {
        super(x, y);
    }

    public double absoluteAngleTo(FieldPoint p) {
        double angle = Math.atan2(p.x - x, p.y - y);
        while (angle < 0.0) {
            angle += 2.0 * Math.PI;
        }
        while (angle >= 2.0 * Math.PI) {
            angle -= 2.0 * Math.PI;
        }
        return angle;
    }

    public FieldPoint project(double angle, double distance) {
        return new FieldPoint(x + Math.sin(angle) * distance, y + Math.cos(angle) * distance);
    }

    public double distance(FieldPoint p) {
        Point2D.Double pp = new Point2D.Double(p.x, p.y);
        Point2D.Double m = new Point2D.Double(x, y);
        return m.distance(pp);
    }

}
