package romz.robot;

import java.awt.Color;

import romz.component.movement.Movement;
import romz.component.radar.Radar;
import romz.component.targeting.Targeting;
import romz.factory.MovementFactory;
import romz.factory.RadarFactory;
import romz.factory.TargetingFactory;
import romz.robot.base.BaseRobot;

public class Test extends BaseRobot {

	@Override
	public Radar getRadar() {
		return RadarFactory.getConstantWidthRadar();
	}

	@Override
	public Movement getMovement() {
		return MovementFactory.getRandomOscillatingMovement();
//		return MovementFactory.getGoToCenterMovement();
	}

	@Override
	public Targeting getTargeting() {
		return TargetingFactory.getHistoryAnalysisTargeting();
	}

	@Override
	public Color getBodyColor() {
		return new Color(20, 50, 50);
	}

	@Override
	public Color getGunColor() {
		return new Color(200, 220, 100);
	}

	@Override
	public Color getRadarColor() {
		return new Color(0, 0, 0);
	}

}
