package genprog;
import robocode.*;
import static robocode.util.Utils.normalRelativeAngleDegrees;

public class Gajeel extends AdvancedRobot {
	public void run() {
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
		setBack(getRadarHeading());
		setTurnLeft(getEnergy());
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = getHeading() + e.getBearing();
		double bearingFromGun = normalRelativeAngleDegrees(absoluteBearing - getGunHeading());
		setTurnGunRight(bearingFromGun);
		setAhead(getRadarHeading());
		setFire( 2 );
	}

	public void onHitRobot(HitRobotEvent e) {
		setAhead(getHeading() + getY());
		setFire(2);
		setFire(2);
	}

	public void onHitWall(HitWallEvent e) {
		setTurnRight(( getEnergy() + getRadarHeading() ) * getRadarHeading());
		setTurnRight(getGunHeading());
	}
}