/*
 * Written by Kinsen Choy
 */

package kinsen.melee.Guns;
import kinsen.melee.Details;

/*
 * StopAndGo - A gun class that fires stop and go predicted bullets.
 */
public class StopAndGo extends Gun
{
	// Last enemy details
	private Details enemy = null;
	// Last my details
	private Details me = null;
	// Last enemy direction
	private long lastDirection = 1;

	public void calculateGun(double initialFirePower)
	{
		// If there is no data then it can not fire
		if (enemy != null)
		{
			firePower = initialFirePower;
			fireAt = super.predictPosition(enemy.getX(), enemy.getY(), me.getX(), me.getY(), enemy.getHeading(), 3.7 * lastDirection, 0, firePower);
		}
	}

	public void calculateGun(double initialFirePower, boolean canChangePower)
	{
		calculateGun(initialFirePower);
	}

	public void recordData(Details enemyDetails, Details myDetails, long time)
	{
		enemy = enemyDetails;
		me = myDetails;
		if (enemy.getVelocity() != 0)
			lastDirection = (int) (enemy.getVelocity() / Math.abs(enemy.getVelocity()));
	}
}