package dsekercioglu.mega.wfGun;

import dsekercioglu.mega.WFData;
import dsekercioglu.mega.wfGun.gun.AntiAdaptiveGun;
import dsekercioglu.mega.wfGun.gun.AbstractPredictor;
import dsekercioglu.mega.wfGun.gun.AntiAdaptiveGun;
import dsekercioglu.mega.wfGun.gun.MainGun;
import dsekercioglu.mega.wfGun.precise.WallSmoothingMEACalculator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.control.events.BattleCompletedEvent;
import static robocode.util.Utils.normalRelativeAngle;

public class Fangs {

    AdvancedRobot a;

    public final int BINS = 103;

    public final ArrayList<AbstractPredictor> PREDICTORS = new ArrayList<>();
    public final ArrayList<Double> SCORES = new ArrayList<>();
    public final double SURVIVALIST_TRESHOLD = 0;

    ArrayList<Wave> waves = new ArrayList<>();

    FirePowerChooser firePowerChooser = new FirePowerChooser();

    WallSmoothingMEACalculator WSMEAC;

    BattleInfo battleInfo = new BattleInfo(this);

    public double shotsTaken = 0;
    public double bulletHitBullet = 0;
    public double bulletsHit = 0;

    Wave lastWave;

    int lastGF = BINS / 2;

    Point2D.Double nextPosition;

    ArrayList<Point2D.Double> fireLocations = new ArrayList<>();
    ArrayList<Double> fireAngles = new ArrayList<>();
    ArrayList<Double> maxDev = new ArrayList<>();

    final boolean TC;

    public double ticks = 0;
    public double damageRecieved = 0;
    public double enemyEnergyLost = 0;

    public Fangs(AdvancedRobot a, boolean TC) {
        this.a = a;
        this.TC = TC;
        PREDICTORS.add(new MainGun(BINS));
        PREDICTORS.add(new AntiAdaptiveGun(BINS));
        for (int i = 0; i < PREDICTORS.size(); i++) {
            SCORES.add(0.0);
        }
    }

    public void run() {
        waves = new ArrayList<>();
        fireAngles = new ArrayList<>();
        battleInfo = new BattleInfo(this);
        battleInfo.run();
        WSMEAC = new WallSmoothingMEACalculator(battleInfo.battleFieldWidth, battleInfo.battleFieldHeight, 0.01);
    }

    public void setNextPosition(Point2D.Double nextPosition) {
        this.nextPosition = (Point2D.Double) nextPosition.clone();
    }

    public void onBattleCompleted(BattleCompletedEvent e) {
        for (int i = 0; i < PREDICTORS.size(); i++) {
            PREDICTORS.get(i).onMatchEnded(a);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        battleInfo.onScannedRobot(e);
        updateWaves();
        double gunHeat = a.getGunHeat();
        int lateralDir = battleInfo.lateralDirection;
        double firePower = firePowerChooser.firePower();
        double bulletSpeed = (20 - 3 * firePower);
        Wave w = new Wave(firePower, nextPosition, battleInfo.enemyLocation, lateralDir, false);
        double[] data = {Math.abs(battleInfo.lateralVelocity) / 8,
            battleInfo.advancingVelocity / 16 + 0.5,
            battleInfo.distance / bulletSpeed / 91,
            Math.min(battleInfo.getMEA(1), w.maxEscapeAngle) / w.maxEscapeAngle,
            Math.min(battleInfo.getMEA(-1), w.maxEscapeAngle) / w.maxEscapeAngle,
            GunUtils.limit(0, (battleInfo.lateralAcceleration + 2) / 3, 1),
            1.0 / (1 + battleInfo.timeSinceDeceleration * 0.1),
            battleInfo.getLateralDistanceLastX(10) / 8,
            (firePower - 0.1) / 2.9,
            Math.abs(normalRelativeAngle(battleInfo.relativeAngle)) / Math.PI,
            lastGF / 102.0,
            shotsTaken};
        w.setData(data);
        w.setBins(predictBins(data));
        WSMEAC.calculateEscapeAngle(battleInfo.enemyLocation, nextPosition, bulletSpeed, bulletSpeed);
        Point2D.Double p1 = WSMEAC.getEscapePosition(-1);
        Point2D.Double p2 = WSMEAC.getEscapePosition(1);
        int b1 = w.getBin(p1);
        int b2 = w.getBin(p2);
        if (a.getGunHeat() <= 0.4 && battleInfo.botEnergy - firePower >= SURVIVALIST_TRESHOLD) {
            double fireAngle = w.getFireAngle(Math.min(b1, b2), Math.max(b1, b2));
            a.setTurnGunRightRadians(normalRelativeAngle(fireAngle - a.getGunHeadingRadians()) + (bulletHitBullet / shotsTaken > 0.3 ? Math.random() * 9 / battleInfo.distance : 0));
            if (Math.abs(a.getGunTurnRemainingRadians()) < Math.atan(18 / (battleInfo.distance - 18)) && gunHeat == 0) {
                w.real = true;
                ArrayList<Object> guessFactors = new ArrayList<>();
                for (int i = 0; i < PREDICTORS.size(); i++) {
                    guessFactors.add(GunUtils.getMostVisitedBin(PREDICTORS.get(i).predict(data)));
                }
                w.setInformation(guessFactors);

                a.setFire(firePower);
                lastWave = w;

                fireAngles.add(0, fireAngle);
                fireLocations.add(0, w.fireLocation);
                maxDev.add(0, Math.atan(18 / (battleInfo.distance - 18)));

                shotsTaken++;
            }
        } else {
            a.setTurnGunRightRadians(normalRelativeAngle(w.absBearing - a.getGunHeadingRadians()));
        }
        if (battleInfo.botEnergy - firePower >= 0) {
            waves.add(w);
        }
        enemyEnergyLost -= battleInfo.enemyFirePower();
        ticks++;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        damageRecieved += Rules.getBulletDamage(e.getPower());
    }

    public void updateWaves() {
        for (int i = 0; i < waves.size(); i++) {
            Wave w = waves.get(i);
            boolean remove = w.update(battleInfo.enemyLocation);
            if (remove) {
                int bin = w.getBin(battleInfo.enemyLocation);
                for (int j = 0; j < PREDICTORS.size(); j++) {
                    PREDICTORS.get(j).wavePassed(w.data, bin, w.real, Math.atan(18 / (w.fireLocation.distance(battleInfo.enemyLocation) - 18)) / w.binWidth);
                    if (w.real) {
                        //double scoreIncreasement = 1 / (Math.pow((Integer) w.information.get(j) - bin, 2) + 1);
                        double scoreIncreasement = (Math.abs((Integer) w.information.get(j) - bin) * w.binWidth) < Math.atan(25 / (w.fireLocation.distance(battleInfo.enemyLocation) - 18)) ? w.waveDamage : 0;
                        //SCORES.set(j, SCORES.get(j) * 0.999);
                        SCORES.set(j, SCORES.get(j) + scoreIncreasement);
                        lastGF = bin;
                    }
                }
                waves.remove(i);
                i--;
            }
        }
    }

    public double[] predictBins(double[] data) {
        int bestIndex = 0;
        double bestScore = SCORES.get(0);
        for (int i = 1; i < PREDICTORS.size(); i++) {
            if (SCORES.get(i) > bestScore) {
                bestScore = SCORES.get(i);
                bestIndex = i;
            }
        }
        return PREDICTORS.get(bestIndex).predict(data);
//        double[] sumBins = new double[BINS];
//        for (int i = 0; i < PREDICTORS.size(); i++) {
//            double[] currentBins = PREDICTORS.get(i).predict(data);
//            double score = SCORES.get(i);
//            for (int j = 0; j < sumBins.length; j++) {
//                sumBins[j] += currentBins[j];
//            }
//        }
//        return sumBins;
    }

    public class BattleInfo {

        Point2D.Double location = new Point2D.Double();
        Point2D.Double enemyLocation = new Point2D.Double();

        double battleFieldWidth;
        double battleFieldHeight;

        public double velocity;
        public double heading;
        public double distance;
        public double bearing;
        public double botEnergy;

        public double oldEnemyEnergy;
        public double enemyEnergy = 100;

        public double relativeAngle;
        public double relativeHeadingAtt;
        public double lateralVelocity;
        public double advancingVelocity;
        public double lateralAcceleration;

        public int lateralDirection;

        private ArrayList<Double> lateralVelocityList = new ArrayList<>();

        public int timeSinceDeceleration;

        public double botHeading;

        public final Fangs g;

        public BattleInfo(Fangs g) {
            this.g = g;
        }

        public void run() {
            battleFieldWidth = a.getBattleFieldWidth();
            battleFieldHeight = a.getBattleFieldHeight();
        }

        public void onScannedRobot(ScannedRobotEvent e) {
            timeSinceDeceleration++;
            oldEnemyEnergy = enemyEnergy;
            location.setLocation(a.getX(), a.getY());
            botHeading = a.getHeadingRadians();
            botEnergy = a.getEnergy();
            velocity = e.getVelocity();
            heading = e.getHeadingRadians();
            bearing = e.getBearingRadians();
            distance = e.getDistance();
            enemyLocation = GunUtils.project(location, a.getHeadingRadians() + bearing, distance);
            enemyEnergy = e.getEnergy();
            relativeAngle = heading - (GunUtils.absoluteBearing(location, enemyLocation));
            relativeHeadingAtt = Math.abs(normalRelativeAngle(relativeAngle + Math.PI + (velocity > 0 ? 0 : Math.PI)));
            double newLateralVelocity = velocity * Math.sin(relativeAngle);
            lateralAcceleration = Math.abs(newLateralVelocity) - Math.abs(lateralVelocity);
            if (lateralAcceleration < 0) {
                timeSinceDeceleration = 0;
            }
            lateralVelocity = newLateralVelocity;
            lateralDirection = lateralVelocity >= 0 ? 1 : -1;
            advancingVelocity = velocity * -Math.cos(relativeAngle);

            lateralVelocityList.add(lateralVelocity);
        }

        public double getMEA(int direction) {
            double turnPerTick = 8 / distance;
            double maxIteration = Math.PI * 2 / turnPerTick;
            double angle = botHeading + bearing;
            double mea = 0;
            Point2D.Double predictedPosition = GunUtils.project(location, angle, distance);
            int iteration = 0;
            while (GunUtils.distanceToWall(predictedPosition.x,
                    predictedPosition.y,
                    battleFieldWidth,
                    battleFieldHeight) >= 18) {
                angle += turnPerTick * lateralDirection * direction;
                mea += turnPerTick;
                predictedPosition = GunUtils.project(location, angle, distance);
                if ((++iteration) > maxIteration) {
                    break;
                }
            }
            return mea;
        }

        public double getLateralDistanceLastX(int x) {
            double lateralDistance = 0;
            int startIndex = Math.max(0, lateralVelocityList.size() - x);
            for (int i = startIndex; i < lateralVelocityList.size(); i++) {
                lateralDistance += lateralVelocityList.get(i);
            }
            return Math.abs(lateralDistance) / x;
        }

        public double enemyFirePower() {
            double deltaEnergy = enemyEnergy - oldEnemyEnergy;
            if (-deltaEnergy > 0.099 && -deltaEnergy < 3.01) {
                return enemyEnergy - oldEnemyEnergy;
            }
            return 0;
        }
    }

    public class FirePowerChooser {

        public final double BULLET_POWER = 2;

        public double avgFirePower = 2;

        public double firePower() {
            double robotEnergy = battleInfo.botEnergy;
            double neededAmountToKill;
            if (battleInfo.botEnergy <= 4) {
                neededAmountToKill = battleInfo.enemyEnergy / 4;
            } else {
                neededAmountToKill = (battleInfo.enemyEnergy + 2) / 6;
            }
            //double energySaver = 1 + 1 / (Math.max(battleInfo.enemyEnergy - robotEnergy, 0) * 0.1 + 1);
            if (TC) {
                return Math.max(Math.min(robotEnergy, 3), 0.1);
            }
//            double hitRate = bulletsHit / shotsTaken;
//            double bulletPower = BULLET_POWER;
//            double highestChance = 0;
//            if (robotEnergy < 20) {
//                for (double i = 10; i <= 299; i += 1) {
//                    double firePower = i / 100.0;
//                    double bulletSpeed = 20 - 3 * firePower;
//                    double predictedHitRate = hitRate * (bulletSpeed / (20 - 3 * avgFirePower));
//                    double damageDone = (predictedHitRate * Rules.getBulletDamage(firePower)) / (int)((1 + firePower / 5) * 10);
//                    double timeUntilDeath = robotEnergy / ((firePower - (predictedHitRate * 3 * firePower)) / (int)((1 + firePower / 5) * 10) + damageRecieved / ticks);
//                    double timeUntilOppDeath = battleInfo.enemyEnergy / ((enemyEnergyLost / ticks) + damageDone);
//                    //double currentChance = (timeUntilDeath / (timeUntilDeath + timeUntilOppDeath) + (damageDone / (damageDone + damageRecieved / ticks)) * Math.max(0, robotEnergy - battleInfo.enemyEnergy) / 100) / (1 + Math.max(0, robotEnergy - battleInfo.enemyEnergy) / 100);
//                    double currentChance = timeUntilDeath / (timeUntilDeath + timeUntilOppDeath);
//                    if (currentChance > highestChance) {
//                        highestChance = currentChance;
//                        bulletPower = firePower;
//                    }
//                }
//            }
//            System.out.println(highestChance);
//            double finalPower = Math.min(Math.max(Math.min(neededAmountToKill, Math.max(bulletPower, Math.min(500 / battleInfo.distance, 2.99))), 0.1), robotEnergy);
//            avgFirePower += finalPower * 0.1;
//            avgFirePower /= 1.1;
            return Math.max(Math.min(neededAmountToKill, Math.min(robotEnergy / 20, Math.min(1200 / battleInfo.distance, Math.max(BULLET_POWER, Math.min(500 / battleInfo.distance, 3))))), 0.1);

        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.BLUE);
        if (lastWave != null) {
            if (lastWave.distanceTraveled < lastWave.waveVelocity * 3) {
                double[] bins = GunUtils.normalizeBinValues(lastWave.bins);
                for (int i = 0; i < BINS; i++) {
                    double a = lastWave.absBearing + (i - BINS / 2) * 1.0 / (BINS / 2) * lastWave.maxEscapeAngle * lastWave.lateralDirection;
                    Point2D.Double pos2 = GunUtils.project(lastWave.fireLocation, a, bins[i] * 100);
                    g.drawLine((int) lastWave.fireLocation.x,
                            (int) lastWave.fireLocation.y,
                            (int) pos2.x,
                            (int) pos2.y);
                }
            }
        }

//        g.setColor(Color.BLUE);
//        int f = 5;
//        if (lastWave != null) {
//            for (int j = 0; j < 11; j++) {
//                double[] data = lastWave.data;
//                data[6] = j / 10.0;
//                double[] bins = predictBins(data);
//                System.out.println(GunUtils.getMostVisitedBin(bins));
//                for (int i = 0; i < BINS; i++) {
//                    int startPos = j * 80;
//                    for (int x = 0; x < bins.length; x += f) {
//                        double height = bins[x] * 50;
//                        g.fillRect(startPos + x, 0, f, (int) height);
//                    }
//                }
//            }
//        }
//        System.out.println("");
//        for (int i = 0; i < Math.min(fireAngles.size(), 1); i++) {
//            Point2D.Double fireLoc = fireLocations.get(i);
//            double maxDeviation = maxDev.get(i);
//            for (int j = -1; j <= 1; j++) {
//                Point2D.Double projection = GunUtils.project(fireLoc, fireAngles.get(i) + maxDeviation * j, 1000);
//                g.setColor(new Color(255, 255, 255, 80));
//                g.drawLine((int) fireLoc.x,
//                        (int) fireLoc.y,
//                        (int) projection.x,
//                        (int) projection.y);
//                g.setColor(new Color(255, 0, 0, 30));
//            }
//        }
        g.setColor(Color.WHITE);
        Point2D.Double[] escapePositions = {WSMEAC.getEscapePosition(-1), WSMEAC.getEscapePosition(1)};
        for (int i = 0; i < escapePositions.length; i++) {
            Point2D.Double position = escapePositions[i];
            g.drawRect((int) position.x - 18, (int) position.y - 18, 36, 36);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        bulletHitBullet++;
    }

    public void onBulletHit(BulletHitEvent e) {
        bulletsHit++;
    }

    public void onRoundEnded(RoundEndedEvent e) {
        for (int i = 0; i < PREDICTORS.size(); i++) {
            System.out.println(PREDICTORS.get(i).getName() + " Score: " + SCORES.get(i));
        }
    }
}
