package stelo;
import robocode.*;
import java.awt.Color;
import robocode.util.Utils;
import java.awt.geom.*;     // for Point2D's


/**
 * WangRobot - a robot by Stelokim
 */
public class WangRobot extends Robot
{
	private static double cornerSize = 160;
	private double lastEnemyHeading;
	/**
	 * run: WangRobot's default behavior
	 */
	public void run() {
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		//setColors(Color.red,Color.blue,Color.green);
		setBodyColor(new Color(215, 47, 96) );
		
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);

		while(true) {
			 // scans automatically
			turnRadarRight(45);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		attack(e);
		move(e);
		turnRadarLeft(45);
	}
	
	// Helper function
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180) {
			return angle;
		}
		double fixedAngle = angle;

		while (fixedAngle <= -180) {
			fixedAngle += 360;
		}
		while (fixedAngle > 180) {
			fixedAngle -= 360;
		}
		return fixedAngle;
	}
				

	// sharp 90 degree movement
	private void move(ScannedRobotEvent e) {
		if (getOthers() < 3) {
			// Perpendicular RandomMovement
			turnLeft(normalRelativeAngle(90 - e.getBearing()));
			ahead(Math.random() < 0.5 ? 100 : -100);
			return;		
		}
		
		int direction;
		double angle = -1;
		double x, y, w, h;
		double leftBound = 0;
		double bottomBound = 0;
		double moveAmount = cornerSize / 2;
				
		// find nearest corner
		if (getX() > getBattleFieldWidth() / 2)
			leftBound = getBattleFieldWidth() - cornerSize;
		
		if (getY() > getBattleFieldHeight() / 2)
			bottomBound = getBattleFieldHeight() - cornerSize;
					
				
		x = getX();
		y = getY();

		direction = (int) (Math.random() * 4);
		if (y <= bottomBound + cornerSize && direction == 0) {
			// up
			angle = 0;
		} else if (y >= bottomBound && direction == 1) {
			// down
			angle = 180;
		} else if (x >= leftBound && direction == 2) {
			// left
			angle = -90;
		} else if (y <= leftBound + cornerSize && direction == 3) {
			// right
			angle = 90;
		}

		if (angle == -1)
			return;
		angle -= getHeading();
		
		if (angle >= 180) {
			angle -= 180;
			moveAmount *= -1;
		} else if (angle <= -180) {
			angle += 180;
			moveAmount *= -1;
		}
		
		//if (x >= leftBound && x <= leftBound + cornerSize && y >= bottomBound && y <= bottomBound + cornerSize)
		//	angle /= 2;
		
		// 15% chance to 4x critical
		if (Math.random() < 0.15)
			moveAmount *= 4;
		//out.println(angle);
		turnRight(angle);
		ahead(moveAmount);
	}
	/*
	public void onHitByBullet(HitByBulletEvent e) {
		if (Math.random() < 0.5) return;
		double angle;
		angle = e.getBearing() + getHeading() - getGunHeading();
		if (angle > 180) {
			angle = 360 - angle;
			turnGunLeft(angle);
		}
		else
			turnGunRight(angle);
		
		scan();
	}
	*/
	private void linearTarget(double bulletPower, ScannedRobotEvent e) {
		double myX = getX();
		double myY = getY();
		double absoluteBearing = deg2rad(getHeading() + e.getBearing() );
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = deg2rad(e.getHeading() );
		double enemyVelocity = e.getVelocity();
		
		
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;	
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
				predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
				break;
			}
		}
		double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
		
		//turnRadarRight( rad2deg(Utils.normalRelativeAngle(absoluteBearing - deg2rad(getRadarHeading() ) ) ) );
		turnGunRight( rad2deg(Utils.normalRelativeAngle(theta - deg2rad(getGunHeading() ) ) ) );
	}
	
	private void circularTarget(double bulletPower, ScannedRobotEvent e, double w) {
		double absbearing = deg2rad(e.getBearing() ) + deg2rad(getHeading() );
		double eX = e.getDistance()*Math.sin(absbearing);
		double eY = e.getDistance()*Math.cos(absbearing);

		double db = 0;
		double ww = deg2rad(e.getHeading());  // enemy's starting heading
			
		do
		{
			// db+=11; //11 is the velocity of a fire(3) bullet.
			db += (20.0 - 3.0 * bulletPower);
			double dx=e.getVelocity()*Math.sin(ww);
			double dy=e.getVelocity()*Math.cos(ww);
			ww+=w;  // turn w radians for next step
				
			eX+=dx;
			eY+=dy;
		}while (db< Point2D.distance(0,0,eX,eY));	// The bullet travelled far enough to hit our target!
		
		turnGunRight(rad2deg(Math.asin(Math.sin(Math.atan2(eX, eY) - deg2rad(getGunHeading()))) ));			
	}
	
	private void attack(ScannedRobotEvent e) {
		double bulletPower = 1.8;
		if (e.getDistance() < 100) bulletPower = 3;
				
		double w = deg2rad(e.getHeading() ) - lastEnemyHeading;
		
		bulletPower = Math.min(bulletPower, e.getEnergy() / 4);
		bulletPower = Math.min(bulletPower, getEnergy() - 2);
		
		lastEnemyHeading = deg2rad(e.getHeading() );
				
		if (bulletPower <= getEnergy() && getGunHeat() == 0) {
			//fire(bulletPower); // to use FiringAssistance, fire before move!
			if (w == 0)
				linearTarget(bulletPower, e);
			else
				circularTarget(bulletPower, e, w);
			fire(bulletPower);
		}
		
	}
	
	private double deg2rad(double d) {
		return d * Math.PI / 180;
	}
	
	private double rad2deg(double r) {
		return r * 180 / Math.PI;
	}
	
	public void onWin(WinEvent e) {
		turnRight(15);
		while (true) {
			turnLeft(30);
			ahead(50);
			turnRight(30);
			ahead(50);
		}
	}
		
}
