/*
 * Decompiled with CFR 0.152.
 */
package wcsv.PowerHouse.Movement;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;
import robocode.AdvancedRobot;
import wcsv.PowerHouse.Movement.Movement;
import wcsv.PowerHouse.Movement.MovementPredictor;
import wcsv.PowerHouse.Movement.WaveSurfingMovement;
import wcsv.PowerHouse.Utilities.Coordinator;
import wcsv.PowerHouse.Utilities.ForceVector;
import wcsv.PowerHouse.Utilities.Target;
import wcsv.PowerHouse.Utilities.Utilities;
import wcsv.PowerHouse.Utilities.Wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MoveCoordinator
extends Coordinator {
    public static Movement movement;
    public static int enemyHits;
    public LinkedList waves;
    public LinkedList nonBreaking;
    public double lastEnemyBulletPower;
    public Point2D.Double hitByBullet;
    public Point2D.Double BulletHitBullet;
    private ForceVector nextMove;
    private Target[] myPastData;
    private Target[] enemyPastData;
    public double enemyDamagePerRound;
    public double enemyDamageThisRound;
    public Wave wave;

    public void update(Target enemy, Target me) {
        this.lastEnemyBulletPower = enemy.lastEnergy - enemy.energy - enemy.damageDoneThisTick;
        if (this.lastEnemyBulletPower > 0.09 && this.lastEnemyBulletPower < 3.01) {
            this.wave = new Wave(this.enemyPastData[0] != null ? this.enemyPastData[0] : enemy, this.myPastData[1] != null ? this.myPastData[1] : me, this.lastEnemyBulletPower, 1, true);
            this.waves.add(this.wave);
        }
        this.updatePastData(me, enemy);
        if (this.hitByBullet != null) {
            Wave hittingWave = Wave.getClosestWave(this.hitByBullet, this.waves);
            movement.update(enemy, me, this.hitByBullet, hittingWave);
            ++enemyHits;
            if (hittingWave != null) {
                this.enemyDamageThisRound += Utilities.bulletDamage(hittingWave.velocity);
            }
        }
        if (this.BulletHitBullet != null) {
            movement.update(enemy, me, this.BulletHitBullet, Wave.getClosestWave(this.BulletHitBullet, this.waves));
        }
        this.hitByBullet = null;
        this.BulletHitBullet = null;
    }

    private final void updatePastData(Target me, Target enemy) {
        this.myPastData[1] = this.myPastData[0] != null ? this.myPastData[0].cloneTarget() : me.cloneTarget();
        this.myPastData[0] = me.cloneTarget();
        this.enemyPastData[1] = this.enemyPastData[0] != null ? this.enemyPastData[0].cloneTarget() : enemy.cloneTarget();
        this.enemyPastData[0] = enemy.cloneTarget();
    }

    public void onHitByBullet(Point2D.Double location) {
        this.hitByBullet = location;
    }

    public void onBulletHitBullet(Point2D.Double location) {
        this.BulletHitBullet = location;
    }

    public void performAction(Target enemy, Target me) {
        this.nextMove = movement.computeNextMove(enemy, me, this.nonBreaking);
        double distance = this.nextMove.magnitude;
        double angle = Utilities.relativeAngle(this.nextMove.bearing - me.heading);
        if (Math.abs(angle) > 1.5707963267948966) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.robot.setTurnRightRadians(angle);
        this.robot.setMaxVelocity(Math.abs(angle) >= MovementPredictor.slowTurn ? 0.0 : this.nextMove.velocity);
        this.robot.setAhead(distance);
        ListIterator it = this.waves.listIterator();
        this.nonBreaking.clear();
        while (it.hasNext()) {
            Wave curr = (Wave)it.next();
            curr.advance();
            double wDist = curr.distanceToPoint(me.location);
            if (wDist < -50.0) {
                it.remove();
                continue;
            }
            if (!(wDist >= curr.velocity * (double)2)) continue;
            this.nonBreaking.add(curr);
        }
    }

    public void reset() {
        this.waves = new LinkedList();
        this.nonBreaking = new LinkedList();
        this.myPastData = new Target[2];
        this.enemyPastData = new Target[2];
        this.hitByBullet = null;
        this.BulletHitBullet = null;
        this.enemyDamagePerRound = Utilities.rollingAvg(this.enemyDamagePerRound, this.enemyDamageThisRound, this.robot.getRoundNum());
        this.enemyDamageThisRound = 0.0;
        movement.reset(this.enemyDamagePerRound);
        System.out.print("Total enemy hits: ");
        System.out.println(enemyHits);
    }

    private final /* synthetic */ void this() {
        this.lastEnemyBulletPower = 0.0;
        this.hitByBullet = null;
        this.BulletHitBullet = null;
        this.enemyDamagePerRound = 0.0;
        this.enemyDamageThisRound = 0.0;
    }

    public MoveCoordinator(AdvancedRobot r) {
        super(r);
        this.this();
        this.waves = new LinkedList();
        this.nonBreaking = new LinkedList();
        movement = new WaveSurfingMovement();
        this.myPastData = new Target[2];
        this.enemyPastData = new Target[2];
    }

    static {
        enemyHits = 0;
    }
}

