/*
 * Decompiled with CFR 0.152.
 */
package rjw;

import java.awt.Color;
import java.awt.geom.Point2D;
import rjw.Memory;
import rjw.Props;
import rjw.SpringMovement;
import rjw.Taunter;
import rjw.gun.Turret;
import rjw.pluggablerobot.EventListener;
import rjw.pluggablerobot.PluggableRobot;
import rjw.radar.LockRadar;
import rjw.util.Particle;
import rjw.util.Vector;
import robocode.Rules;
import robocode.StatusEvent;

public class RabidWombat
extends PluggableRobot
implements EventListener.Status {
    private static Props _props;
    private Memory _memory;
    private LockRadar _radar;
    private SpringMovement _movement;
    private Turret _turret;
    private Taunter _taunter;
    private Particle _lastParticle;
    private Particle _particle;
    private long _timeOfVictory = -1L;

    public static Props getProps() {
        return _props;
    }

    @Override
    public void initBattle() {
        _props = new Props(this);
        this.setBodyColor(Color.BLACK);
        this.setGunColor(Color.LIGHT_GRAY);
        this.setRadarColor(Color.WHITE);
        this.setScanColor(Color.ORANGE);
    }

    @Override
    public void initRound() {
        this._memory = new Memory(this);
        this._radar = new LockRadar(this);
        this._movement = new SpringMovement(this);
        this._turret = new Turret(this);
        this._taunter = new Taunter(this);
        this.registerListener(this);
        this.registerListener(this._radar);
        this.registerListener(this._memory);
        this.registerListener(this._taunter);
        this.registerComponent(this._memory);
        this.registerComponent(this._movement);
        this.registerComponent(this._turret);
        this.registerComponent(this._radar);
        this.createLayer(68, "Data", true);
        this.createLayer(71, "Guns", true);
        this.createLayer(77, "Movement", true);
        this.registerPainter(77, this._movement);
        this.registerPainter(71, this._turret);
        this.registerPainter(68, this._memory);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this._taunter.notifySpawn();
    }

    @Override
    public void notifyStatus(StatusEvent event) {
        this._lastParticle = this._particle;
        this._particle = null;
    }

    public Particle getParticle() {
        if (this._particle == null) {
            this._particle = new Particle(new Point2D.Double(this.getX(), this.getY()), new Vector(this.getHeadingRadians(), this.getVelocity()));
        }
        return this._particle;
    }

    public Particle getLastParticle() {
        return this._lastParticle;
    }

    public Point2D.Double getPosition() {
        return this.getParticle().p();
    }

    public Vector getVector() {
        return this.getParticle().v();
    }

    public Memory getMemory() {
        return this._memory;
    }

    public void victoryDance() {
        long victoryTick;
        if (this._timeOfVictory == -1L) {
            this._timeOfVictory = this.getTime();
        }
        if ((victoryTick = this.getTime() - this._timeOfVictory) < 32L) {
            int direction = victoryTick % 2L == 0L ? 1 : -1;
            double beamPerc = (double)(16L - victoryTick) / 16.0;
            double angle = Rules.RADAR_TURN_RATE_RADIANS * (double)direction * beamPerc;
            this.setTurnRadarRightRadians(angle);
        }
    }
}

