/*
 * Decompiled with CFR 0.152.
 */
package rjw.radar;

import java.awt.geom.Point2D;
import rjw.AbstractComponent;
import rjw.Memory;
import rjw.RabidWombat;
import rjw.pluggablerobot.EventListener;
import rjw.util.Particle;
import rjw.util.Vector;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class LockRadar
extends AbstractComponent
implements EventListener.ScannedRobot {
    private double _angle = 0.0;
    private long _lastPing = -1L;

    public LockRadar(RabidWombat bot) {
        super(bot);
    }

    @Override
    public void notifyScannedRobot(ScannedRobotEvent event) {
        Particle me = this.getBot().getParticle();
        Memory memory = this.getBot().getMemory();
        memory.enemyScan(event, me);
        double currentRadarHeading = Utils.normalAbsoluteAngle((double)this.getBot().getRadarHeadingRadians());
        double absBearing = Utils.normalAbsoluteAngle((double)(this.getBot().getHeadingRadians() + event.getBearingRadians()));
        Vector themV = new Vector(absBearing, event.getDistance());
        Point2D.Double themP = themV.translate(me.p());
        Particle them = new Particle(themP, themV);
        Particle nextMe = me.project(1);
        Particle nextThem = them.project(1);
        Vector targetVector = nextMe.getTargetVector(nextThem);
        double nextBearing = nextMe.getAbsoluteBearing(targetVector.t);
        this._angle = Utils.normalRelativeAngle((double)(nextBearing - currentRadarHeading));
        this._lastPing = event.getTime();
    }

    @Override
    public void go() {
        if (this._lastPing != this.getBot().getTime()) {
            this._angle = Rules.RADAR_TURN_RATE_RADIANS;
        }
        this.getBot().setTurnRadarRightRadians(this._angle);
        this.getBot().getMemory().cleanUpOldWaves(this.getBot().getPosition(), this.getBot().getTime());
    }
}

