/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug.profiling;

import pedersen.debug.Debug;
import pedersen.debug.profiling.Stopwatch;

public class Stopwatches {
    public static final Stopwatch foundationTurnPreProcess = new Stopwatch();
    public static final Stopwatch foundationTurnProcess = new Stopwatch();
    public static final Stopwatch foundationTurnPostProcess = new Stopwatch();
    public static final Stopwatch foundationTurnPostProcessInboundWave = new Stopwatch();
    public static final Stopwatch foundationTurnPostProcessOutboundWave = new Stopwatch();
    public static final Stopwatch foundationTurnPostProcessOutboundVB = new Stopwatch();
    public static final Stopwatch combatantOperate = new Stopwatch();
    public static final Stopwatch combatantOperateGun = new Stopwatch();
    public static final Stopwatch combatantOperateChassis = new Stopwatch();
    public static final Stopwatch combatantOperateTurret = new Stopwatch();
    public static final Stopwatch combatantOperateScanner = new Stopwatch();
    public static final Stopwatch[] targetingMethodGetFiringAngle = Stopwatches.initStopwatchArray(20);
    public static final Stopwatch[] movementMethodGetRelativePositionTarget = Stopwatches.initStopwatchArray(30);
    private static final long nano = 1000000000L;

    private static Stopwatch[] initStopwatchArray(int count) {
        Stopwatch[] temp = new Stopwatch[count];
        int i = 0;
        while (i < count) {
            temp[i] = new Stopwatch();
            ++i;
        }
        return temp;
    }

    public static void debug() {
        Debug.line("Stopwatch foundationTurnProcess:                 " + Stopwatches.formatElapsedTime(foundationTurnProcess.getElapsedTime()));
        Debug.line("Stopwatch foundationTurnPreProcess:              " + Stopwatches.formatElapsedTime(foundationTurnPreProcess.getElapsedTime()));
        Debug.line("Stopwatch foundationTurnPostProcess:             " + Stopwatches.formatElapsedTime(foundationTurnPostProcess.getElapsedTime()));
        Debug.line("Stopwatch foundationTurnPostProcessInboundWave:  " + Stopwatches.formatElapsedTime(foundationTurnPostProcessInboundWave.getElapsedTime()));
        Debug.line("Stopwatch foundationTurnPostProcessOutboundWave: " + Stopwatches.formatElapsedTime(foundationTurnPostProcessOutboundWave.getElapsedTime()));
        Debug.line("Stopwatch foundationTurnPostProcessOutboundVB:   " + Stopwatches.formatElapsedTime(foundationTurnPostProcessOutboundVB.getElapsedTime()));
        Debug.line("Stopwatch combatantOperate:                      " + Stopwatches.formatElapsedTime(combatantOperate.getElapsedTime()));
        Debug.line("Stopwatch combatantOperateGun:                   " + Stopwatches.formatElapsedTime(combatantOperateGun.getElapsedTime()));
        Debug.line("Stopwatch combatantOperateChassis:               " + Stopwatches.formatElapsedTime(combatantOperateChassis.getElapsedTime()));
        Debug.line("Stopwatch combatantOperateTurret:                " + Stopwatches.formatElapsedTime(combatantOperateTurret.getElapsedTime()));
        Debug.line("Stopwatch combatantOperateScanner:               " + Stopwatches.formatElapsedTime(combatantOperateScanner.getElapsedTime()));
        int i = 0;
        while (i < targetingMethodGetFiringAngle.length) {
            Debug.line("Stopwatch targetingMethodGetFiringAngle[ " + i + " ]: " + Stopwatches.formatElapsedTime(targetingMethodGetFiringAngle[i].getElapsedTime()));
            ++i;
        }
        i = 0;
        while (i < movementMethodGetRelativePositionTarget.length) {
            Debug.line("Stopwatch movementMethodGetRelativePositionTarget[ " + i + " ]: " + Stopwatches.formatElapsedTime(movementMethodGetRelativePositionTarget[i].getElapsedTime()));
            ++i;
        }
    }

    protected static String formatElapsedTime(long nanoSeconds) {
        String fraction = "00000000" + nanoSeconds % 1000000000L;
        return String.valueOf(nanoSeconds / 1000000000L) + "." + fraction.substring(fraction.length() - 9) + " seconds";
    }
}

