/*
 * Decompiled with CFR 0.152.
 */
package Legend;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class X_FireFly
extends AdvancedRobot {
    int scannedX = Integer.MIN_VALUE;
    int scannedY = Integer.MIN_VALUE;
    int myX = Integer.MIN_VALUE;
    int myY = Integer.MIN_VALUE;
    int moveDirection = 1;
    double hit;
    double miss;
    double count;
    static double bulletPower = 2.0;
    double sBulletPower;
    double lBP;
    double lBPL;
    double turn;
    static int velCount;
    static int normalVelCount;
    static double latVel;
    static double totalHit;
    static double totalWin;
    static double totalDeath;
    static double loser;
    double virtualBulletCount;
    double previousEnergy = 100.0;
    public double wallStick = 120.0;
    boolean noCharge;
    boolean wavePredict;
    static boolean waveTarget;
    boolean enemyTeam = false;
    ArrayList<Wave> waveArray = new ArrayList();

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setBodyColor(new Color(34, 0, 0));
        this.setGunColor(new Color(0, 25, 0));
        this.setRadarColor(new Color(1, 0, 120));
        this.setBulletColor(Color.white);
        this.setScanColor(new Color(0, 199, 51));
        while (true) {
            this.turnRadarRight(360.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (e.getEnergy() < 0.1) {
            double absoluteBearing = e.getBearingRadians() + this.getHeadingRadians();
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
            latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing);
            double gunTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians())) + latVel / 14.0;
            this.setTurnGunRightRadians(gunTurn);
            this.setTurnRight(this.getWallSmoothedTurn(e.getBearing() + latVel));
            this.setAhead(Double.POSITIVE_INFINITY);
        } else {
            Graphics2D g = this.getGraphics();
            double changeInEnergy = this.previousEnergy - e.getEnergy();
            if (changeInEnergy > 0.0 && Math.random() >= 0.36) {
                this.moveDirection *= -1;
            }
            if (this.noCharge) {
                double totalBearing = e.getBearing();
                if (this.moveDirection == -1) {
                    totalBearing += 180.0;
                }
                if (totalBearing > 360.0) {
                    totalBearing -= 360.0;
                }
                if (totalBearing < 45.0) {
                    this.moveDirection *= -1;
                }
            }
            double absoluteBearing = e.getBearingRadians() + this.getHeadingRadians();
            double goalDirection = e.getBearing() - 90.0;
            this.setAhead(Math.random() * 300.0 * (double)this.moveDirection);
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
            this.setTurnRightRadians(this.getWallSmoothedTurn(Math.toRadians(goalDirection)));
            if (this.getGunHeat() == 0.0) {
                if (e.getEnergy() > 6.0) {
                    this.fire(bulletPower);
                } else {
                    this.fire(this.sBulletPower);
                    this.chargePaint(e);
                }
            }
            if (e.getEnergy() < 3.0) {
                this.sBulletPower = 0.1;
            }
            if (waveTarget) {
                latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing);
            }
            if (this.wavePredict) {
                double gunTurn;
                latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing);
                if (e.getDistance() >= 300.0) {
                    gunTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians())) + latVel / 22.0;
                    this.setTurnGunRightRadians(gunTurn);
                    this.noCharge = true;
                }
                if (e.getDistance() < 300.0) {
                    gunTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians())) + latVel / 13.0;
                    this.setTurnGunRightRadians(gunTurn);
                    this.noCharge = true;
                }
            } else {
                double gunTurn;
                latVel = 0.0;
                if (e.getDistance() >= 300.0) {
                    gunTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians()));
                    this.setTurnGunRightRadians(gunTurn);
                    this.noCharge = true;
                }
                if (e.getDistance() < 300.0) {
                    gunTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians()));
                    this.setTurnGunRightRadians(gunTurn);
                    this.noCharge = true;
                }
            }
            if (e.getDistance() < 100.0) {
                this.noCharge = false;
                this.charge(e);
                bulletPower = 3.0;
            } else {
                bulletPower = 2.0;
            }
            double angle = Math.toRadians((this.getHeading() + e.getBearing()) % 360.0);
            this.scannedX = (int)(this.getX() + Math.sin(angle) * e.getDistance());
            this.scannedY = (int)(this.getY() + Math.cos(angle) * e.getDistance());
            this.myX = (int)(this.getX() + Math.sin(angle));
            this.myY = (int)(this.getY() + Math.cos(angle));
            this.checkIfEnemyFired(e);
            this.predictivePaint(e);
            g.setColor(Color.white);
            ((Graphics)g).drawString("waveGun  " + velCount, 0, 50);
            ((Graphics)g).drawString("normalGun  " + normalVelCount, 0, 80);
        }
    }

    public double getWallSmoothedTurn(double t) {
        double wSD = 20.0;
        double turn = t;
        double predictiveDistance = 200.0;
        double ourHeading = this.getHeadingRadians();
        if (this.moveDirection == -1) {
            ourHeading += Math.PI;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(wSD, wSD, this.getBattleFieldWidth() - 2.0 * wSD, this.getBattleFieldHeight() - 2.0 * wSD);
        while (true) {
            double finishY;
            double totalTurn = turn + ourHeading;
            double dXTravel = Math.sin(totalTurn) * predictiveDistance;
            double dYTravel = Math.cos(totalTurn) * predictiveDistance;
            double finishX = this.getX() + dXTravel;
            if (bounds.contains(finishX, finishY = this.getY() + dYTravel)) {
                return turn;
            }
            turn += 0.1 * (double)this.moveDirection;
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.moveDirection = -this.moveDirection;
        this.out.println("I hit a wall");
    }

    public void force(ScannedRobotEvent e) {
        Graphics2D g = this.getGraphics();
        double movingForce = 0.0;
        if (e.getVelocity() > 0.0) {
            movingForce += e.getVelocity();
        }
        double force = e.getDistance();
        g.setColor(Color.white);
        g.drawLine(this.scannedX, this.scannedY, (int)this.getX(), (int)this.getY());
        g.setColor(Color.cyan);
        ((Graphics)g).drawString("DISTANCE  " + force, this.scannedX - 60, this.scannedY - 60);
        g.setColor(Color.white);
        g.drawRect(this.scannedX - 20, this.scannedY - 20, 40, 40);
        g.setColor(Color.cyan);
        g.drawLine(this.scannedX + 20, this.scannedY + 20, this.myX, this.myY);
        g.drawLine(this.scannedX - 20, this.scannedY - 20, this.myX, this.myY);
        double wSD = 20.0;
        g.setColor(Color.cyan);
        g.drawRect((int)wSD, (int)wSD, (int)this.getBattleFieldWidth() - 2 * (int)wSD, (int)this.getBattleFieldHeight() - 2 * (int)wSD);
    }

    public void manageWaves() {
        int i = 0;
        while (i < this.waveArray.size()) {
            Wave w = this.waveArray.get(i);
            w.move();
            w.paint();
            if (w.isClose() && this.getDistanceRemaining() == 0.0) {
                this.moveDirection *= -1;
                this.setBack(50 * this.moveDirection);
            }
            if (w.isPast()) {
                this.waveArray.remove(w);
            }
            ++i;
        }
    }

    public void checkIfEnemyFired(ScannedRobotEvent e) {
        double changeInEnergy = this.previousEnergy - e.getEnergy();
        if (changeInEnergy >= 0.1 && changeInEnergy <= 3.0) {
            Wave w = new Wave(e, changeInEnergy);
            this.waveArray.add(w);
        }
        this.previousEnergy = e.getEnergy();
    }

    public double retrieveX(ScannedRobotEvent e) {
        double edir = this.getHeadingRadians() + e.getBearingRadians();
        double X = this.getX() + Math.sin(edir) * e.getDistance();
        return X;
    }

    public double retrieveY(ScannedRobotEvent e) {
        double edir = this.getHeadingRadians() + e.getBearingRadians();
        double Y = this.getY() + Math.cos(edir) * e.getDistance();
        return Y;
    }

    public void chargePaint(ScannedRobotEvent e) {
        Graphics2D g = this.getGraphics();
        g.setColor(Color.red);
        g.drawLine(this.scannedX - 30, this.scannedY - 30, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 40, this.scannedY - 40, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 50, this.scannedY - 50, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 60, this.scannedY - 60, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 70, this.scannedY - 70, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 80, this.scannedY - 80, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 90, this.scannedY - 90, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 100, this.scannedY - 100, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 110, this.scannedY - 110, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 120, this.scannedY - 120, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 130, this.scannedY - 130, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX - 140, this.scannedY - 140, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 30, this.scannedY + 30, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 40, this.scannedY + 40, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 50, this.scannedY + 50, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 60, this.scannedY + 60, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 70, this.scannedY + 70, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 80, this.scannedY + 80, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 90, this.scannedY + 90, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 100, this.scannedY + 100, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 110, this.scannedY + 110, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 120, this.scannedY + 120, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 130, this.scannedY + 130, (int)this.getX(), (int)this.getY());
        g.drawLine(this.scannedX + 140, this.scannedY + 140, (int)this.getX(), (int)this.getY());
    }

    public void charge(ScannedRobotEvent e) {
        this.setTurnRightRadians(e.getBearingRadians());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double myHeading = this.getHeading();
        double movingPower = myHeading * (double)this.moveDirection;
        double chooseDirection = movingPower + Math.random() * 90.0 * (double)this.moveDirection;
        this.setTurnRight(chooseDirection);
        this.moveDirection *= -1;
        this.setTurnRight(chooseDirection);
        this.setAhead(30 * this.moveDirection);
        this.turn += 1.0;
        this.out.println("total hit  " + (totalHit += 1.0));
        this.out.println("turn  " + this.turn);
        if (this.enemyTeam) {
            this.doNothing();
            this.doNothing();
            this.doNothing();
            this.doNothing();
            this.doNothing();
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        if (++velCount > 4) {
            this.wavePredict = true;
            this.out.println("Target learning...");
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        --velCount;
        if (++normalVelCount > 6) {
            waveTarget = true;
            this.out.println("FINAL TARGET LEARNING!!!");
        }
    }

    public void onWin(WinEvent e) {
        this.setAhead(60.0);
        this.out.println("LOOSER  " + (loser += 1.0) + "  TIMES IN A ROW :)");
    }

    public void onDeath(DeathEvent e) {
        loser = 0.0;
        this.out.println("learning...");
    }

    public void predictivePaint(ScannedRobotEvent e) {
        Graphics2D g = this.getGraphics();
        double angle = Math.toRadians((this.getHeading() + e.getBearing()) % 360.0);
        int scannedX = (int)(this.getX() + Math.sin(angle) * e.getDistance());
        int scannedY = (int)(this.getY() + Math.cos(angle) * e.getDistance());
        int i = 0;
        i = 0;
        while (i < 1) {
            g.setColor(Color.yellow);
            g.drawLine(scannedX, scannedY, (int)this.getX() - i, (int)this.getY() - i);
            ++i;
        }
    }

    public class Wave {
        double distanceFromOrigin = 0.0;
        double waveSpeed;
        double originX;
        double originY;
        ScannedRobotEvent e;

        public Wave(ScannedRobotEvent event, double firePower) {
            this.e = event;
            this.originX = X_FireFly.this.retrieveX(this.e);
            this.originY = X_FireFly.this.retrieveY(this.e);
            this.waveSpeed = 20.0 - firePower * 3.0;
        }

        public void move() {
            this.distanceFromOrigin += this.waveSpeed;
        }

        public boolean isClose() {
            return this.distanceFromOrigin > this.e.getDistance() - 300.0;
        }

        public boolean isPast() {
            return this.distanceFromOrigin > this.e.getDistance();
        }

        public void paint() {
            double bottomX = this.originX - this.distanceFromOrigin;
            double bottomY = this.originY - this.distanceFromOrigin;
            Graphics2D g = X_FireFly.this.getGraphics();
            g.setColor(Color.white);
            g.drawOval((int)bottomX, (int)bottomY, (int)(this.distanceFromOrigin * 2.0), (int)(this.distanceFromOrigin * 2.0));
        }
    }
}

