/*
 * Decompiled with CFR 0.152.
 */
package abc.wiki;

import robocode.AdvancedRobot;

final class BotUtils {
    BotUtils() {
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static double sinD(double ang) {
        return Math.sin(Math.toRadians(ang));
    }

    public static double cosD(double ang) {
        return Math.cos(Math.toRadians(ang));
    }

    public static double tanD(double ang) {
        return Math.tan(Math.toRadians(ang));
    }

    public static double angleTo(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(1.5707963267948966 - Math.atan2(y2 - y1, x2 - x1));
    }

    public static double angleToRadians(double x1, double y1, double x2, double y2) {
        return 1.5707963267948966 - Math.atan2(y2 - y1, x2 - x1);
    }

    public static double angleTo(AdvancedRobot bot, double x, double y) {
        return Math.toDegrees(1.5707963267948966 - Math.atan2(y - bot.getY(), x - bot.getX()));
    }

    public static double angleToRadians(AdvancedRobot bot, double x, double y) {
        return 1.5707963267948966 - Math.atan2(y - bot.getY(), x - bot.getX());
    }

    public static double distanceTo(double x1, double y1, double x2, double y2) {
        return Math.sqrt(BotUtils.sqr(x2 - x1) + BotUtils.sqr(y2 - y1));
    }

    public static double distanceTo(AdvancedRobot bot, double x2, double y2) {
        return Math.sqrt(BotUtils.sqr(x2 - bot.getX()) + BotUtils.sqr(y2 - bot.getY()));
    }

    public static double normalizeBearing(double ang) {
        if ((ang %= 360.0) > 180.0) {
            ang -= 360.0;
        }
        if (ang < -180.0) {
            ang += 360.0;
        }
        return ang;
    }

    public static double normalizeBearingRadians(double ang) {
        if ((ang = ang % Math.PI * 2.0) > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static void setTurnToAngle(AdvancedRobot bot, double ang) {
        bot.setTurnRight(BotUtils.normalizeBearing(ang - bot.getHeading()));
    }

    public static void setTurnToAngleRadians(AdvancedRobot bot, double ang) {
        bot.setTurnLeftRadians(BotUtils.normalizeBearingRadians(bot.getHeadingRadians() - ang));
    }

    public static double setTurnToAngle90(AdvancedRobot bot, double ang) {
        double ang1 = BotUtils.normalizeBearing(bot.getHeading() - ang);
        if (ang1 > 90.0) {
            ang1 -= 180.0;
        }
        if (ang1 < -90.0) {
            ang1 += 180.0;
        }
        bot.setTurnLeft(ang1);
        return bot.getHeading() < 90.0 || bot.getHeading() > 270.0 ? 1 : -1;
    }

    public static void setTurnGunToAngle(AdvancedRobot bot, double ang) {
        bot.setTurnGunLeft(BotUtils.normalizeBearing(bot.getGunHeading() - ang));
    }

    public static void setTurnRadarToAngle(AdvancedRobot bot, double ang) {
        bot.setTurnRadarLeft(BotUtils.normalizeBearing(bot.getRadarHeading() - ang));
    }

    public static void setGoto(AdvancedRobot bot, double x, double y) {
        double dist = Math.sqrt(BotUtils.sqr(bot.getX() - x) + BotUtils.sqr(bot.getY() - y));
        double ang = BotUtils.normalizeBearing(BotUtils.angleTo(bot, x, y) - bot.getHeading());
        if (Math.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        if (Math.abs(ang) > 20.0) {
            bot.setMaxVelocity(3.0);
        } else {
            bot.setMaxVelocity(8.0);
        }
        bot.setTurnRight(ang);
        bot.setAhead(dist);
    }
}

