/*
 * Decompiled with CFR 0.152.
 */
package rsalesc.roborio.utils;

import robocode.AdvancedRobot;
import robocode.RobotStatus;
import robocode.StatusEvent;
import robocode.util.Utils;
import rsalesc.roborio.utils.Physics;
import rsalesc.roborio.utils.R;
import rsalesc.roborio.utils.geo.AxisRectangle;
import rsalesc.roborio.utils.geo.Point;

public abstract class BackAsFrontRobot
extends AdvancedRobot {
    private int idle = 0;
    private RobotStatus status;
    private AxisRectangle field;
    private double _maxVelocity = 8.0;
    private boolean sharpened = false;
    private double _velocityBeforeSharp;

    public void onStatus(StatusEvent statusEvent) {
        if (this.sharpened) {
            super.setMaxVelocity(this._velocityBeforeSharp);
            this._maxVelocity = this._velocityBeforeSharp;
            this.sharpened = false;
        }
        this.idle = this.status != null && this.status.getGunHeat() == 0.0 && this.status.getGunHeat() == statusEvent.getStatus().getGunHeat() ? ++this.idle : 0;
        this.status = statusEvent.getStatus();
        this.field = this._getBattleField();
    }

    public double getX() {
        return this.status.getX();
    }

    public double getY() {
        return this.status.getY();
    }

    public double getHeadingRadians() {
        return this.status.getHeadingRadians();
    }

    public double getHeading() {
        return this.status.getHeading();
    }

    public int getRoundNum() {
        return this.status.getRoundNum();
    }

    public long getTime() {
        return this.status.getTime();
    }

    public double getEnergy() {
        return this.status.getEnergy();
    }

    public double getVelocity() {
        return this.status.getVelocity();
    }

    public int getOthers() {
        return this.status.getOthers();
    }

    public double getGunHeat() {
        return this.status.getGunHeat();
    }

    public double getGunHeadingRadians() {
        return this.status.getGunHeadingRadians();
    }

    public double getGunHeading() {
        return this.status.getGunHeading();
    }

    public void setMaxVelocity(double d) {
        if (!this.sharpened) {
            this._maxVelocity = d;
            super.setMaxVelocity(d);
        } else {
            this._velocityBeforeSharp = d;
        }
    }

    public Point getPoint() {
        return new Point(this.getX(), this.getY());
    }

    private AxisRectangle _getBattleField() {
        return new AxisRectangle(0.0, this.getBattleFieldWidth(), 0.0, this.getBattleFieldHeight());
    }

    public AxisRectangle getBattleField() {
        return this.field;
    }

    public static double getQuickestTurn(double d) {
        if (Math.abs(d) < R.HALF_PI) {
            return d;
        }
        return Utils.normalRelativeAngle((double)(d + R.PI));
    }

    public void setBackAsFront(double d, double d2) {
        d = Utils.normalAbsoluteAngle((double)d);
        double d3 = Utils.normalRelativeAngle((double)(d - this.getHeadingRadians()));
        double d4 = BackAsFrontRobot.getQuickestTurn(d3);
        this.setTurnRightRadians(R.isNear(d2, 0.0) ? 0.0 : d4);
        this.setAhead(d2 * (double)(d3 == d4 ? 1 : -1));
    }

    public void moveWithBackAsFront(Point point, double d) {
        this.setBackAsFront(Physics.absoluteBearing(this.getPoint(), point), d);
    }

    public void moveWithBackAsFront(Point point) {
        this.moveWithBackAsFront(point, this.getPoint().distance(point));
    }
}

