/*
 * Decompiled with CFR 0.152.
 */
package eem.bot;

import eem.bot.botStatPoint;
import eem.misc.graphics;
import eem.misc.physics;
import eem.misc.profiler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;

public class InfoBot {
    protected String name = "";
    public LinkedList<botStatPoint> botStats = new LinkedList();

    public InfoBot() {
    }

    public InfoBot(String string) {
        this();
        this.setName(string);
    }

    public void initTic(long l) {
    }

    public boolean hasLast() {
        int n = this.botStats.size();
        return n >= 1;
    }

    public boolean hasPrev() {
        int n = this.botStats.size();
        return n >= 2;
    }

    public botStatPoint getLast() {
        if (this.hasLast()) {
            return this.botStats.getLast();
        }
        return null;
    }

    public botStatPoint getPrev() {
        int n = this.botStats.size();
        if (this.hasPrev()) {
            return this.botStats.get(n - 2);
        }
        return null;
    }

    public InfoBot update(Point2D.Double double_, long l) {
        this.botStats.add(new botStatPoint(double_, l));
        return this;
    }

    public InfoBot update(botStatPoint botStatPoint2) {
        String string = "InfoBot.update for " + this.getName();
        profiler.start(string);
        this.botStats.add(botStatPoint2);
        profiler.stop(string);
        return this;
    }

    public double getEnergy() {
        if (this.hasLast()) {
            return this.getLast().getEnergy();
        }
        return 0.0;
    }

    public Point2D.Double getVelocity() {
        if (this.hasLast()) {
            return this.getLast().getVelocity();
        }
        return new Point2D.Double(0.0, 0.0);
    }

    public void setName(String string) {
        this.name = string;
    }

    public double getLastDistance(Point2D.Double double_) {
        if (this.hasLast()) {
            return this.getLast().getDistance(double_);
        }
        return 1000000.0;
    }

    public double getX() {
        if (this.hasLast()) {
            return this.getLast().getX();
        }
        return 0.0;
    }

    public double getY() {
        if (this.hasLast()) {
            return this.getLast().getY();
        }
        return 0.0;
    }

    public double getHeadingDegrees() {
        if (this.hasLast()) {
            return this.getLast().getHeadingDegrees();
        }
        return 0.0;
    }

    public Point2D.Double getPosition() {
        if (this.hasLast()) {
            return this.getLast().getPosition();
        }
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double getPosition(long l) {
        return this.getPositionAtTime(l);
    }

    public Point2D.Double getPrevTicPosition() {
        Point2D.Double double_ = this.getPositionAtTime(this.getLast().getTime() - 1L);
        if (double_ == null) {
            double_ = (Point2D.Double)this.getPosition().clone();
            double_.x -= this.getVelocity().x;
            double_.y -= this.getVelocity().y;
        }
        return double_;
    }

    public Point2D.Double getPrevPosition() {
        if (this.hasPrev()) {
            return this.getPrev().getPosition();
        }
        return null;
    }

    public Point2D.Double getPositionAtTime(long l) {
        botStatPoint botStatPoint2 = this.getStatAtTime(l);
        if (botStatPoint2 == null) {
            return null;
        }
        return botStatPoint2.getPosition();
    }

    public Point2D.Double getPositionClosestToTime(long l) {
        botStatPoint botStatPoint2 = this.getStatClosestToTime(l);
        if (botStatPoint2 == null) {
            return null;
        }
        return botStatPoint2.getPosition();
    }

    public botStatPoint getStatClosestToTime(long l) {
        int n = this.botStats.size();
        botStatPoint botStatPoint2 = null;
        botStatPoint botStatPoint3 = null;
        long l2 = 1000000000L;
        long l3 = 1000000000L;
        for (int i = n - 1; i >= 0 && (l3 = Math.abs(l - (botStatPoint2 = this.botStats.get(i)).getTime())) < l2; --i) {
            botStatPoint3 = botStatPoint2;
            l2 = l3;
        }
        return botStatPoint3;
    }

    public botStatPoint getStatAtTime(long l) {
        int n = this.botStats.size();
        botStatPoint botStatPoint2 = null;
        botStatPoint2 = this.getStatClosestToTime(l);
        if (botStatPoint2 == null) {
            return null;
        }
        if (botStatPoint2.getTime() == l) {
            return botStatPoint2;
        }
        return null;
    }

    public long getLastSeenTime() {
        if (this.hasLast()) {
            return this.getLast().getTime();
        }
        return -1000L;
    }

    public double energyDrop() {
        if (this.hasPrev()) {
            if (physics.isTimeInSameRound(this.getPrev().getTime(), this.getLast().getTime())) {
                return this.getPrev().getEnergy() - this.getLast().getEnergy();
            }
            return 0.0;
        }
        return 0.0;
    }

    public String getName() {
        return this.name;
    }

    public String format() {
        String string = this.hasPrev() ? "Prev: " + this.getPrev().format() : "Prev: unknown";
        String string2 = this.hasLast() ? "Last: " + this.getLast().format() : "Last: unknown";
        int n = this.botStats.size();
        String string3 = "Target bot name: " + this.getName() + "\n" + string2 + "\n" + string;
        string3 = string3 + "\n stats size " + n;
        return string3;
    }

    public void drawLastKnownBotPosition(Graphics2D graphics2D) {
        if (this.hasLast()) {
            double d = 50.0;
            botStatPoint botStatPoint2 = this.getLast();
            graphics.drawSquare(graphics2D, botStatPoint2.getPosition(), d);
        }
    }

    public void drawBotPath(Graphics2D graphics2D) {
        ListIterator<botStatPoint> listIterator = this.botStats.listIterator(this.botStats.size());
        if (!listIterator.hasPrevious()) {
            return;
        }
        botStatPoint botStatPoint2 = listIterator.previous();
        long l = physics.getRoundStartTime(botStatPoint2.getTime());
        while (listIterator.hasPrevious()) {
            botStatPoint botStatPoint3 = listIterator.previous();
            if (botStatPoint3.getTime() < l) {
                return;
            }
            graphics.drawLine(graphics2D, botStatPoint2.getPosition(), botStatPoint3.getPosition());
            botStatPoint2 = botStatPoint3;
        }
    }

    public void onPaint(Graphics2D graphics2D) {
        graphics2D.setColor(new Color(255, 255, 0, 128));
        this.drawBotPath(graphics2D);
        this.drawLastKnownBotPosition(graphics2D);
    }
}

