/*
 * Decompiled with CFR 0.152.
 */
package jcz.linio.util;

import ags.utils.KdTree;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jcz.linio.Linio;
import jcz.linio.util.Constants;
import jcz.linio.util.Indice;
import jcz.linio.util.LUtils;
import jcz.linio.util.PreciseUtils;
import jcz.linio.util.PreciseWave;
import jcz.linio.util.RobotState;
import jcz.linio.util.StoreScan;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.util.Utils;

public class GunWave
implements Constants {
    public static ArrayList paintPoints = new ArrayList();
    public static int ASHits;
    public static int DCHits;
    public static int actualHits;
    public static int DCASHits;
    public static Point2D.Double targLoc;
    public static double targetHeading;
    public static int GUN;
    public long fireTime;
    public double bulletPower;
    public Point2D.Double gunLoc;
    public double bearing;
    public double latDir;
    public double MEA_pos;
    public double MEA_neg;
    public double MEA_norm;
    public double BFT;
    public boolean bulletFired = false;
    public double[] currentASBuffer;
    public int[] ASIndexes;
    public Bullet bullet;
    public static KdTree<StoreScan> heapTree;
    public static double[][][][] ASBuffer;
    public static double[][] ASSlices;
    public static long currentTime;
    public StoreScan storeScan = new StoreScan();
    public boolean intersecting = false;
    public double bestOffset;
    public double DCOffset;
    public double ASOffset;
    public double DCASOffset;
    public RobotState scan;
    private AdvancedRobot robot;
    private double distanceTraveled;

    static {
        GUN = 0;
    }

    public GunWave(AdvancedRobot _robot) {
        this.robot = _robot;
    }

    public boolean test() {
        if (this.fireTime + 1L == currentTime) {
            this.gunLoc = Linio.myLoc;
        }
        PreciseWave w = new PreciseWave();
        w.bulletVelocity = LUtils.bulletVelocity(this.bulletPower);
        w.distanceTraveled = (double)(currentTime - this.fireTime) * w.bulletVelocity;
        w.fireLoc = this.gunLoc;
        if (LUtils.sqr(w.distanceTraveled + 26.0) >= this.gunLoc.distanceSq(targLoc)) {
            int CODE = PreciseUtils.intersects(targLoc, w);
            if (CODE == 3) {
                double[] range = PreciseUtils.getIntersectionRange(targLoc, w);
                double GF_neg = Utils.normalRelativeAngle((double)(range[0] - this.bearing)) * this.latDir;
                double GF_pos = Utils.normalRelativeAngle((double)(range[1] - this.bearing)) * this.latDir;
                this.storeScan.range.min = Math.min(GF_neg, this.storeScan.range.min);
                this.storeScan.range.min = Math.min(GF_pos, this.storeScan.range.min);
                this.storeScan.range.max = Math.max(GF_neg, this.storeScan.range.max);
                this.storeScan.range.max = Math.max(GF_pos, this.storeScan.range.max);
                this.intersecting = true;
            }
            if (CODE == 1) {
                Point2D.Double centerPoint = new Point2D.Double((this.scan.enemyLocation.x + this.gunLoc.x) * 0.5, (this.scan.enemyLocation.y + this.gunLoc.y) * 0.5);
                Point2D.Double futurePoint = Linio.myLoc;
                Point2D.Double mirrorTarget = new Point2D.Double(2.0 * centerPoint.x - futurePoint.x, 2.0 * centerPoint.y - futurePoint.y);
                double mirrorBearing = LUtils.absoluteBearing(this.gunLoc, mirrorTarget);
                this.scan.mirrorOffset = Utils.normalRelativeAngle((double)(mirrorBearing - this.bearing)) * this.scan.dir;
                Linio.currentGF = this.currentGF();
                this.storeScan.range.width = (this.storeScan.range.max - this.storeScan.range.min) / this.MEA_norm;
                this.storeScan.range.center = (this.storeScan.range.max + this.storeScan.range.min) / (2.0 * this.MEA_norm);
                this.storeScan.range.max = this.storeScan.range.max > 0.0 ? (this.storeScan.range.max /= this.MEA_pos) : (this.storeScan.range.max /= this.MEA_neg);
                this.storeScan.range.min = this.storeScan.range.min > 0.0 ? (this.storeScan.range.min /= this.MEA_pos) : (this.storeScan.range.min /= this.MEA_neg);
                heapTree.addPoint(this.scan.location(), this.storeScan);
                this.logASBuffer(this.storeScan.range.center, 0.025);
                if (this.bulletFired) {
                    this.logASBuffer(this.storeScan.range.center, 1.0);
                    ++Linio.bulletsMissed;
                    double minAngle = this.storeScan.range.min > 0.0 ? this.storeScan.range.min * this.MEA_pos * this.latDir : this.storeScan.range.min * this.MEA_neg * this.latDir;
                    double maxAngle = this.storeScan.range.max > 0.0 ? this.storeScan.range.max * this.MEA_pos * this.latDir : this.storeScan.range.max * this.MEA_neg * this.latDir;
                    double min = Math.min(minAngle, maxAngle);
                    double max = Math.max(minAngle, maxAngle);
                    if (this.ASOffset > min && this.ASOffset < max) {
                        ++ASHits;
                    }
                    if (this.DCOffset > min && this.DCOffset < max) {
                        ++DCHits;
                    }
                    if (this.bestOffset > min && this.bestOffset < max) {
                        ++actualHits;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void setSegmentations(RobotState rs) {
        this.scan = rs;
        this.storeScan.location = this.scan.location();
        this.fireTime = rs.time;
        currentTime = rs.time;
        this.gunLoc = rs.location;
        targLoc = rs.enemyLocation;
        if (heapTree == null) {
            heapTree = new KdTree.Manhattan<StoreScan>(this.storeScan.location.length, new Integer(100000));
            ASBuffer = new double[4][3][5][47];
            ASSlices = new double[][]{{3.0, 5.0, 7.0}, {0.5, 1.5}, {300.0, 450.0, 700.0, 900.0}};
        }
        this.MEA_norm = LUtils.maxEscAngle(LUtils.bulletVelocity(this.bulletPower));
        this.MEA_pos = rs.MEA_pos;
        this.MEA_neg = rs.MEA_neg;
        this.BFT = rs.ETA;
        targetHeading = rs.heading;
        this.ASIndexes = new int[]{LUtils.getIndex(ASSlices[0], Math.abs(rs.latVel)), LUtils.getIndex(ASSlices[1], rs.acc), LUtils.getIndex(ASSlices[2], rs.dist)};
        this.currentASBuffer = ASBuffer[this.ASIndexes[0]][this.ASIndexes[1]][this.ASIndexes[2]];
    }

    private boolean hasArrived() {
        return (double)(currentTime - this.fireTime + 1L) * LUtils.bulletVelocity(this.bulletPower) > this.gunLoc.distance(targLoc);
    }

    private double currentGF() {
        double normAngle = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(this.gunLoc, targLoc) - this.bearing)) * this.latDir;
        if (normAngle > 0.0) {
            return normAngle / this.MEA_pos;
        }
        return normAngle / this.MEA_neg;
    }

    private double getOffset(KdTree heapTree, double[] location, int maxCluster, boolean inverseWeight) {
        List cluster = heapTree.nearestNeighbor(location, Math.min((int)Math.ceil(Math.sqrt(heapTree.size())), Math.min(heapTree.size(), maxCluster)), false);
        Iterator it = cluster.iterator();
        if (cluster.size() >= 1) {
            Object[] indices = new Indice[cluster.size() * 2];
            int i = 0;
            int k = cluster.size();
            while (i < k) {
                KdTree.Entry e = it.next();
                StoreScan s = (StoreScan)e.value;
                double weight = inverseWeight ? 1.0 / (1.0E-10 + e.distance) : 1.0;
                Indice ind = new Indice();
                ind.position = s.range.min;
                ind.height = weight;
                indices[i * 2] = ind;
                ind = new Indice();
                ind.position = s.range.max;
                ind.height = -weight;
                indices[i * 2 + 1] = ind;
                ++i;
            }
            Arrays.sort(indices);
            int maxIndex = indices.length / 2 - 1;
            double value = 0.0;
            double maxValue = 0.0;
            int i2 = 0;
            while (i2 < indices.length - 1) {
                if ((value += ((Indice)indices[i2]).height) >= maxValue) {
                    maxIndex = i2;
                    maxValue = value;
                }
                ++i2;
            }
            double fireGF = (((Indice)indices[maxIndex]).position + ((Indice)indices[maxIndex + 1]).position) / 2.0;
            double fireOffset = fireGF > 0.0 ? fireGF * this.MEA_pos : fireGF * this.MEA_neg;
            return LUtils.limit(-this.MEA_neg, fireOffset, this.MEA_pos) * this.latDir;
        }
        return Math.abs(this.scan.latVel) * 0.125 * this.MEA_pos * this.latDir;
    }

    public double mostVisitedBearingOffset() {
        this.DCOffset = this.getOffset(heapTree, this.storeScan.location, 100, true);
        this.ASOffset = this.getASOffset();
        double hits = ASHits;
        double round = this.robot.getRoundNum();
        if (round < 2.0 || (double)DCHits >= hits * 0.8 && round < 7.0 || (double)DCHits >= hits * 0.9 && round < 15.0 || (double)DCHits >= hits) {
            if (GUN != 0) {
                System.out.println("Using Main (DC) Gun");
                GUN = 0;
            }
            this.bestOffset = this.DCOffset;
        } else {
            if (GUN != 2) {
                System.out.println("Using AS Gun");
                GUN = 2;
            }
            this.bestOffset = this.ASOffset;
        }
        return this.bestOffset;
    }

    private double getASOffset() {
        int BINS = this.currentASBuffer.length;
        int MIDDLE_BIN = (BINS - 1) / 2;
        double maxScore = 0.0;
        int bestIndex = MIDDLE_BIN;
        int i = 1;
        while (i < BINS) {
            double score = this.currentASBuffer[i - 1] + this.currentASBuffer[i];
            if (score > maxScore) {
                maxScore = score;
                bestIndex = i;
            }
            ++i;
        }
        double ratio = this.currentASBuffer[bestIndex - 1] / (this.currentASBuffer[bestIndex - 1] + this.currentASBuffer[bestIndex]);
        double offset = (double)bestIndex - ratio - (double)MIDDLE_BIN;
        return LUtils.limit(-this.MEA_neg, offset * this.MEA_norm / (double)MIDDLE_BIN, this.MEA_pos) * this.latDir;
    }

    public void logASBuffer(double GF, double weight) {
        int BINS = this.currentASBuffer.length;
        int MIDDLE_BIN = (BINS - 1) / 2;
        double index = GF * (double)MIDDLE_BIN + (double)MIDDLE_BIN;
        double[] profile = new double[BINS];
        int i = 0;
        while (i < BINS) {
            profile[i] = 1.0 / (LUtils.sqr(index - (double)i) + 1.0);
            ++i;
        }
        double[] dists = new double[3];
        int j = 0;
        while (j < 4) {
            dists[0] = (double)LUtils.sqr(j - this.ASIndexes[0]) * 13.8;
            int k = 0;
            while (k < 3) {
                dists[1] = (double)LUtils.sqr(k - this.ASIndexes[1]) * 24.5;
                int p = 0;
                while (p < 5) {
                    dists[2] = (double)LUtils.sqr(p - this.ASIndexes[2]) * 8.8;
                    double w = weight / (1.0 + dists[0] + dists[1] + dists[2]);
                    double den = 1.0 / (3.0 + Math.abs(w));
                    int i2 = 0;
                    while (i2 < BINS) {
                        GunWave.ASBuffer[j][k][p][i2] = (3.0 * ASBuffer[j][k][p][i2] + w * profile[i2]) * den;
                        ++i2;
                    }
                    ++p;
                }
                ++k;
            }
            ++j;
        }
    }
}

