/*
 * Decompiled with CFR 0.152.
 */
package us.bluetorch.robocode.gun;

import java.awt.geom.Point2D;
import java.util.HashMap;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import us.bluetorch.robocode.gun.Gun;

public class DynamicCluster
extends Gun {
    Point2D enemyLocation;
    double enemyEnergy;
    double enemyDistance;
    boolean aiming;
    public int logLevel = 2;
    public double minBulletPower = 0.1;
    public double maxBulletPower = 3.0;
    boolean referenceMode = false;
    protected long lastAimTime = 0L;
    private int maxSize = 150000;
    private int centerHitDist = 0;
    private long missedScans = 0L;
    private double toleranceWidth = 20.0;
    public static HashMap<String, ScanInfo> firstMap;
    public static HashMap<String, ScanInfo> lastMap;
    public String currentTarget;
    public int size = 0;
    private double lastDir = 1.0;
    private double lastRunDir = 0.0;
    private long lastRunStart = 0L;
    private double lastRunTime = 0.0;
    private double lastVel;
    long startTime = 0L;
    double bulletPower = 3.0;
    private long lastTime = 0L;
    private double battleFieldWidth;
    private double battleFieldHeight;
    private double tolerance = 0.0;
    private double nextX = 0.0;
    private double nextY = 0.0;
    private double headOnAngle;
    private int totalEnemies;
    private int round = -1;

    public DynamicCluster(AdvancedRobot robot) {
        super(robot);
        this.battleFieldWidth = robot.getBattleFieldWidth();
        this.battleFieldHeight = robot.getBattleFieldHeight();
        this.totalEnemies = robot.getOthers();
        if (firstMap == null) {
            firstMap = new HashMap();
            lastMap = new HashMap();
        }
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        if (this.robot.getOthers() == 0) {
            for (String key : firstMap.keySet()) {
                ScanInfo first = firstMap.get(key);
                while (this.size / this.totalEnemies > this.maxSize / this.totalEnemies) {
                    first = first.next;
                    --this.size;
                }
                first.previous = null;
                firstMap.put(key, first);
            }
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e, double power) {
        this.currentTarget = e.getName();
        if (e.getName().equals(this.getTarget())) {
            this.bulletPower = power;
        }
        if (this.referenceMode && this.robot.getEnergy() <= 0.1) {
            return;
        }
        long t1 = this.robot.getTime() - this.startTime;
        if (t1 - this.lastTime > 1L) {
            this.missedScans += t1 - this.lastTime - 1L;
        }
        if (t1 - this.lastTime > 20L || t1 < this.lastTime) {
            this.lastRunStart = this.startTime = this.robot.getTime();
        }
        t1 = this.robot.getTime() - this.startTime;
        double dist = e.getDistance();
        double velocity = e.getVelocity();
        double heading = (this.robot.getHeading() + e.getBearing()) % 360.0;
        if (heading < 0.0) {
            heading += 360.0;
        }
        double x = this.robot.getX() + dist * DynamicCluster.sinD(heading);
        double y = this.robot.getY() + dist * DynamicCluster.cosD(heading);
        this.enemyLocation = new Point2D.Double(x, y);
        this.enemyEnergy = e.getEnergy();
        this.enemyDistance = dist;
        double d = this.lastDir = velocity != 0.0 ? velocity : this.lastDir;
        if (velocity != this.lastVel) {
            this.lastRunTime = Math.min(40.0, (double)t1 - (double)this.lastRunStart) / 40.0;
            this.lastRunStart = t1;
        }
        this.lastRunDir = this.lastDir;
        heading = this.lastDir < 0.0 ? (e.getHeading() + 180.0) % 360.0 : e.getHeading();
        ScanInfo currInfo = new ScanInfo(x, y, heading, Math.abs(velocity) / 8.0, t1);
        currInfo.dtm = Math.min(e.getDistance(), 800.0) / 800.0;
        currInfo.runTime = Math.min(40.0, (double)(t1 - this.lastRunStart)) / 40.0;
        currInfo.lastRunTime = this.lastRunTime;
        currInfo.myGunHeat = Math.min(1.5, this.robot.getGunHeat()) / 1.5;
        if (Math.abs(this.lastVel) > Math.abs(velocity)) {
            currInfo.acc = 1.0;
        } else if (Math.abs(this.lastVel) < Math.abs(velocity)) {
            currInfo.acc = -1.0;
        }
        this.lastVel = velocity;
        currInfo.atm = Math.abs(DynamicCluster.normalizeBearing(heading - this.robot.getHeading() - e.getBearing())) / 180.0;
        double maxWDist = 400.0;
        double distV = 0.0;
        double distH = 0.0;
        distV = heading == 90.0 || heading == 270.0 ? Double.POSITIVE_INFINITY : (heading < 90.0 || heading > 270.0 ? (this.battleFieldHeight - y) / DynamicCluster.cosD(heading) : y / DynamicCluster.cosD(heading - 180.0));
        distH = heading == 180.0 || heading == 0.0 ? Double.POSITIVE_INFINITY : (heading < 180.0 ? (this.battleFieldWidth - x) / DynamicCluster.cosD(heading - 90.0) : x / DynamicCluster.cosD(heading - 180.0 - 90.0));
        currInfo.dtwf = 1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist;
        double h1 = (heading + 180.0) % 360.0;
        if (h1 < 0.0) {
            h1 += 360.0;
        }
        distV = h1 == 90.0 || h1 == 270.0 ? Double.POSITIVE_INFINITY : (h1 < 90.0 || h1 > 270.0 ? (this.battleFieldHeight - y) / DynamicCluster.cosD(h1) : y / DynamicCluster.cosD(h1 - 180.0));
        distH = h1 == 180.0 || h1 == 0.0 ? Double.POSITIVE_INFINITY : (h1 < 180.0 ? (this.battleFieldWidth - x) / DynamicCluster.cosD(h1 - 90.0) : x / DynamicCluster.cosD(h1 - 180.0 - 90.0));
        currInfo.dtwb = 1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist;
        if (lastMap.containsKey(this.currentTarget)) {
            ScanInfo last = lastMap.get(this.currentTarget);
            last.next = currInfo;
            currInfo.previous = last;
            lastMap.put(this.currentTarget, currInfo);
        } else {
            firstMap.put(this.currentTarget, currInfo);
            lastMap.put(this.currentTarget, currInfo);
        }
        ++this.size;
        this.lastTime = t1;
    }

    @Override
    public void init() {
        if (this.robot.getRoundNum() > this.round) {
            this.round = this.robot.getRoundNum();
            this.enemyLocation = null;
            this.aiming = false;
        }
    }

    @Override
    public void onStatus(StatusEvent e) {
        Bullet b = null;
        if (this.enemyLocation == null) {
            this.robot.setTurnGunRight(this.robot.getRadarTurnRemaining());
            if (this.robot.getOthers() == 0) {
                this.robot.setFire(0.1);
            }
        } else {
            double nextTurn = this.robot.getTurnRemaining() >= 0.0 ? Math.min(this.robot.getTurnRemaining(), 10.0 - 0.75 * Math.abs(this.robot.getVelocity())) : Math.max(this.robot.getTurnRemaining(), -10.0 + 0.75 * Math.abs(this.robot.getVelocity()));
            double nextD = this.robot.getHeading() + nextTurn;
            this.nextX = this.robot.getX() + this.robot.getVelocity() * DynamicCluster.sinD(nextTurn);
            this.nextY = this.robot.getY() + this.robot.getVelocity() * DynamicCluster.cosD(nextTurn);
            this.headOnAngle = DynamicCluster.angleTo(this.nextX, this.nextY, this.enemyLocation.getX(), this.enemyLocation.getY());
            if (this.robot.getGunHeat() > this.robot.getGunCoolingRate() || this.robot.getEnergy() < this.bulletPower || this.bulletPower == 0.0) {
                this.aiming = false;
                this.robot.setTurnGunRight(DynamicCluster.normalizeBearing(this.headOnAngle - this.robot.getGunHeading()));
            } else if (this.aiming && this.robot.getGunTurnRemaining() == 0.0 && this.robot.getGunHeat() == 0.0) {
                b = this.robot.setFireBullet(this.bulletPower);
                this.aiming = false;
            } else if (!this.aiming) {
                this.lastAimTime = this.robot.getTime();
                double fireAngle = this.findBestAngle();
                if (fireAngle != 10000.0) {
                    this.robot.setTurnGunRight(DynamicCluster.normalizeBearing(fireAngle - this.robot.getGunHeading()));
                    this.aiming = true;
                } else {
                    this.robot.setTurnGunRight(DynamicCluster.normalizeBearing(this.headOnAngle - this.robot.getGunHeading()));
                }
            }
        }
    }

    public double findBestAngle() {
        int j;
        ScanInfo last;
        int topCount = 50;
        int angMax = 50;
        if (!lastMap.containsKey(this.currentTarget)) {
            return this.headOnAngle;
        }
        ScanInfo info = last = lastMap.get(this.currentTarget);
        info.fired = true;
        ScanInfo currentInfo = info;
        double currentDistance = 0.0;
        boolean newRound = true;
        ScanInfo[] topInfo = new ScanInfo[topCount];
        double[] topDiff = new double[topCount];
        double bestAngle = 0.0;
        long t1 = info.t;
        long time = (long)(DynamicCluster.distanceTo(this.robot, last.x, last.y) / (20.0 - 3.0 * this.bulletPower) * 1.1);
        for (int i = 0; i < topCount; ++i) {
            topDiff[i] = Double.POSITIVE_INFINITY;
            topInfo[i] = currentInfo;
        }
        long iCount = 0L;
        while (info.previous != null) {
            int i;
            if (newRound) {
                t1 = info.t;
                while (info.previous != null && t1 - info.t < time && info.t <= t1) {
                    ++iCount;
                    info = info.previous;
                }
                if (info.t > t1) continue;
                newRound = false;
                continue;
            }
            currentDistance = 0.0;
            currentDistance += DynamicCluster.sqr(currentInfo.dtm - info.dtm) * 4.0;
            currentDistance += DynamicCluster.sqr(currentInfo.atm - info.atm);
            currentDistance += DynamicCluster.sqr(currentInfo.v - info.v) * 2.0;
            currentDistance += DynamicCluster.sqr(currentInfo.dtwf - info.dtwf) * 4.0;
            currentDistance += DynamicCluster.sqr(currentInfo.dtwb - info.dtwb);
            currentDistance += DynamicCluster.sqr(currentInfo.runTime - info.runTime);
            currentDistance += DynamicCluster.sqr(currentInfo.lastRunTime - info.lastRunTime);
            currentDistance += DynamicCluster.sqr((currentInfo.acc - info.acc) / 2.0);
            for (i = topCount - 1; i >= 0 && currentDistance < topDiff[i]; --i) {
            }
            if (i < topCount - 1) {
                ++i;
                for (int j2 = topCount - 2; j2 >= i; --j2) {
                    topDiff[j2 + 1] = topDiff[j2];
                    topInfo[j2 + 1] = topInfo[j2];
                }
                topDiff[i] = currentDistance;
                topInfo[i] = info;
            }
            info = info.previous;
            ++iCount;
            if (info.t <= t1) continue;
            newRound = true;
        }
        double[] dists = new double[topCount];
        for (int i = 0; i < topCount; ++i) {
            dists[i] = topDiff[i];
        }
        double[][] angles = new double[topCount][4];
        for (int i = 0; i < topCount; ++i) {
            angles[i][0] = 1000.0;
        }
        int angCount = 0;
        double angSum = 0.0;
        double avgAng = 0.0;
        for (int i = 0; i < topCount && angCount < angMax; ++i) {
            double ang = this.getGunAngle(topInfo[i]);
            if (!(ang < 1000.0)) continue;
            angles[angCount][0] = ang = DynamicCluster.normalizeBearing(ang - this.headOnAngle);
            angles[angCount][1] = this.tolerance;
            angles[angCount][2] = 1.0;
            angles[angCount][3] = 1.0;
            for (j = 0; j < angCount; ++j) {
                if (!(angles[j][0] < 1000.0)) continue;
                if (Math.abs(angles[j][0] - angles[angCount][0]) < angles[angCount][1]) {
                    double[] dArray = angles[j];
                    dArray[2] = dArray[2] + angles[angCount][3];
                }
                if (!(Math.abs(angles[angCount][0] - angles[j][0]) < angles[j][1])) continue;
                double[] dArray = angles[angCount];
                dArray[2] = dArray[2] + angles[j][3];
            }
            ++angCount;
            angSum += ang;
        }
        double maxCount = 0.0;
        int maxIDX = 0;
        for (j = 0; j < angCount; ++j) {
            if (!(angles[j][2] > maxCount)) continue;
            maxCount = angles[j][2];
            maxIDX = j;
        }
        bestAngle = angles[maxIDX][0];
        if (bestAngle >= 1000.0) {
            bestAngle = 0.0;
        }
        return this.headOnAngle + bestAngle;
    }

    public double getGunAngle(ScanInfo predictedInfo) {
        this.tolerance = 0.0;
        ScanInfo currInfo = lastMap.get(this.currentTarget);
        ScanInfo endInfo = predictedInfo;
        long timeDelta = this.robot.getTime() - this.startTime - currInfo.t;
        double predx = 0.0;
        double predy = 0.0;
        double predDist = 0.0;
        double bulletSpeed = 20.0 - 3.0 * this.bulletPower;
        for (int i = 0; i < 50; ++i) {
            predDist = DynamicCluster.distanceTo(endInfo.x, endInfo.y, predictedInfo.x, predictedInfo.y);
            double predAng = 1.5707963267948966 - Math.atan2(endInfo.y - predictedInfo.y, endInfo.x - predictedInfo.x) - Math.toRadians(predictedInfo.d);
            predx = currInfo.x + predDist * Math.sin(Math.toRadians(currInfo.d) + predAng);
            long bulletTime = (long)((predDist = DynamicCluster.distanceTo(predx, predy = currInfo.y + predDist * Math.cos(Math.toRadians(currInfo.d) + predAng), this.nextX, this.nextY) - (double)this.centerHitDist) / bulletSpeed) + 1L;
            if (Math.abs(endInfo.t - predictedInfo.t - timeDelta - bulletTime) <= 1L) break;
            endInfo = predictedInfo;
            while (endInfo.next != null && endInfo.t >= predictedInfo.t && endInfo.t - predictedInfo.t - timeDelta < bulletTime) {
                endInfo = endInfo.next;
            }
            if (endInfo.next != null && endInfo.t >= predictedInfo.t) continue;
            return Double.POSITIVE_INFINITY;
        }
        if (predx < 0.0 || predx > this.battleFieldWidth || predy < 0.0 || predy > this.battleFieldHeight) {
            return Double.POSITIVE_INFINITY;
        }
        this.tolerance = Math.toDegrees(this.toleranceWidth / predDist);
        return Math.toDegrees(1.5707963267948966 - Math.atan2(predy - this.nextY, predx - this.nextX));
    }

    private static double sqr(double x) {
        return x * x;
    }

    public static double sinD(double ang) {
        return Math.sin(Math.toRadians(ang));
    }

    public static double cosD(double ang) {
        return Math.cos(Math.toRadians(ang));
    }

    public static double tanD(double ang) {
        return Math.tan(Math.toRadians(ang));
    }

    public static double angleTo(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(1.5707963267948966 - Math.atan2(y2 - y1, x2 - x1));
    }

    public static double angleToRadians(double x1, double y1, double x2, double y2) {
        return 1.5707963267948966 - Math.atan2(y2 - y1, x2 - x1);
    }

    public static double angleTo(AdvancedRobot bot, double x, double y) {
        return Math.toDegrees(1.5707963267948966 - Math.atan2(y - bot.getY(), x - bot.getX()));
    }

    public static double angleToRadians(AdvancedRobot bot, double x, double y) {
        return 1.5707963267948966 - Math.atan2(y - bot.getY(), x - bot.getX());
    }

    public static double distanceTo(double x1, double y1, double x2, double y2) {
        return Math.sqrt(DynamicCluster.sqr(x2 - x1) + DynamicCluster.sqr(y2 - y1));
    }

    public static double distanceTo(AdvancedRobot bot, double x2, double y2) {
        return Math.sqrt(DynamicCluster.sqr(x2 - bot.getX()) + DynamicCluster.sqr(y2 - bot.getY()));
    }

    public static double normalizeBearing(double ang) {
        if ((ang %= 360.0) > 180.0) {
            ang -= 360.0;
        }
        if (ang < -180.0) {
            ang += 360.0;
        }
        return ang;
    }

    public static double normalizeBearingRadians(double ang) {
        if ((ang = ang % Math.PI * 2.0) > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static void setTurnToAngle(AdvancedRobot bot, double ang) {
        bot.setTurnRight(DynamicCluster.normalizeBearing(ang - bot.getHeading()));
    }

    public static void setTurnToAngleRadians(AdvancedRobot bot, double ang) {
        bot.setTurnLeftRadians(DynamicCluster.normalizeBearingRadians(bot.getHeadingRadians() - ang));
    }

    public static double setTurnToAngle90(AdvancedRobot bot, double ang) {
        double ang1 = DynamicCluster.normalizeBearing(bot.getHeading() - ang);
        if (ang1 > 90.0) {
            ang1 -= 180.0;
        }
        if (ang1 < -90.0) {
            ang1 += 180.0;
        }
        bot.setTurnLeft(ang1);
        return bot.getHeading() < 90.0 || bot.getHeading() > 270.0 ? 1 : -1;
    }

    public static void setTurnGunToAngle(AdvancedRobot bot, double ang) {
        bot.setTurnGunLeft(DynamicCluster.normalizeBearing(bot.getGunHeading() - ang));
    }

    public static void setTurnRadarToAngle(AdvancedRobot bot, double ang) {
        bot.setTurnRadarLeft(DynamicCluster.normalizeBearing(bot.getRadarHeading() - ang));
    }

    public static void setGoto(AdvancedRobot bot, double x, double y) {
        double dist = Math.sqrt(DynamicCluster.sqr(bot.getX() - x) + DynamicCluster.sqr(bot.getY() - y));
        double ang = DynamicCluster.normalizeBearing(DynamicCluster.angleTo(bot, x, y) - bot.getHeading());
        if (Math.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        if (Math.abs(ang) > 20.0) {
            bot.setMaxVelocity(3.0);
        } else {
            bot.setMaxVelocity(8.0);
        }
        bot.setTurnRight(ang);
        bot.setAhead(dist);
    }

    public class ScanInfo {
        public double x = 0.0;
        public double y = 0.0;
        public double d = 0.0;
        public long t = 0L;
        public double v = 0.0;
        public double acc = 0.0;
        public double atm = 0.0;
        public double dtm = 0.0;
        public double dtwf = 0.0;
        public double dtwb = 0.0;
        public double runTime = 0.0;
        public double lastRunTime = 0.0;
        public double myGunHeat = 0.0;
        public boolean fired = false;
        public ScanInfo previous;
        public ScanInfo next;

        public ScanInfo(double x1, double y1, double d1, double v1, long t1) {
            this.x = x1;
            this.y = y1;
            this.d = d1;
            this.v = v1;
            this.t = t1;
        }
    }
}

