/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.AgentSmith.DangerPrediction.CachedVelocityData;
import rdt.AgentSmith.EnemyPrediction.EnemyPredictionManager;
import rdt.AgentSmith.Guns.RaikoGun;
import rdt.AgentSmith.IBattleEndedEventHandler;
import rdt.AgentSmith.IBulletHitBulletEventHandler;
import rdt.AgentSmith.IBulletHitEventHandler;
import rdt.AgentSmith.IDebugDrawer;
import rdt.AgentSmith.IHitByBulletEventHandler;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.IRobotDeathEventHandler;
import rdt.AgentSmith.IRoundEndedEventHandler;
import rdt.AgentSmith.IRoundStartedEventHandler;
import rdt.AgentSmith.IScannedRobotEventHandler;
import rdt.AgentSmith.Movement.DangerPredictionMode;
import rdt.AgentSmith.Profiling.Profiler;
import rdt.AgentSmith.Radar.FindAnyTargetMode;
import rdt.AgentSmith.Radar.FocusTargetMode;
import rdt.AgentSmith.RobotHistory.RobotHistory;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.RobotHistory.RobotSnapshotUtils;
import rdt.AgentSmith.Stats.Counter;
import rdt.AgentSmith.Stats.Stats;
import rdt.AgentSmith.SubsystemManager;
import rdt.AgentSmith.Targeting.ClosestTargetMode;
import rdt.AgentSmith.Targeting.ITargeting;
import rdt.AgentSmith.Targeting.Target;
import rdt.AgentSmith.Targeting.Targeting;
import rdt.AgentSmith.Utils.MathUtils;
import rdt.AgentSmith.Utils.RuleUtils;
import rdt.AgentSmith.Waves.EnemyWaveManager;
import rdt.AgentSmith.Waves.FriendlyWaveManager;
import rdt.AgentSmith.Waves.IWaveManager;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.util.Utils;

public class AgentSmithRedux
extends AdvancedRobot
implements IRobot {
    private static SubsystemManager _radarSubsystem;
    private static SubsystemManager _targetingSubsystem;
    private static SubsystemManager _movementSubsystems;
    private static SubsystemManager _gunSubsystem;
    private static IWaveManager _friendlyWaveManager;
    private static IWaveManager _enemyWaveManager;
    private static ITargeting _targeting;
    private static EnemyPredictionManager _enemyPredictionManager;
    private static RobotHistory _ownHistory;
    private static Profiler _profiler;
    private static Stats _stats;
    private static ArrayList<IScannedRobotEventHandler> _scannedRobotEventHandlers;
    private static ArrayList<IRobotDeathEventHandler> _robotDeathEventHandlers;
    private static ArrayList<IRoundStartedEventHandler> _roundStartedEventHandlers;
    private static ArrayList<IRoundEndedEventHandler> _roundEndedEventHandlers;
    private static ArrayList<IBulletHitEventHandler> _bulletHitEventHandlers;
    private static ArrayList<IHitByBulletEventHandler> _hitByBulletEventHandlers;
    private static ArrayList<IBulletHitBulletEventHandler> _bulletHitBulletEventHandlers;
    private static ArrayList<IBattleEndedEventHandler> _battleEndedEventHandlers;
    private static ArrayList<IDebugDrawer> _debugDrawers;
    private static double _botSizeMax;
    private double _nextX;
    private double _nextY;
    private static Counter _skippedTurnsCounter;
    private static Counter _hitWallCounter;
    private static Counter _hitEnemyCounter;
    private static RaikoGun _raikoGun;

    @Override
    public double getBotSizeMax() {
        return _botSizeMax;
    }

    public void run() {
        this.Initialise();
        while (true) {
            Profiler.StartScope("Main Loop");
            this.UpdateOwnHistory();
            _targetingSubsystem.Update();
            _radarSubsystem.Update();
            _friendlyWaveManager.Update();
            _enemyWaveManager.Update();
            _enemyPredictionManager.Update();
            _movementSubsystems.Update();
            if (_raikoGun == null) {
                _gunSubsystem.Update();
            }
            Profiler.EndScope();
            this.execute();
        }
    }

    private void Initialise() {
        if (_stats == null) {
            _stats = new Stats(this);
            _stats.RegisterStat(_skippedTurnsCounter);
            _stats.RegisterStat(_hitWallCounter);
            _stats.RegisterStat(_hitEnemyCounter);
        }
        if (_raikoGun == null) {
            // empty if block
        }
        this.setColors(Color.white, Color.black, Color.white);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        _botSizeMax = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
        RuleUtils.Initialise(this);
        CachedVelocityData.Initialise();
        MathUtils.FastSin(0.0);
        MathUtils.FastCos(0.0);
        if (_profiler == null) {
            _profiler = new Profiler(this);
        }
        if (_ownHistory == null) {
            _ownHistory = new RobotHistory(200);
        } else {
            _ownHistory.Clear();
        }
        if (_targeting == null) {
            _targeting = new Targeting(this, _stats);
        }
        if (_radarSubsystem == null) {
            _radarSubsystem = new SubsystemManager("Radar");
            _radarSubsystem.AddMode(new FindAnyTargetMode(this, _targeting));
            _radarSubsystem.AddMode(new FocusTargetMode(this, _targeting));
        }
        if (_targetingSubsystem == null) {
            _targetingSubsystem = new SubsystemManager("Targeting");
            _targetingSubsystem.AddMode(new ClosestTargetMode(_targeting));
        }
        if (_friendlyWaveManager == null) {
            _friendlyWaveManager = new FriendlyWaveManager((IRobot)this, _targeting);
        }
        if (_enemyWaveManager == null) {
            _enemyWaveManager = new EnemyWaveManager((IRobot)this, _targeting);
            _targeting.SetWaveManagers(_friendlyWaveManager, _enemyWaveManager);
        }
        if (_enemyPredictionManager == null) {
            _enemyPredictionManager = new EnemyPredictionManager(this, _targeting, _enemyWaveManager);
        }
        if (_movementSubsystems == null) {
            _movementSubsystems = new SubsystemManager("Movement");
            _movementSubsystems.AddMode(new DangerPredictionMode(this, _targeting, _enemyPredictionManager, _stats));
        }
        if (_gunSubsystem == null) {
            _gunSubsystem = new SubsystemManager("Gun");
            _gunSubsystem.AddMode(new rdt.AgentSmith.Guns.ClosestTargetMode(this, _targeting, _friendlyWaveManager));
        }
        this.SetNextX(this.getX());
        this.SetNextY(this.getY());
        for (int index = 0; index < _roundStartedEventHandlers.size(); ++index) {
            _roundStartedEventHandlers.get(index).OnRoundStartedEvent();
        }
    }

    @Override
    public RobotHistory GetRobotHistory() {
        return _ownHistory;
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        for (int index = 0; index < _scannedRobotEventHandlers.size(); ++index) {
            _scannedRobotEventHandlers.get(index).OnScannedRobotEvent(event);
        }
        if (_raikoGun != null) {
            _raikoGun.onScannedRobot(event);
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        _skippedTurnsCounter.Increment();
    }

    public void onHitWall(HitWallEvent event) {
        _hitWallCounter.Increment();
    }

    public void onRobotDeath(RobotDeathEvent event) {
        for (int index = 0; index < _robotDeathEventHandlers.size(); ++index) {
            _robotDeathEventHandlers.get(index).OnRobotDeathEvent(event);
        }
    }

    public void onRoundEnded(RoundEndedEvent event) {
        for (int index = 0; index < _roundEndedEventHandlers.size(); ++index) {
            _roundEndedEventHandlers.get(index).OnRoundEndedEvent(event);
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        for (int index = 0; index < _bulletHitEventHandlers.size(); ++index) {
            _bulletHitEventHandlers.get(index).OnBulletHitEvent(event);
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        for (int index = 0; index < _hitByBulletEventHandlers.size(); ++index) {
            _hitByBulletEventHandlers.get(index).OnHitByBulletEvent(event);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent eventData) {
        for (int index = 0; index < _bulletHitBulletEventHandlers.size(); ++index) {
            _bulletHitBulletEventHandlers.get(index).OnBulletHitBulletEvent(eventData);
        }
    }

    public void onBattleEnded(BattleEndedEvent event) {
        for (int index = 0; index < _battleEndedEventHandlers.size(); ++index) {
            _battleEndedEventHandlers.get(index).OnBattleEndedEvent(event);
        }
    }

    public void onPaint(Graphics2D gfx) {
        for (int index = 0; index < _debugDrawers.size(); ++index) {
            _debugDrawers.get(index).DebugDraw(gfx);
        }
    }

    @Override
    public void RegisterForEventHandling(IScannedRobotEventHandler eventHandler) {
        _scannedRobotEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IRobotDeathEventHandler eventHandler) {
        _robotDeathEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IRoundStartedEventHandler eventHandler) {
        _roundStartedEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IRoundEndedEventHandler eventHandler) {
        _roundEndedEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IBulletHitEventHandler eventHandler) {
        _bulletHitEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IHitByBulletEventHandler eventHandler) {
        _hitByBulletEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IBulletHitBulletEventHandler eventHandler) {
        _bulletHitBulletEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterForEventHandling(IBattleEndedEventHandler eventHandler) {
        _battleEndedEventHandlers.add(eventHandler);
    }

    @Override
    public void RegisterDebugDrawer(IDebugDrawer debugDrawer) {
        _debugDrawers.add(debugDrawer);
    }

    private void UpdateOwnHistory() {
        double targetX = this.getX();
        double targetY = this.getY();
        double absAngleFromTarget = 0.0;
        if (_targeting.HasValidTarget()) {
            Target target = _targeting.GetCurrentTarget();
            RobotSnapshot targetSnapshot = target.RobotHistory.GetSnapshotForTick(this.getTime());
            if (targetSnapshot != null) {
                targetX = targetSnapshot.LocationX;
                targetY = targetSnapshot.LocationY;
                absAngleFromTarget = Utils.normalAbsoluteAngle((double)(targetSnapshot.AbsoluteAngleFromItsTarget + Math.PI));
            }
        }
        RobotSnapshot snapshot = _ownHistory.GetSnapshotForWriting();
        RobotSnapshotUtils.FillInSnapshot(this, snapshot, _ownHistory, this.getX(), this.getY(), this.getVelocity(), this.getHeadingRadians(), targetX, targetY, absAngleFromTarget, this.getEnergy());
        _ownHistory.SubmitSnapshot(snapshot);
    }

    @Override
    public double NextX() {
        return this._nextX;
    }

    @Override
    public double NextY() {
        return this._nextY;
    }

    @Override
    public void SetNextX(double x) {
        this._nextX = x;
    }

    @Override
    public void SetNextY(double y) {
        this._nextY = y;
    }

    static {
        _scannedRobotEventHandlers = new ArrayList();
        _robotDeathEventHandlers = new ArrayList();
        _roundStartedEventHandlers = new ArrayList();
        _roundEndedEventHandlers = new ArrayList();
        _bulletHitEventHandlers = new ArrayList();
        _hitByBulletEventHandlers = new ArrayList();
        _bulletHitBulletEventHandlers = new ArrayList();
        _battleEndedEventHandlers = new ArrayList();
        _debugDrawers = new ArrayList();
        _skippedTurnsCounter = new Counter("Issues : SkippedTurns");
        _hitWallCounter = new Counter("Issues : HitWall");
        _hitEnemyCounter = new Counter("Issues : HitEnemy");
    }
}

