/*
 * Decompiled with CFR 0.152.
 */
package dk.predict;

import dk.Base;
import dk.Enemy;
import dk.Point;
import dk.Util;
import dk.predict.Factors;

public class Tracer {
    protected Base robot_;
    protected Enemy target_;
    protected Factors factors_;
    protected double power_;
    protected double bulletVelocity_;
    protected long start;
    protected Point bulletStartPosition;
    protected double enemyAngle;
    protected double actualAngle = 0.0;
    protected static final long MAX_LATENCY = 2L;
    protected static final double MAX_RANGE = 1200.0;
    public static final int TRACER_FLY = 0;
    public static final int TRACER_HIT = 1;
    public static final int TRACER_MISS = 2;

    public Tracer(Base robot, Enemy target, double power, Factors factors) {
        this.robot_ = robot;
        this.target_ = target;
        this.power_ = power;
        this.factors_ = factors;
        this.start = this.robot_.getTime();
        this.bulletStartPosition = this.robot_.getPosition();
        this.enemyAngle = Util.bearing(this.bulletStartPosition, this.target_.getEstimatedPosition(this.start));
        this.bulletVelocity_ = Util.bulletVelocity(this.power_);
    }

    public int track() {
        long now = this.robot_.getTime();
        double bulletRange = this.bulletVelocity_ * (double)(now - this.start + 1L);
        Point enemyPosition = this.target_.getEstimatedPosition(now);
        double enemyRange = Util.range(this.bulletStartPosition, enemyPosition);
        if (enemyRange <= bulletRange) {
            if (bulletRange - enemyRange > this.bulletVelocity_) {
                return 2;
            }
            if (now - this.target_.getLastSeen() > 2L) {
                return 2;
            }
            this.actualAngle = Util.bearing(this.bulletStartPosition, enemyPosition);
            return 1;
        }
        if (bulletRange <= 1200.0) {
            return 0;
        }
        return 2;
    }

    public Factors getFactors() {
        return this.factors_;
    }

    public Point getBulletStartPosition() {
        return this.bulletStartPosition;
    }

    public Point getRobotStartPosition() {
        return this.bulletStartPosition;
    }

    public double getBulletVelocity() {
        return this.bulletVelocity_;
    }

    public double getEnemyAngle() {
        return this.enemyAngle;
    }

    public double getPower() {
        return this.power_;
    }

    public long getStart() {
        return this.start;
    }

    public Enemy getTarget() {
        return this.target_;
    }

    public double getActualAngle() {
        return this.actualAngle;
    }
}

