/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.AbstractGravPoint;
import amarok.AntiGravPoint;
import amarok.BotConstants;
import amarok.BotMath;
import amarok.BulletLine;
import amarok.Enemy;
import amarok.GuiLogger;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import robocode.AdvancedRobot;

public class MoveVector
implements BotConstants {
    double X;
    double Y;
    double XX;
    double YY;
    double w;
    double h;

    public void add(double force, double alpha) {
        this.XX += Math.sin(alpha) * force;
        this.YY += Math.cos(alpha) * force;
    }

    public void addWallMoves() {
        AntiGravPoint gp = new AntiGravPoint(this.X, this.h, 300.0, 2.0);
        double force = ((AbstractGravPoint)gp).getForce(this.X, this.Y);
        double alpha = this.X < this.w / 2.0 ? 5.497787143782138 : 0.7853981633974483;
        this.add(force, alpha);
        GuiLogger.logGravityVector(this.X, this.h, force, alpha);
        gp = new AntiGravPoint(this.w, this.Y, 300.0, 2.0);
        force = ((AbstractGravPoint)gp).getForce(this.X, this.Y);
        alpha = this.Y < this.h / 2.0 ? 2.356194490192345 : 0.7853981633974483;
        this.add(force, alpha);
        GuiLogger.logGravityVector(this.w, this.Y, force, alpha);
        gp = new AntiGravPoint(this.X, 0.0, 300.0, 2.0);
        force = ((AbstractGravPoint)gp).getForce(this.X, this.Y);
        alpha = this.X < this.w / 2.0 ? 3.9269908169872414 : 2.356194490192345;
        this.add(force, alpha);
        GuiLogger.logGravityVector(this.X, 0.0, force, alpha);
        gp = new AntiGravPoint(0.0, this.Y, 300.0, 2.0);
        force = ((AbstractGravPoint)gp).getForce(this.X, this.Y);
        alpha = this.Y < this.h / 2.0 ? 3.9269908169872414 : 5.497787143782138;
        this.add(force, alpha);
        GuiLogger.logGravityVector(0.0, this.Y, force, alpha);
    }

    public void addEnemyMoves(Hashtable h) {
        Enumeration e = h.elements();
        while (e.hasMoreElements()) {
            Enemy nme = (Enemy)e.nextElement();
            double x = nme.getPoint().x;
            double y = nme.getPoint().y;
            GuiLogger.logBot(nme.getName(), x, y, nme.getHeading());
            AntiGravPoint gp = new AntiGravPoint(x, y, 400.0, 2.0);
            double force = ((AbstractGravPoint)gp).getForce(this.X, this.Y);
            double alpha = BotMath.getAlpha(x, y, this.X, this.Y);
            this.add(force, alpha);
            GuiLogger.logGravityVector(x, y, force, alpha);
        }
    }

    public void addBulletsMoves(Vector h, long now) {
        Enumeration e = h.elements();
        while (e.hasMoreElements()) {
            BulletLine bullet = (BulletLine)e.nextElement();
            if (!bullet.isActive(now)) {
                h.remove(bullet);
                continue;
            }
            Point2D.Double pStart = bullet.getPointAtStart();
            Point2D.Double pNow = bullet.getPointAtTime(now);
            AntiGravPoint gp = new AntiGravPoint(pNow.x, pNow.y, 400.0, 2.0);
            GuiLogger.logBullet(bullet.getName(), pNow.x, pNow.y);
            double force = ((AbstractGravPoint)gp).getForce(this.X, this.Y);
            double alphaMeStart = BotMath.getAlpha(this.X, this.Y, pStart.x, pStart.y);
            double alphaBulletStart = BotMath.getAlpha(pNow.x, pNow.y, pStart.x, pStart.y);
            double alphaStartBullet = BotMath.getAlpha(pStart.x, pStart.y, pNow.x, pNow.y);
            double alpha = alphaMeStart < alphaBulletStart ? alphaStartBullet - 1.5707963267948966 : alphaStartBullet + 1.5707963267948966;
            GuiLogger.logGravityVector(pNow.x, pNow.y, force, alpha);
            this.add(force, alpha);
        }
    }

    public double getDistance() {
        if (this.XX < 0.0) {
            this.XX = 0.0;
        }
        if (this.XX > this.w) {
            this.XX = this.w;
        }
        if (this.YY < 0.0) {
            this.YY = 0.0;
        }
        if (this.YY > this.h) {
            this.YY = this.h;
        }
        return BotMath.getDistance(this.X, this.Y, this.XX, this.YY);
    }

    public double getAlpha() {
        return BotMath.getAlpha(this.XX, this.YY, this.X, this.Y);
    }

    public void move(AdvancedRobot me) {
        double force = this.getDistance();
        double alpha = this.getAlpha();
        GuiLogger.logGravityVector(this.X, this.Y, force, alpha);
        double moveOffset = BotMath.optimizeOffset(me.getHeadingRadians() - alpha);
        double moveDirection = Math.abs(me.getHeadingRadians() - alpha) < 1.5707963267948966 ? 1 : -1;
        me.setTurnLeftRadians(moveOffset * moveDirection);
        me.setAhead(force * moveDirection);
    }

    public void goTo(double x, double y, AdvancedRobot me) {
        this.XX = x;
        this.YY = y;
        this.move(me);
    }

    public void rotate(AdvancedRobot me) {
        me.setTurnLeftRadians(Math.PI);
    }

    public MoveVector(double X, double Y, double w, double h) {
        this.X = X;
        this.Y = Y;
        this.XX = X;
        this.YY = Y;
        this.w = w;
        this.h = h;
    }
}

