/*
 * Decompiled with CFR 0.152.
 */
package bh.components.history;

import bh.units.Angle;
import bh.units.Bearing;
import bh.units.Distance;
import bh.units.Energy;
import bh.units.Heat;
import bh.units.RelativeLocation;
import bh.units.Speed;
import bh.units.Units;
import bh.units.interfaces.AbsoluteToRelative;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobotDelta
implements AbsoluteToRelative<RobotDelta, RobotDelta> {
    private final Energy energyDelta;
    private final RelativeLocation locationDelta;
    private final Bearing headingDelta;
    private final Speed speedDelta;
    private final Bearing gunHeadingDelta;
    private final Heat gunHeatDelta;
    private final Bearing radarHeadingDelta;

    RobotDelta(Energy energyDelta, RelativeLocation locationDelta, Bearing headingDelta, Speed speedDelta, Bearing gunHeadingDelta, Heat gunHeatDelta, Bearing radarHeadingDelta) {
        this.energyDelta = energyDelta;
        this.locationDelta = locationDelta;
        this.headingDelta = headingDelta;
        this.speedDelta = speedDelta;
        this.gunHeadingDelta = gunHeadingDelta;
        this.gunHeatDelta = gunHeatDelta;
        this.radarHeadingDelta = radarHeadingDelta;
    }

    public Energy energyDelta() {
        return this.energyDelta;
    }

    public RelativeLocation locationDelta() {
        return this.locationDelta;
    }

    public Bearing headingDelta() {
        return this.headingDelta;
    }

    public Speed speedDelta() {
        return this.speedDelta;
    }

    public Bearing gunHeadingDelta() {
        return this.gunHeadingDelta;
    }

    public Heat gunHeatDelta() {
        return this.gunHeatDelta;
    }

    public Bearing radarHeadingDelta() {
        return this.radarHeadingDelta;
    }

    boolean empty() {
        return this.energyDelta() == null && this.locationDelta() == null && this.headingDelta() == null && this.speedDelta() == null && this.gunHeadingDelta() == null && this.gunHeatDelta() == null && this.radarHeadingDelta() == null;
    }

    @Override
    public RobotDelta minus(RobotDelta rd) {
        return new Builder().energyDelta((Energy)Units.minusWithNulls(this.energyDelta(), rd.energyDelta())).locationDelta((RelativeLocation)Units.minusWithNulls(this.locationDelta(), rd.locationDelta())).headingDelta((Bearing)Units.minusWithNulls(this.gunHeadingDelta(), rd.gunHeadingDelta())).speedDelta((Speed)Units.minusWithNulls(this.speedDelta(), rd.speedDelta())).gunHeadingDelta((Bearing)Units.minusWithNulls(this.gunHeadingDelta(), rd.gunHeadingDelta())).gunHeatDelta((Heat)Units.minusWithNulls(this.gunHeatDelta(), rd.gunHeatDelta())).radarHeadingDelta((Bearing)Units.minusWithNulls(this.radarHeadingDelta(), rd.radarHeadingDelta())).build();
    }

    @Override
    public RobotDelta plus(RobotDelta rd) {
        return new Builder().energyDelta(Units.plusWithNulls(this.energyDelta(), rd.energyDelta())).locationDelta(Units.plusWithNulls(this.locationDelta(), rd.locationDelta())).headingDelta(Units.plusWithNulls(this.gunHeadingDelta(), rd.gunHeadingDelta())).speedDelta(Units.plusWithNulls(this.speedDelta(), rd.speedDelta())).gunHeadingDelta(Units.plusWithNulls(this.gunHeadingDelta(), rd.gunHeadingDelta())).gunHeatDelta(Units.plusWithNulls(this.gunHeatDelta(), rd.gunHeatDelta())).radarHeadingDelta(Units.plusWithNulls(this.radarHeadingDelta(), rd.radarHeadingDelta())).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-<BOT>-");
        if (this.energyDelta != null) {
            sb.append(" dNrg(").append(this.energyDelta).append(")");
        }
        if (this.locationDelta != null) {
            sb.append(" dLoc").append(this.locationDelta.toString());
        }
        if (this.headingDelta != null) {
            sb.append(" dHdg(").append(this.headingDelta).append(")");
        }
        if (this.speedDelta != null) {
            sb.append(" dSpd(").append(this.speedDelta).append(")");
        }
        sb.append(" -<GUN>-");
        if (this.gunHeadingDelta != null) {
            sb.append(" dHdg(").append(this.gunHeadingDelta).append(")");
        }
        if (this.gunHeatDelta != null) {
            sb.append(" dHt(").append(this.gunHeatDelta).append(")");
        }
        sb.append(" -<RADAR>-");
        if (this.radarHeadingDelta != null) {
            sb.append(" dHdg(").append(this.radarHeadingDelta).append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RobotDelta)) {
            return false;
        }
        RobotDelta rd = (RobotDelta)o;
        boolean bl = this.energyDelta() == null ? rd.energyDelta() == null : (result = this.energyDelta().equals(rd.energyDelta()));
        boolean bl2 = result && (this.locationDelta() == null ? rd.locationDelta() == null : this.locationDelta().equals(rd.locationDelta())) ? true : (result = false);
        boolean bl3 = result && (this.headingDelta() == null ? rd.headingDelta() == null : this.headingDelta().equals(rd.headingDelta())) ? true : (result = false);
        boolean bl4 = result && (this.speedDelta() == null ? rd.speedDelta() == null : this.speedDelta().equals(rd.speedDelta())) ? true : (result = false);
        boolean bl5 = result && (this.gunHeadingDelta() == null ? rd.gunHeadingDelta() == null : this.gunHeadingDelta().equals(rd.gunHeadingDelta())) ? true : (result = false);
        boolean bl6 = result && (this.gunHeatDelta() == null ? rd.gunHeatDelta() == null : this.gunHeatDelta().equals(rd.gunHeatDelta())) ? true : (result = false);
        result = result && (this.radarHeadingDelta() == null ? rd.radarHeadingDelta() == null : this.radarHeadingDelta().equals(rd.radarHeadingDelta()));
        return result;
    }

    public int hashCode() {
        int hc = this.energyDelta() == null ? 0 : this.energyDelta().hashCode();
        hc = hc * 31 + (this.locationDelta() == null ? 0 : this.locationDelta().hashCode());
        hc = hc * 31 + (this.headingDelta() == null ? 0 : this.headingDelta().hashCode());
        hc = hc * 31 + (this.speedDelta() == null ? 0 : this.speedDelta().hashCode());
        hc = hc * 31 + (this.gunHeadingDelta() == null ? 0 : this.gunHeadingDelta().hashCode());
        hc = hc * 31 + (this.gunHeatDelta() == null ? 0 : this.gunHeatDelta().hashCode());
        hc = hc * 31 + (this.radarHeadingDelta() == null ? 0 : this.radarHeadingDelta().hashCode());
        return hc;
    }

    public static class Builder {
        public Energy energyDelta = null;
        public RelativeLocation locationDelta = null;
        public Bearing headingDelta = null;
        public Speed speedDelta = null;
        public Bearing gunHeadingDelta = null;
        public Heat gunHeatDelta = null;
        public Bearing radarHeadingDelta = null;

        public Builder energyDelta(Energy energyDelta) {
            this.energyDelta = energyDelta;
            return this;
        }

        public Builder energyDelta(double energyDelta) {
            return this.energyDelta(new Energy(energyDelta));
        }

        public Builder locationDelta(RelativeLocation locationDelta) {
            this.locationDelta = locationDelta;
            return this;
        }

        public Builder locationDelta(double x, double y) {
            return this.locationDelta(new RelativeLocation(new Distance(x), new Distance(y)));
        }

        public Builder headingDelta(Bearing headingDelta) {
            this.headingDelta = headingDelta;
            return this;
        }

        public Builder headingDelta(double headingDelta) {
            return this.headingDelta(new Bearing(Angle.fromDegrees(headingDelta)));
        }

        public Builder speedDelta(Speed speedDelta) {
            this.speedDelta = speedDelta;
            return this;
        }

        public Builder speedDelta(double speedDelta) {
            return this.speedDelta(new Speed(speedDelta));
        }

        public Builder gunHeadingDelta(Bearing gunHeadingDelta) {
            this.gunHeadingDelta = gunHeadingDelta;
            return this;
        }

        public Builder gunHeadingDelta(double gunHeadingDelta) {
            return this.gunHeadingDelta(new Bearing(Angle.fromDegrees(gunHeadingDelta)));
        }

        public Builder gunHeatDelta(Heat gunHeatDelta) {
            this.gunHeatDelta = gunHeatDelta;
            return this;
        }

        public Builder gunHeatDelta(double gunHeatDelta) {
            return this.gunHeatDelta(new Heat(gunHeatDelta));
        }

        public Builder radarHeadingDelta(Bearing radarHeadingDelta) {
            this.radarHeadingDelta = radarHeadingDelta;
            return this;
        }

        public Builder radarHeadingDelta(double radarHeadingDelta) {
            return this.radarHeadingDelta(new Bearing(Angle.fromDegrees(radarHeadingDelta)));
        }

        public RobotDelta build() {
            return new RobotDelta(this.energyDelta, this.locationDelta, this.headingDelta, this.speedDelta, this.gunHeadingDelta, this.gunHeatDelta, this.radarHeadingDelta);
        }
    }
}

