/*
 * Decompiled with CFR 0.152.
 */
package Fenix;

import java.util.Random;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FenixTrack
extends AdvancedRobot {
    Random rand;
    int count;
    double gunTurnAmt;
    String trackName;
    int dist;
    boolean movingForward;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.gunTurnAmt = 90.0;
        while (true) {
            this.setTurnGunRight(this.gunTurnAmt);
            this.count = this.rand.nextInt(360);
            this.setTurnLeft(this.count - 10);
            this.movingForward = true;
            this.setAhead(10000.0);
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absoluteBearing = this.getHeading() + e.getBearing();
        double bearingFromGun = this.normalRelativeAngle(absoluteBearing - this.getGunHeading());
        if (Math.abs(bearingFromGun) <= (double)3) {
            this.turnGunRight(bearingFromGun);
            if (this.getGunHeat() == 0.0) {
                this.fire(Math.min(6.0 - Math.abs(bearingFromGun), this.getEnergy() - 0.1));
            }
        } else {
            this.turnGunRight(bearingFromGun);
        }
        if (bearingFromGun == 0.0) {
            this.scan();
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        this.gunTurnAmt = this.normalRelativeAngle(e.getBearing() + (this.getHeading() - this.getRadarHeading()));
        this.setTurnGunRight(this.gunTurnAmt);
        this.fire(3);
        this.setBack(50.0);
        this.execute();
    }

    public void onWin(WinEvent e) {
        int i = 0;
        while (i < 50) {
            this.turnRight(30.0);
            this.turnLeft(30.0);
            ++i;
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.reverseDirection();
    }

    public void reverseDirection() {
        if (this.movingForward) {
            this.setBack(10000.0);
            this.movingForward = false;
        } else {
            this.setAhead(10000.0);
            this.movingForward = true;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.setTurnRight(90.0 - e.getBearing());
        this.movingForward = true;
        this.setAhead(1000.0);
        this.execute();
    }

    public double normalAbsoluteAngle(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public double normalRelativeAngle(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    private final /* synthetic */ void this() {
        this.rand = new Random();
        this.count = 0;
        this.dist = 50;
    }

    public FenixTrack() {
        this.this();
    }
}

