/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.vectorsum;

import pedersen.movement.MovementMethod;
import pedersen.movement.vector.MovementMethodVector;
import pedersen.movement.vector.MovementMethodVectorRobotImpl;
import pedersen.movement.vector.MovementMethodVectorWallImpl;
import pedersen.movement.vectorsum.MovementMethodVectorSumBase;
import pedersen.physics.Direction;
import pedersen.physics.DistanceVector;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Snapshot;
import pedersen.physics.constant.DistanceVectorImpl;
import pedersen.physics.constant.PhysicsConstants;

public class MovementMethodTangoImpl
extends MovementMethodVectorSumBase
implements MovementMethod,
MovementMethodVector {
    private boolean clockwise = true;
    private static final MovementMethod singleton = new MovementMethodTangoImpl();

    private MovementMethodTangoImpl() {
        this.vectors.add(this);
        this.vectors.add(MovementMethodVectorWallImpl.getInstance());
        this.vectors.add(MovementMethodVectorRobotImpl.getInstance());
    }

    @Override
    public DistanceVector getVector() {
        DistanceVector movementVector = PhysicsConstants.anchorDistanceVector;
        Snapshot target = super.getTargetSnapshot();
        if (target != null && target.getEnergy().energy() > 0.0) {
            movementVector = this.getTangentalVector(super.getCombatantSnapshot(), target, 50.0);
        }
        return movementVector;
    }

    private DistanceVector getTangentalVector(HasPosition combatant, HasPosition target, double vectorLength) {
        return MovementMethodTangoImpl.getTangentalVector(combatant, target, vectorLength, this.clockwise);
    }

    private static DistanceVector getTangentalVector(HasPosition combatant, HasPosition target, double vectorLength, boolean clockwise) {
        DistanceVectorImpl vector = null;
        if (target != null) {
            Direction heading = combatant.getPosition().getBearing(target).getTangentAngle();
            if (!clockwise) {
                heading = heading.getOpposedAngle();
            }
            vector = new DistanceVectorImpl((HasDirection)heading, vectorLength);
        }
        return vector;
    }

    @Override
    public void onWaveCountChange() {
        this.clockwise = !this.clockwise;
    }

    public static MovementMethod getInstance() {
        return singleton;
    }
}

