/*
 * Decompiled with CFR 0.152.
 */
package rz.a;

import java.awt.Color;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;
import robocode.util.Utils;
import rz.a.BotUpdate;
import rz.a.Enemy;
import rz.a.Gun;
import rz.a.Movement;
import rz.a.Point;
import rz.a.Radar;
import rz.a.Strategy;
import rz.a.VictoryDance;

public abstract class AbstractRobot
extends TeamRobot {
    public static Strategy strategy;
    public static Gun gun;
    public static Movement movement;
    public static Radar radar;
    public static VictoryDance victoryDance;
    public static double maxX;
    public static double maxY;
    public static Hashtable targets;
    public static Enemy target;
    public static Point myPos;
    public static Point myLastPos;
    public static double heading;
    public static double lastHeading;
    public static double velocity;
    public static double lastVelocity;
    public static double acceleration;
    public static double lastAcceleration;
    public static double myEnergy;
    public static int others;
    public static boolean isLeader;
    public static boolean melee;
    public static boolean team;
    public static int hitWalls;
    public static int hitRobots;
    public static int skippedTurns;
    public static int[] roundsRanking;

    public void run() {
        this.initNewRound();
        while (true) {
            this.updateGlobals();
            this.doStrategy();
            this.doMovement();
            this.doGun();
            this.doRadar();
            this.doVictoryDance();
            this.execute();
        }
    }

    public void initNewRound() {
        this.setColors(new Color(80, 90, 200), new Color(110, 230, 110), new Color(225, 225, 225));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        if (this.getRoundNum() == 0) {
            maxX = this.getBattleFieldWidth();
            maxY = this.getBattleFieldHeight();
            boolean bl = false;
            if (this.getEnergy() > 190.0) {
                bl = true;
            }
            isLeader = bl;
            boolean bl2 = false;
            if (this.getOthers() > 1) {
                bl2 = true;
            }
            melee = bl2;
            team = false;
            myPos = new Point(this.getX(), this.getY());
            myLastPos = new Point(this.getX(), this.getY());
            this.updateGlobals();
            strategy = new Strategy(this);
            movement = new Movement(this);
            gun = new Gun(this);
            radar = new Radar(this);
            victoryDance = new VictoryDance(this);
        }
        strategy.initNewRound();
        movement.initNewRound();
        gun.initNewRound();
        victoryDance.initNewRound();
        Enumeration enumeration = targets.elements();
        while (enumeration.hasMoreElements()) {
            Enemy en = (Enemy)enumeration.nextElement();
            en.initNewRound();
        }
    }

    public void updateGlobals() {
        AbstractRobot.myLastPos.x = AbstractRobot.myPos.x;
        AbstractRobot.myLastPos.y = AbstractRobot.myPos.y;
        AbstractRobot.myPos.x = this.getX();
        AbstractRobot.myPos.y = this.getY();
        lastHeading = heading;
        heading = this.getHeadingRadians();
        lastVelocity = velocity;
        velocity = this.getVelocity();
        lastAcceleration = acceleration;
        acceleration = Math.abs(velocity) - Math.abs(lastVelocity);
        myEnergy = this.getEnergy();
        others = this.getOthers();
        if (team) {
            try {
                this.broadcastMessage(new BotUpdate(this.getName(), AbstractRobot.myPos.x, AbstractRobot.myPos.y, myEnergy, this.getTime()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy enemy = (Enemy)targets.get(e.getName());
        if (enemy == null) {
            enemy = new Enemy();
            targets.put(e.getName(), enemy);
            if (this.isTeammate(e.getName())) {
                team = true;
            }
            enemy.initBattle(this, e);
        }
        enemy.scanUpdate(e);
        if (!melee) {
            target = enemy;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        try {
            Enemy en = (Enemy)targets.get(e.getName());
            en.live = false;
            gun.onRobotDeath(en);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDeath(DeathEvent e) {
        if (others < 3) {
            int n = others;
            roundsRanking[n] = roundsRanking[n] + 1;
        }
        this.printStats();
    }

    public void onWin(WinEvent e) {
        roundsRanking[0] = roundsRanking[0] + 1;
        victoryDance.init();
        this.printStats();
    }

    public void onHitWall(HitWallEvent e) {
        ++hitWalls;
    }

    public void onHitRobot(HitRobotEvent e) {
        ++hitRobots;
        try {
            Enemy en = (Enemy)targets.get(e.getName());
            en.hitRobotUpdate(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ++skippedTurns;
    }

    public void onBulletHit(BulletHitEvent e) {
        try {
            Enemy en = (Enemy)targets.get(e.getName());
            en.energy = e.getEnergy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        try {
            Enemy en = (Enemy)targets.get(e.getName());
            en.hitByBulletUpdate(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onMessageReceived(MessageEvent e) {
        if (e.getMessage() instanceof BotUpdate) {
            BotUpdate p = (BotUpdate)e.getMessage();
            try {
                Enemy en = (Enemy)targets.get(p.name);
                en.pos.x = p.x;
                en.pos.y = p.y;
                en.energy = p.energy;
                en.scanTime = p.time;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void printStats() {
        this.out.println((double)roundsRanking[0] / ((double)this.getRoundNum() + 1.0));
    }

    public static double normalAngle(double angle) {
        return Utils.normalRelativeAngle((double)angle);
    }

    public static int sign(double value) {
        int n;
        if (value > 0.0) {
            n = 1;
        } else {
            int n2 = 0;
            if (value < 0.0) {
                n2 = 1;
            }
            n = 0 - n2;
        }
        return n;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double distToWall(double x, double y) {
        return Math.min(Math.min(maxX - x, x), Math.min(maxY - y, y));
    }

    public static double distToWall(Point p) {
        return Math.min(Math.min(maxX - p.x, p.x), Math.min(maxY - p.y, p.y));
    }

    public static double distToCorner(Point p) {
        double dist = Double.POSITIVE_INFINITY;
        int i = 0;
        do {
            dist = Math.min(dist, p.distance((double)(i & true) * maxX, (double)(i >> 1) * maxY));
        } while (++i < 4);
        return dist;
    }

    public abstract void doStrategy();

    public abstract void doRadar();

    public abstract void doMovement();

    public abstract void doGun();

    public abstract void doVictoryDance();

    static {
        targets = new Hashtable();
        target = new Enemy();
        roundsRanking = new int[3];
    }
}

