/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.util.MatrixTools;
import java.io.Serializable;
import java.util.Arrays;

public class Responsibilities
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final float[] d;
    private final int size;
    private boolean empty;

    public Responsibilities(int size) {
        this.d = new float[size];
        this.size = size;
        this.empty = true;
    }

    public void add(Responsibilities that) {
        if (!that.empty()) {
            if (this.empty) {
                Arrays.fill(this.d, 0.0f);
            }
            float[] addend = that.d;
            for (int j = 0; j < this.size; ++j) {
                int n = j;
                this.d[n] = this.d[n] + addend[j];
            }
            this.empty = false;
        }
    }

    public void clear() {
        this.empty = true;
    }

    public Responsibilities copy() {
        Responsibilities resp = new Responsibilities(this.size);
        resp.copy(this);
        return resp;
    }

    public void copy(Responsibilities that) {
        if (that.empty()) {
            this.empty = true;
        } else {
            System.arraycopy(that.d, 0, this.d, 0, this.size);
            this.empty = false;
        }
    }

    public void copyAdd(Responsibilities that, float[] add) {
        if (that.empty()) {
            this.empty = true;
        } else {
            float[] base = that.d;
            for (int j = 0; j < this.size; ++j) {
                this.d[j] = base[j] + add[j];
            }
            this.empty = false;
        }
    }

    public void copyMul(Responsibilities that, float[] factor) {
        if (that.empty()) {
            this.empty = true;
        } else {
            float[] base = that.d;
            for (int j = 0; j < this.size; ++j) {
                this.d[j] = base[j] * factor[j];
            }
            this.empty = false;
        }
    }

    public void copyPlusScaledDiff(Responsibilities that, float[] add, float[] sub, float amount) {
        if (that.empty()) {
            this.empty = true;
        } else {
            float[] base = that.d;
            for (int j = 0; j < this.size; ++j) {
                this.d[j] = base[j] + (add[j] - sub[j]) * amount;
            }
            this.empty = false;
        }
    }

    public boolean empty() {
        return this.empty;
    }

    public float[] get() {
        if (this.empty) {
            Arrays.fill(this.d, 0.0f);
        }
        return this.d;
    }

    public void scale(float[] factor) {
        if (!this.empty) {
            if (this.empty) {
                Arrays.fill(this.d, 0.0f);
            }
            for (int j = 0; j < this.size; ++j) {
                int n = j;
                this.d[n] = this.d[n] * factor[j];
            }
            this.empty = false;
        }
    }

    public void set(float[] resp) {
        System.arraycopy(resp, 0, this.d, 0, this.size);
        this.empty = false;
    }

    public void setOnes() {
        Arrays.fill(this.d, 1.0f);
        this.empty = false;
    }

    public int size() {
        return this.size;
    }

    public void target(float[] targets, float[] output) {
        for (int j = 0; j < this.size; ++j) {
            this.d[j] = targets[j] - output[j];
        }
        this.empty = false;
    }

    public void target(float[] targets, float[] output, float weight) {
        for (int j = 0; j < this.size; ++j) {
            this.d[j] = (targets[j] - output[j]) * weight;
        }
        this.empty = false;
    }

    public String toString() {
        if (this.empty) {
            return "Empty";
        }
        return MatrixTools.toString(this.d);
    }

    public void touch() {
        this.empty = false;
    }
}

