/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.Component;
import dmonner.xlbp.DownstreamComponent;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.UpstreamComponent;
import dmonner.xlbp.layer.AbstractInternalLayer;
import dmonner.xlbp.layer.CopyDestinationLayer;
import dmonner.xlbp.layer.DownstreamLayer;
import dmonner.xlbp.layer.InternalLayer;
import java.util.Stack;

public class CopySourceLayer
extends AbstractInternalLayer {
    private static final long serialVersionUID = 1L;
    private CopyDestinationLayer destination;

    public CopySourceLayer(CopySourceLayer that, NetworkCopier copier) {
        super(that, copier);
        this.destination = copier.getCopyOf(that.destination);
    }

    public CopySourceLayer(String name, int size) {
        super(name, size);
    }

    @Override
    public void activateTest() {
    }

    @Override
    public void activateTrain() {
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            if (this.destination == null) {
                throw new IllegalStateException("CopySourceLayer " + this.name + " has no destination!");
            }
            this.upstream.build();
            this.y = this.upstream.getActivations();
            this.d = new Responsibilities(this.size);
            this.checkSourceDownstream();
            this.notifyUpstreamLayers();
            this.built = true;
        }
    }

    private void checkSourceDownstream() {
        UpstreamComponent current = this.destination;
        boolean foundSource = false;
        while (current.getDownstream() instanceof InternalLayer) {
            if ((current = (UpstreamComponent)((Object)current.getDownstream())) != this) continue;
            foundSource = true;
            break;
        }
        if (!foundSource) {
            throw new IllegalStateException("The CopyDestinationLayer " + this.destination.name + " was not found upstream of this new CopySourceLayer" + this.name + ".");
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public CopySourceLayer copy(NetworkCopier copier) {
        return new CopySourceLayer(this, copier);
    }

    @Override
    public CopySourceLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        super.copyConnectivityFrom(comp, copier);
        if (comp instanceof CopySourceLayer) {
            this.destination = copier.getCopyIfExists(((CopySourceLayer)comp).destination);
        }
    }

    public CopyDestinationLayer getCopyDestination() {
        return this.destination;
    }

    public Responsibilities getPreviousResponsibilities() {
        return this.destination.getResponsibilities();
    }

    private void notifyUpstreamLayers() {
        Stack<UpstreamComponent> up = new Stack<UpstreamComponent>();
        up.push(this.upstream);
        while (!up.empty()) {
            UpstreamComponent current = (UpstreamComponent)up.pop();
            current.asUpstreamLayer().addDownstreamCopyLayer(this);
            if (!(current instanceof DownstreamLayer)) continue;
            DownstreamComponent cDownstream = (DownstreamComponent)((Object)current);
            for (int i = 0; i < cDownstream.nUpstream(); ++i) {
                up.push(cDownstream.getUpstream(i));
            }
        }
    }

    public void setCopyDestination(CopyDestinationLayer destination) {
        this.destination = destination;
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        if (sb.showExtra()) {
            sb.appendln("CopyDestination: " + this.destination);
        }
        sb.popIndent();
    }

    @Override
    public void updateEligibilities() {
    }

    @Override
    public void updateResponsibilities() {
        this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
    }

    @Override
    public void updateUpstreamResponsibilities(int index) {
        this.upstream.getResponsibilities(this.myIndexInUpstream).setOnes();
    }
}

