/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.connection.LayerConnection;
import dmonner.xlbp.layer.AbstractUpstreamLayer;
import dmonner.xlbp.layer.WeightSenderLayer;
import dmonner.xlbp.layer.WeightedLayer;

public class WeightReceiverLayer
extends AbstractUpstreamLayer
implements WeightedLayer {
    private static final long serialVersionUID = 1L;
    private LayerConnection in;

    public WeightReceiverLayer(String name, int size) {
        super(name, size);
    }

    public WeightReceiverLayer(WeightReceiverLayer that, NetworkCopier copier) {
        super(that, copier);
    }

    @Override
    public void activateTest() {
        this.in.activateTest();
    }

    @Override
    public void activateTrain() {
        this.in.activateTrain();
    }

    @Override
    public void build() {
        if (!this.built) {
            super.build();
            if (this.in == null) {
                throw new IllegalStateException("WeightReceiverLayer " + this.name + " has no incoming weight Connection.");
            }
            this.y = new float[this.size];
            this.d = new Responsibilities(this.size);
            this.in.build();
            this.built = true;
        }
    }

    @Override
    public void clearEligibilities() {
        this.in.clear();
    }

    @Override
    public WeightReceiverLayer copy(NetworkCopier copier) {
        return new WeightReceiverLayer(this, copier);
    }

    @Override
    public WeightReceiverLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        super.copyConnectivityFrom(comp, copier);
        if (comp instanceof WeightReceiverLayer) {
            WeightReceiverLayer that = (WeightReceiverLayer)comp;
            if (that.in != null && copier.copyWeights()) {
                this.setConnection(that.in.copy(copier));
            }
        }
    }

    public LayerConnection getConnection() {
        return this.in;
    }

    @Override
    public int nWeights() {
        return this.in.nWeights();
    }

    @Override
    public void processBatch() {
        if (this.in != null) {
            this.in.processBatch();
        }
    }

    public void removeConnection() {
        if (this.in != null) {
            WeightSenderLayer from = this.in.getFromLayer();
            this.in = null;
            if (from.getConnection() != null) {
                from.removeConnection();
            }
        }
    }

    public void setConnection(LayerConnection connection) {
        if (this.in != null) {
            throw new IllegalStateException(this.name + " already has an input connection.");
        }
        WeightSenderLayer from = connection.getFromLayer();
        WeightReceiverLayer to = connection.getToLayer();
        if (to != this) {
            throw new IllegalStateException("Connection " + connection.getName() + " goes to " + to + ", not " + this.name + ".");
        }
        this.in = connection;
        if (from.getConnection() != connection) {
            from.setConnection(connection);
        }
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
        if (this.in != null) {
            this.in.setWeightInitializer(win);
        }
    }

    @Override
    public void setWeightUpdaterType(WeightUpdaterType wut) {
        if (this.in != null) {
            this.in.setWeightUpdater(wut);
        }
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        if (this.in != null) {
            this.in.toString(sb);
        }
        sb.popIndent();
    }

    @Override
    public void unbuild() {
        super.unbuild();
        if (this.in != null) {
            this.in.unbuild();
        }
    }

    @Override
    public void updateEligibilities() {
        if (this.downstreamCopyLayer != null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
            this.in.updateEligibilities(this.d, this.downstreamCopyLayer.getPreviousResponsibilities());
        }
    }

    @Override
    public void updateResponsibilities() {
        if (this.downstreamCopyLayer == null) {
            this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
        }
    }

    @Override
    public void updateWeights() {
        if (this.downstreamCopyLayer == null) {
            this.in.updateWeightsFromInputs(this.d);
        } else {
            this.in.updateWeightsFromEligibilities(this.downstreamCopyLayer.getResponsibilities());
        }
    }
}

