/*
 * Decompiled with CFR 0.152.
 */
package pedersen.debug;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import pedersen.debug.ProjectedIntercept;
import pedersen.debug.RenderableLineSegment;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;

public class GraphicalDebugger {
    private double maxY = 0.0;
    public static final GraphicalDebugger singleton = new GraphicalDebugger();

    private GraphicalDebugger() {
    }

    public void init(double newMaxY) {
        this.maxY = newMaxY;
    }

    public void drawVehicleHitBox(Graphics2D console, StaticPosition center) {
        console.draw(new Rectangle2D.Double(center.getX() - 18.0, this.maxY - center.getY() - 18.0, 36.0, 36.0));
    }

    public void drawMarker(Graphics2D console, StaticPosition center) {
        console.draw(new Rectangle2D.Double(center.getX() - 2.0, this.maxY - center.getY() - 2.0, 4.0, 4.0));
    }

    public void drawRing(Graphics2D console, StaticPosition center, double radius) {
        console.draw(new Ellipse2D.Double(center.getX() - radius, this.maxY - center.getY() - radius, radius + radius, radius + radius));
    }

    public void drawRings(Graphics2D console, List centers, double radius) {
        Iterator iterator = centers.iterator();
        while (iterator.hasNext()) {
            this.drawRing(console, (StaticPosition)iterator.next(), radius);
        }
    }

    public void drawLine(Graphics2D console, StaticPosition a, StaticPosition b) {
        console.draw(new Line2D.Double(a.getX(), this.maxY - a.getY(), b.getX(), this.maxY - b.getY()));
    }

    public void drawRenderableLineSegment(Graphics2D console, RenderableLineSegment line) {
        console.setColor(line.color);
        console.draw(new Line2D.Double(line.x1, this.maxY - line.y1, line.x2, this.maxY - line.y2));
    }

    public void drawRenderableLineSegments(Graphics2D console, List lines) {
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            this.drawRenderableLineSegment(console, (RenderableLineSegment)iterator.next());
        }
    }

    public void drawProjectedIntercept(Graphics2D console, ProjectedIntercept line) {
        console.setColor(Color.orange);
        console.draw(new Line2D.Double(line.x1, this.maxY - line.y1, line.x2, this.maxY - line.y2));
        StaticPositionImpl center = new StaticPositionImpl((line.x1 + line.x2) * 0.5, (line.y1 + line.y2) * 0.5);
        this.drawVehicleHitBox(console, center);
    }
}

