/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.debug.ProjectedIntercept;
import pedersen.tactics.targeting.TargetingMethod;
import pedersen.tactics.targeting.TargetingStatistics;

public class FiringAngle
implements Debuggable {
    protected final TargetingMethod targetingMethod;
    protected final double firingAngle;
    private ProjectedIntercept projectedIntercept = null;

    public FiringAngle(TargetingMethod newTargetingMethod, double newFiringAngle) {
        this.targetingMethod = newTargetingMethod;
        this.firingAngle = Constraints.getZeroToTwoPi(newFiringAngle);
    }

    public FiringAngle(FiringAngle other) {
        this.targetingMethod = other.getTargetingMethod();
        this.firingAngle = other.getFiringAngle();
    }

    public TargetingStatistics getTargetingStatistics() {
        return this.targetingMethod.getTargetingStatistics();
    }

    public void debug() {
        Debug.debug(String.valueOf(this.getClass().getSimpleName()) + ": ");
        Debug.debug("firingAngle: " + this.firingAngle);
        this.targetingMethod.debug();
    }

    public TargetingMethod getTargetingMethod() {
        return this.targetingMethod;
    }

    public double getFiringAngle() {
        return this.firingAngle;
    }

    public void setProjectedIntercept(ProjectedIntercept newProjectedIntercept) {
        this.projectedIntercept = newProjectedIntercept;
    }

    public ProjectedIntercept getProjectedIntercept() {
        return this.projectedIntercept;
    }
}

