/*
 * Decompiled with CFR 0.152.
 */
package de.erdega.robocode;

import de.erdega.robocode.DuckAndCover;
import de.erdega.robocode.SmartRadar;
import de.erdega.robocode.StatisticalGun;
import de.erdega.robocode.base.AbstractChassis;
import de.erdega.robocode.base.AbstractGun;
import de.erdega.robocode.base.AbstractRadar;
import de.erdega.robocode.base.AnalyzedScannedRobotEvent;
import de.erdega.robocode.base.IChassis;
import de.erdega.robocode.base.IGun;
import de.erdega.robocode.base.IRadar;
import de.erdega.robocode.base.VirtualRobot;
import de.erdega.robocode.util.Vector;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import robocode.DeathEvent;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.WinEvent;

public class Polyphemos
extends VirtualRobot {
    private List<AnalyzedScannedRobotEvent> _events = new LinkedList<AnalyzedScannedRobotEvent>();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyymmdd-HHmmss");
    private IChassis _searchingChassis = new AbstractChassis(){};
    private IGun _searchingGun = new AbstractGun(this){

        public boolean isIndependent() {
            return false;
        }
    };
    private IRadar _searchingRadar = new AbstractRadar(){

        public boolean isIndependent() {
            return false;
        }

        public void init() {
            Polyphemos.this.radarInit();
        }

        public void handleScannedRobotEvent(AnalyzedScannedRobotEvent event) {
            Polyphemos.this.radarHandleScannedRobotEvent(event);
        }
    };

    protected IChassis createChassis() {
        return this._searchingChassis;
    }

    protected IGun createGun() {
        return this._searchingGun;
    }

    protected IRadar createRadar() {
        return this._searchingRadar;
    }

    protected void init() {
        super.init();
        this.setColors(new Color(20, 20, 40), new Color(20, 0, 40), new Color(20, 20, 0), new Color(128, 0, 255).brighter().brighter(), new Color(20, 0, 40));
    }

    protected void radarInit() {
        Vector heading;
        Vector middle = Vector.getBattleFieldMiddle((Robot)this);
        Vector pos = Vector.getPosition(this);
        Vector posFromMiddle = pos.sub(middle);
        double angle = posFromMiddle.getAngle(heading = Vector.getHeading(this));
        double rotDir = Math.signum(angle);
        rotDir = rotDir == 0.0 ? 1.0 : rotDir;
        double leftTurn = 1000000.0 * rotDir;
        this.setTurnRadarLeftRadians(leftTurn);
        this.setTurnGunLeftRadians(leftTurn);
        this.setTurnLeftRadians(leftTurn);
    }

    protected void radarHandleScannedRobotEvent(AnalyzedScannedRobotEvent event) {
        DuckAndCover chassis = new DuckAndCover(this);
        StatisticalGun gun = new StatisticalGun(this);
        SmartRadar<Polyphemos> radar = new SmartRadar<Polyphemos>(this);
        this.updateChassis(chassis);
        this.updateGun(gun);
        this.updateRadar(radar);
        super.onScannedRobot(event);
    }

    public void onScannedRobotBeforeHandling(AnalyzedScannedRobotEvent event) {
        this._events.add(event);
    }

    public void onDeath(DeathEvent event) {
        super.onDeath(event);
    }

    public void onWin(WinEvent event) {
        super.onWin(event);
    }

    private void writeEventList() {
        try {
            String enemyName = this._events.get(0).getEnemyName();
            String fileDate = DATE_FORMAT.format(new Date());
            String filename = String.valueOf(enemyName) + "-" + fileDate + ".stat";
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(filename)));
            oos.writeObject(this._events);
            oos.close();
        }
        catch (IOException e) {
            e.printStackTrace(this.out);
        }
    }
}

