/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.patterns;

import dmh.robocode.geo.Bearing;
import dmh.robocode.geo.Point;

public class StartingCondition {
    private Point myLocation;
    private Point enemyLocation;
    private double enemyHeading;
    private double enemyDistance;
    private double enemyVelocity;
    private double enemyRateOfTurn;

    public StartingCondition(Point myLocation, Point enemyLocation, double enemyHeading, double enemyVelocity, double enemyRateOfTurn) {
        this.myLocation = myLocation;
        this.enemyLocation = enemyLocation;
        this.enemyHeading = enemyHeading;
        this.enemyDistance = myLocation.getDistanceFrom(enemyLocation);
        this.enemyVelocity = enemyVelocity;
        this.enemyRateOfTurn = enemyRateOfTurn;
    }

    public double compareWith(StartingCondition compareWith) {
        double headingDifference = Math.abs(Bearing.getRightTurnBetween(compareWith.enemyHeading, this.enemyHeading));
        double distanceDifference = Math.abs(compareWith.enemyDistance - this.enemyDistance);
        double velocityDifference = Math.abs(compareWith.enemyVelocity - this.enemyVelocity);
        double rateOfTurnDifference = Math.signum(this.enemyRateOfTurn) == Math.signum(compareWith.enemyRateOfTurn) ? 0.0 : 10.0;
        return headingDifference / 10.0 + distanceDifference / 100.0 + velocityDifference * velocityDifference + rateOfTurnDifference;
    }

    public double getEnemyDifferenceX(Point actualEnemyLocation) {
        return actualEnemyLocation.getX() - this.enemyLocation.getX();
    }

    public double getEnemyDifferenceY(Point actualEnemyLocation) {
        return actualEnemyLocation.getY() - this.enemyLocation.getY();
    }
}

