/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.gun.fpGun;

import catcat20.jewel.iolite.gun.Gun;
import catcat20.jewel.iolite.gun.fpGun.FPData;
import catcat20.jewel.iolite.knnUtils.CounterPos;
import catcat20.jewel.iolite.knnUtils.FPWeightLearn;
import catcat20.jewel.iolite.radar.IoliteRadar;
import catcat20.jewel.iolite.utils.BotState;
import catcat20.jewel.iolite.utils.IUtils;
import catcat20.jewel.iolite.utils.Wave;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.trees.secondGenKD.KdTree;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class ForwardPatternMatcher
extends Gun {
    public AdvancedRobot robot;
    Rectangle2D.Double rect;
    double[] wei;
    ArrayList<CounterPos> poss = new ArrayList();
    double bulletPower = 1.95;
    ArrayList<Point2D.Double> pos = new ArrayList();
    public ArrayList<FPWave> waves = new ArrayList();
    Point2D.Double myPos = new Point2D.Double(0.0, 0.0);

    public ForwardPatternMatcher(TeamRobot robot) {
        super(robot);
        this.robot = robot;
        this.rect = new Rectangle2D.Double(0.0, 0.0, robot.getBattleFieldWidth(), robot.getBattleFieldHeight());
    }

    @Override
    public void init() {
        this.poss.clear();
        this.wei = new double[BotState.fpWeightLength];
    }

    double accelSegment(double deltaBearing, double oldDeltaBearing, double enemyDistance) {
        int delta = (int)Math.round(5.0 * enemyDistance * (Math.abs(deltaBearing) - Math.abs(oldDeltaBearing)));
        if (delta < 0) {
            return -1.0;
        }
        if (delta > 0) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public void execute() {
        this.myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        this.bulletPower = IoliteRadar.calculatePower();
        long time = this.robot.getTime();
        for (BotState en : IoliteRadar.enemies.values()) {
            if (!en.alive) continue;
            int lateralDirection = IUtils.sign(en.latVel);
            double wallDistance = IUtils.getWallDistance(en, this.rect, en.distance, IUtils.absoluteBearing(en, this.myPos), lateralDirection);
            double wallDistanceReverse = IUtils.getWallDistance(en, this.rect, en.distance, IUtils.absoluteBearing(en, this.myPos), -lateralDirection);
            double distLast10 = en.distance(en.oldPositions.get(Math.min(10, en.oldPositions.size() - 1)));
            double distLast16 = en.distance(en.oldPositions.get(Math.min(16, en.oldPositions.size() - 1)));
            double distLast35 = en.distance(en.oldPositions.get(Math.min(35, en.oldPositions.size() - 1)));
            double distLast30 = en.distance(en.oldPositions.get(Math.min(30, en.oldPositions.size() - 1)));
            double distLast60 = en.distance(en.oldPositions.get(Math.min(60, en.oldPositions.size() - 1)));
            double distLast120 = en.distance(en.oldPositions.get(Math.min(120, en.oldPositions.size() - 1)));
            double headingChange = Utils.normalRelativeAngle((double)(en.oldHeading - en.heading));
            double velocityChange = en.oldVelocity - en.velocity;
            double absBDiff = Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)en.absBearing) - Utils.normalAbsoluteAngle((double)en.heading)));
            FPWave w = new FPWave();
            w.absBearing = en.absBearing;
            w.enPos = (Point2D.Double)en.clone();
            w.bulletPower = this.bulletPower;
            w.enemyName = en.name;
            w.fireTime = time;
            w.dataPoint = new double[]{en.distance / 1300.0, (en.latVel + 8.0) / 16.0, Math.min(en.dirChangeTime, 90.0) / 90.0, Math.min(en.distance / Rules.getBulletSpeed((double)this.bulletPower), 130.0) / 130.0, (en.velocity + 8.0) / 16.0, (en.advVel + 8.0) / 16.0, (this.accelSegment(en.latVel, en.oldLatVel, en.distance) + 1.0) / 2.0, IUtils.limit(0.0, Math.abs(wallDistance) / Math.PI * 0.5, 1.0), IUtils.limit(0.0, Math.abs(wallDistanceReverse) / Math.PI, 1.0), distLast10 / 80.0, distLast16 / 128.0, distLast35 / 280.0, distLast30 / 240.0, distLast60 / 480.0, distLast120 / 960.0, Utils.normalAbsoluteAngle((double)en.heading) / (Math.PI * 2), headingChange / Math.PI, (velocityChange + 8.0) / 16.0, (absBDiff + 1.5707963267948966) / Math.PI, Math.abs(absBDiff) / 1.5707963267948966};
            this.waves.add(w);
            en.lastWave = w;
        }
        this.updateWaves();
        this.aim();
        this.paint();
        this.evaluatePoint();
    }

    public void evaluatePoint() {
        BotState en = IoliteRadar.getNearestEnemy();
        if (en != null) {
            for (int i = 0; i < en.fpLearnWeights.length; ++i) {
                FPWeightLearn weight = en.fpLearnWeights[i];
                weight.update(this.poss);
            }
            en.fpTree.setWeights(en.fpWeights);
            Graphics2D g = this.robot.getGraphics();
            g.setColor(Color.white);
            g.drawString(Arrays.toString(en.fpWeights), 10, -20);
        }
    }

    @Override
    public void onBulletHit(Wave w, BulletHitEvent e) {
    }

    @Override
    public void onBulletHitBullet(Wave w, BulletHitBulletEvent e) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
        for (BotState en : IoliteRadar.enemies.values()) {
            System.out.println(en.name + " FPG weights: " + Arrays.toString(en.fpWeights));
            System.out.println(en.name + " FPG baseWeights: " + Arrays.toString(en.fpBaseWeights));
        }
    }

    @Override
    public double getOffset() {
        return this.aim();
    }

    @Override
    public Color getColor() {
        return Color.yellow;
    }

    @Override
    public String getLabel() {
        return "ForwardPatternMatcher";
    }

    @Override
    public void onPaint(Graphics2D g) {
        Point2D.Double p;
        int i;
        g.setColor(new Color(0.375f, 0.0f, 0.0f));
        for (Point2D.Double p2 : this.pos) {
            g.drawRect((int)p2.x - 18, (int)p2.y - 18, 36, 36);
            g.drawOval((int)p2.x, (int)p2.y, 2, 2);
        }
        BotState en = IoliteRadar.getNearestEnemy();
        g.setColor(Color.yellow);
        long bestCount = -10000L;
        for (i = 0; i < this.poss.size(); ++i) {
            p = this.poss.get(i);
            if (p.isBig) {
                g.drawOval((int)p.x - 4, (int)p.y - 4, 8, 8);
            } else {
                g.drawOval((int)p.x - 2, (int)p.y - 2, 4, 4);
            }
            ++p.counter;
            if (bestCount < (long)p.count) {
                bestCount = p.count;
            }
            if (p.counter <= p.count) continue;
            this.poss.remove(i);
            --i;
        }
        if (en != null) {
            g.setColor(Color.orange);
            i = 0;
            while ((long)i < bestCount) {
                if ((long)en.oldPositions.size() < bestCount) {
                    p = en.oldPositions.get(i);
                    g.drawOval((int)p.x - 2, (int)p.y - 2, 4, 4);
                }
                ++i;
            }
        }
    }

    public void paint() {
    }

    public Double aim() {
        this.pos.clear();
        ArrayList<Angle> angles = new ArrayList<Angle>();
        int count = 100 / Math.max(IoliteRadar.scans.size(), 1);
        if (this.robot.getOthers() <= 1) {
            count = 64;
            count = 1;
        }
        for (BotState en : IoliteRadar.enemies.values()) {
            if (en.lastWave == null || !en.alive) continue;
            List data = en.fpTree.nearestNeighbor(en.lastWave.dataPoint, count, false);
            for (KdTree.Entry entry : data) {
                Point2D.Double pPoint = IUtils.project(en, ((FPData)entry.value).absBearing + en.heading, ((FPData)entry.value).distance);
                this.pos.add(pPoint);
                if (!this.rect.contains(pPoint)) continue;
                Angle angle = new Angle();
                angle.angle = IUtils.absoluteBearing(this.myPos, pPoint);
                angle.weights = 1.0 / Math.sqrt(entry.distance);
                angle.bandwidth = IUtils.botWidthAimAngle(this.myPos.distance(pPoint));
                angle.distance = this.myPos.distance(pPoint);
                angles.add(angle);
            }
        }
        Double bestAngle = null;
        double bestDensity = Double.NEGATIVE_INFINITY;
        for (Angle angle : angles) {
            double xDensity = 0.0;
            for (Angle yFiringAngle : angles) {
                double ux = Utils.normalRelativeAngle((double)(angle.angle - yFiringAngle.angle)) / yFiringAngle.bandwidth;
                xDensity += yFiringAngle.weights * Math.exp(-0.5 * ux * ux) / yFiringAngle.distance;
            }
            if (!(xDensity > bestDensity)) continue;
            bestAngle = angle.angle;
            bestDensity = xDensity;
        }
        if (bestAngle != null) {
            bestAngle = Utils.normalAbsoluteAngle((double)bestAngle);
            Graphics2D g = this.robot.getGraphics();
            g.setColor(Color.red);
            Point2D.Double double_ = IUtils.project(this.myPos, bestAngle, 1300.0);
            g.drawLine((int)this.myPos.x, (int)this.myPos.y, (int)double_.x, (int)double_.y);
            BotState en = IoliteRadar.getNearestEnemy();
            if (en != null) {
                CounterPos pos2 = new CounterPos();
                pos2.x = IUtils.project((Point2D.Double)this.myPos, (double)bestAngle.doubleValue(), (double)en.distance).x;
                pos2.y = IUtils.project((Point2D.Double)this.myPos, (double)bestAngle.doubleValue(), (double)en.distance).y;
                pos2.count = (int)(en.distance / Rules.getBulletSpeed((double)IoliteRadar.calculatePower()));
                if (this.robot.getGunHeat() == 0.0) {
                    pos2.isBig = true;
                }
                this.poss.add(pos2);
            }
        } else {
            BotState en = IoliteRadar.getNearestEnemy();
            bestAngle = en != null ? Double.valueOf(en.absBearing) : Double.valueOf(0.0);
        }
        return bestAngle;
    }

    public void updateWaves() {
        long time = this.robot.getTime();
        for (int i = 0; i < this.waves.size(); ++i) {
            FPWave wave = this.waves.get(i);
            wave.distanceTraveled = (double)(time - wave.fireTime) * wave.bulletSpeed();
            BotState en = IoliteRadar.getEnemy(wave.enemyName);
            if (!(wave.distance(en) < wave.distanceTraveled + 9.0)) continue;
            FPData data = new FPData();
            data.absBearing = Utils.normalRelativeAngle((double)(en.heading - IUtils.absoluteBearing(wave.enPos, en)));
            data.distance = wave.enPos.distance(en);
            en.fpTree.addPoint(wave.dataPoint, data);
            this.waves.remove(i);
            --i;
        }
    }

    public class FPWave
    extends Point2D.Double {
        public double absBearing;
        public double bulletPower;
        public double distanceTraveled;
        public long fireTime;
        public String enemyName;
        double[] dataPoint;
        public Point2D.Double enPos;

        public double bulletSpeed() {
            return Rules.getBulletSpeed((double)this.bulletPower);
        }
    }

    public class Angle {
        public double angle;
        public double weights;
        public double bandwidth;
        public double distance;
    }
}

