/*
 * Decompiled with CFR 0.152.
 */
package taqho;

import java.text.NumberFormat;
import taqho.Heading;

public class Bearing {
    private double mBearing = 0.0;
    private NumberFormat dp2 = NumberFormat.getInstance();

    public Bearing() {
        this.Initialise();
    }

    public Bearing(double brngVal) {
        this.Initialise();
        this.Set(brngVal);
    }

    public Bearing(Bearing brngVal) {
        this.Initialise();
        this.Set(brngVal);
    }

    public void Initialise() {
        this.mBearing = 0.0;
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
    }

    public void Set(double newValue) {
        this.mBearing = newValue;
        this.Normalise();
    }

    public void Set(Bearing newValue) {
        if (newValue != null) {
            this.mBearing = newValue.Get();
            this.Normalise();
        }
    }

    public void Set(Heading newValue) {
        if (newValue != null) {
            this.mBearing = newValue.Get();
            this.Normalise();
        }
    }

    public void Flip() {
        this.mBearing += 180.0;
        this.Normalise();
    }

    public final double Get() {
        return this.mBearing;
    }

    public final double GetAbs() {
        return Math.abs(this.mBearing);
    }

    public final boolean IsNormalised() {
        boolean answer = false;
        if (this.mBearing >= -180.0 && this.mBearing < 180.0) {
            answer = true;
        }
        return answer;
    }

    public void Normalise() {
        boolean done = false;
        while (!done) {
            if (this.mBearing >= 180.0) {
                this.mBearing -= 360.0;
                continue;
            }
            if (this.mBearing < -180.0) {
                this.mBearing += 360.0;
                continue;
            }
            done = true;
        }
    }

    public Heading convertToHeading() {
        return new Heading(this.mBearing);
    }

    public void SetFromTo(Heading fromHdng, Heading toHdng) {
        this.mBearing = toHdng.Get() - fromHdng.Get();
        this.Normalise();
    }

    public void SetFromTo(Bearing fromBrng, Bearing toBrng) {
        this.mBearing = toBrng.Get() - fromBrng.Get();
        this.Normalise();
    }

    public final boolean IsAligned() {
        boolean answer = false;
        if (this.mBearing >= -0.5 && this.mBearing <= 0.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsOpposed() {
        boolean answer = false;
        if (this.mBearing >= 179.5 || this.mBearing <= -179.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsLeft90() {
        boolean answer = false;
        if (this.mBearing >= -90.5 && this.mBearing <= -89.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsRight90() {
        boolean answer = false;
        if (this.mBearing >= 89.5 && this.mBearing <= 90.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsLeftward() {
        boolean answer = false;
        if (this.mBearing < -0.5 && this.mBearing > -179.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsRightward() {
        boolean answer = false;
        if (this.mBearing > 0.5 && this.mBearing < 179.5) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsForward() {
        boolean answer = false;
        if (this.mBearing >= -90.0 && this.mBearing <= 90.0) {
            answer = true;
        }
        return answer;
    }

    public final boolean IsBackward() {
        boolean answer = false;
        if (this.mBearing < -90.0 || this.mBearing > 90.0) {
            answer = true;
        }
        return answer;
    }

    public String toString() {
        String answer = new String();
        answer = answer.concat(this.dp2.format(this.mBearing));
        return answer;
    }
}

