/*
 * Decompiled with CFR 0.152.
 */
package syl.movement;

import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.movement.GravityMovementStrategy;
import syl.movement.MovementStrategy;
import syl.util.Coordinate;

public class WaypointGravityMovementStrategy
extends GravityMovementStrategy {
    private static final double DISTANCE = 100.0;
    private static final double ANGLE_INTERVAL = 45.0;
    private double prevWaypointAngle = Double.MAX_VALUE;

    public WaypointGravityMovementStrategy(BaseRobot robot) {
        super(robot);
    }

    public void doMovement(Enemy enemy) {
        if (this.getRobot().getTime() % 10L != 0L) {
            return;
        }
        this.updateGravityPoints();
        double minForce = Double.MAX_VALUE;
        Coordinate minForceCoordinate = null;
        double minForceAngle = 0.0;
        double heading = this.getRobot().getHeading();
        int numberOfWaypoints = (int)Math.round(8.0);
        int i = 0;
        while (i < numberOfWaypoints) {
            double force;
            Coordinate waypoint;
            double waypointAngle = (double)i * 45.0;
            if (waypointAngle != this.prevWaypointAngle && (waypoint = this.getRobot().getCoordinate().getCoordinate(100.0, waypointAngle)).isValid() && Math.abs(force = this.getForce(waypoint)) < minForce) {
                minForce = Math.abs(force);
                minForceCoordinate = waypoint;
                minForceAngle = waypointAngle;
            }
            ++i;
        }
        this.prevWaypointAngle = minForceAngle;
        MovementStrategy.goTo(this.getRobot(), minForceCoordinate, 8.0);
    }
}

