/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.List;
import java.util.Map;
import robocode.AdvancedRobot;
import tcf.Arena;
import tcf.Bot;
import tcf.CrowdTargettingWave;
import tcf.MovementBase;
import tcf.OppBot;
import tcf.SimBot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CanStopMovement
extends MovementBase {
    AdvancedRobot m_robot;
    Bot m_self;
    List<CrowdTargettingWave> m_waves;
    double m_toX;
    double m_toY;
    int m_updateDestCount = 0;

    CanStopMovement(Arena arena, AdvancedRobot advancedRobot, Bot bot, List<CrowdTargettingWave> list) {
        super(arena);
        this.m_robot = advancedRobot;
        this.m_self = bot;
        this.m_waves = list;
    }

    @Override
    void tick(Map<String, OppBot> map, int n, OppBot oppBot) {
        if (--this.m_updateDestCount > 0) {
            return;
        }
        this.m_updateDestCount = 20;
        this.updateGrid(map, n);
        int n2 = this.calcGridX(this.m_self.x());
        int n3 = this.calcGridY(this.m_self.y());
        int n4 = n2 + n3 * this.m_gridW;
        double d = -9.99999999E8;
        double d2 = 0.0;
        double d3 = 0.0;
        int[] nArray = new int[25];
        int[] nArray2 = new int[25];
        double[] dArray = new double[25];
        double[] dArray2 = new double[25];
        double[][] dArray3 = new double[this.m_waves.size()][25];
        long l = System.nanoTime();
        for (int i = 100; i <= 200; i += 100) {
            for (int j = 0; j < 24; ++j) {
                int n5;
                double d4 = j * 15;
                int n6 = this.calcGridXUnsafe(this.m_self.x() + (double)i * Math.sin(Math.toRadians(d4)));
                int n7 = this.calcGridYUnsafe(this.m_self.y() + (double)i * Math.cos(Math.toRadians(d4)));
                if (n6 < 0 || n6 >= this.m_gridW || n7 < 0 || n7 >= this.m_gridH) continue;
                int n8 = this.m_gridW - 1 - n6;
                int n9 = this.m_gridH - 1 - n7;
                if (n6 + n7 < 4 || n6 + n9 < 4 || n8 + n7 < 4 || n8 + n9 < 4) continue;
                this.calcGridPath(this.m_self, this.gridToRealX(n6), this.gridToRealY(n7), nArray, dArray, dArray2);
                for (n5 = 0; n5 < this.m_waves.size(); ++n5) {
                    int n10;
                    CrowdTargettingWave crowdTargettingWave = this.m_waves.get(n5);
                    int n11 = -1;
                    double d5 = 0.0;
                    double d6 = crowdTargettingWave.distLeft(dArray[24], dArray2[24], 24.0);
                    if (d6 <= 0.0) {
                        for (n10 = 0; n10 < nArray.length; ++n10) {
                            if (n11 < 0) {
                                d5 = 10000.0 * crowdTargettingWave.calcHit(dArray[n10], dArray2[n10]);
                                d6 = crowdTargettingWave.distLeft(dArray[n10], dArray2[n10], n10);
                                if (d6 <= 0.0) {
                                    n11 = n10;
                                }
                            }
                            dArray3[n5][n10] = d5;
                        }
                    }
                    if (n11 > 0) continue;
                    for (n10 = 0; n10 < 25; ++n10) {
                        dArray3[n5][n10] = 0.0;
                    }
                }
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    int n12;
                    double d7 = this.m_grid[nArray[n5]];
                    for (n12 = 0; n12 < this.m_waves.size(); ++n12) {
                        d7 -= dArray3[n12][n5];
                    }
                    if (!(d < d7)) continue;
                    d = d7;
                    d2 = dArray[n5];
                    d3 = dArray2[n5];
                    if (this.m_gridPath == null) {
                        this.m_gridPath = new int[nArray.length];
                        this.m_gridPathValue = new int[nArray.length];
                    }
                    for (n12 = 0; n12 < 25; ++n12) {
                        this.m_gridPath[n12] = nArray[n12];
                        this.m_gridPathValue[n12] = nArray2[n12];
                    }
                }
            }
        }
        long l2 = System.nanoTime();
        System.out.printf("Path selection: %g seconds\n", (double)(l2 - l) * 1.0E-9);
        this.m_toX = d2;
        this.m_toY = d3;
    }

    @Override
    void event(MovementBase.Event event) {
        switch (event) {
            default: 
        }
        this.m_updateDestCount = 0;
    }

    @Override
    void drive() {
        double[] dArray = this.doGoto(this.m_self, this.m_toX, this.m_toY);
        this.m_robot.setTurnRightRadians(dArray[0]);
        this.m_robot.setAhead(dArray[1] == 0.0 ? 0.0 : (dArray[1] < 0.0 ? -100.0 : 100.0));
        this.m_robot.setMaxVelocity(Math.abs(dArray[1]));
    }

    @Override
    double getToX() {
        return this.m_toX;
    }

    @Override
    double getToY() {
        return this.m_toY;
    }

    public void calcGridPath(Bot bot, double d, double d2, int[] nArray, double[] dArray, double[] dArray2) {
        SimBot simBot = new SimBot(bot);
        int n = this.calcGridX(simBot.x());
        int n2 = this.calcGridY(simBot.y());
        nArray[0] = n + n2 * this.m_gridW;
        dArray[0] = simBot.x();
        dArray2[0] = simBot.y();
        for (int i = 1; i < nArray.length; ++i) {
            double[] dArray3 = this.doGoto(simBot, d, d2);
            double d3 = simBot.heading() + dArray3[0];
            simBot.next(d3, dArray3[1]);
            n = this.calcGridX(simBot.x());
            n2 = this.calcGridY(simBot.y());
            nArray[i] = n + n2 * this.m_gridW;
            dArray[i] = simBot.x();
            dArray2[i] = simBot.y();
        }
    }
}

