/*
 * Decompiled with CFR 0.152.
 */
package rampancy.standard;

import rampancy.standard.RDefaultKDTree;
import rampancy.standard.RDefaultTargetingSegmentArray;
import rampancy.util.REnemyRobot;
import rampancy.util.RUtil;
import rampancy.util.data.segmentArray.RLeafSegment;
import rampancy.util.wave.RBulletWave;
import rampancy.util.weapon.RFiringSolution;
import rampancy.util.weapon.RTargetingStatistic;
import robocode.util.Utils;

public class RDefaultTargetingStatistic
implements RTargetingStatistic {
    private RDefaultTargetingSegmentArray segmentArray = new RDefaultTargetingSegmentArray();
    private RDefaultKDTree kdTree = new RDefaultKDTree();
    private int currentWeapon = 0;

    public RFiringSolution getBestFiringSolutionForEnemy(REnemyRobot enemy, double currentBearingToTarget) {
        return null;
    }

    public void noteHitOnEnemy(REnemyRobot enemy, RBulletWave wave) {
        this.updateSegmentArray(enemy, wave);
        this.updateKDTree(enemy, wave);
    }

    private void updateSegmentArray(REnemyRobot enemy, RBulletWave wave) {
        RLeafSegment leaf = this.segmentArray.getSegmentForState(wave.getTargetState());
        double desiredDirection = RUtil.computeAbsoluteBearing(wave.getOrigin(), wave.getTarget().getLastState().location);
        double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - wave.getTargetState().absoluteBearing));
        double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / RUtil.computeMaxEscapeAngle(wave.getVelocity()))) * (double)wave.getTargetState().directionTraveling;
        int index = RUtil.computeBin(guessFactor, leaf.guessFactorArray.length);
        RLeafSegment.updateGuessFactors(leaf, index, 1.0, 2);
    }

    private void updateKDTree(REnemyRobot enemy, RBulletWave wave) {
        double desiredDirection = RUtil.computeAbsoluteBearing(wave.getOrigin(), wave.getTarget().getLastState().location);
        double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - wave.getTargetState().absoluteBearing));
        double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / RUtil.computeMaxEscapeAngle(wave.getVelocity()))) * (double)wave.getTargetState().directionTraveling;
        this.kdTree.addPoint(wave.getTargetState(), guessFactor);
    }

    private double getBestGuessFactorForEnemy(REnemyRobot enemy) {
        RLeafSegment leaf = this.segmentArray.getSegmentForState(enemy.getCurrentState());
        int bestIndex = RUtil.indexOfLargest(leaf.guessFactorArray);
        double factor = RUtil.getGuessFactorForIndex(bestIndex, leaf.guessFactorArray.length);
        return factor;
    }
}

