/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode;

import gtf.robocode.Gun;
import gtf.robocode.Point;
import gtf.robocode.Radar;
import gtf.robocode.Reading;
import gtf.robocode.forcefield.ForceField;
import gtf.robocode.forcefield.PointField;
import gtf.robocode.forcefield.WallField;
import gtf.robocode.motor.ComboMotor;
import gtf.robocode.motor.Motor;
import gtf.robocode.opponent.Opponent;
import gtf.robocode.opponent.OpponentManager;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class Strafer
extends AdvancedRobot {
    static final Color OLIVE_DRAB_LIGHT = new Color(0.5f, 0.65f, 0.25f);
    static final Color OLIVE_DRAB_MEDIUM = new Color(0.42f, 0.5f, 0.2f);
    static final Color OLIVE_DRAB_DARK = new Color(0.35f, 0.35f, 0.15f);
    static Color bodyColor = OLIVE_DRAB_LIGHT;
    static Color turretColor = OLIVE_DRAB_LIGHT;
    static Color radarColor = OLIVE_DRAB_DARK;
    boolean shootTeamMembers = true;
    protected OpponentManager opponents = new OpponentManager();
    protected Motor motor;
    protected Radar radar = new Radar(this);
    protected Gun gun = new Gun(this);
    private volatile boolean isWinner = false;
    static final double CONV_THRESHOLD = 0.01;
    static final int ITERATIONS = 20;

    public void onWin(WinEvent e) {
        this.isWinner = true;
    }

    Point getPosition() {
        return new Point(this.getTime(), this.getX(), this.getY());
    }

    public void run() {
        this.setColors(bodyColor, turretColor, radarColor);
        this.setAdjustGunForRobotTurn(true);
        while (!this.isWinner) {
            this.conRadar();
            ForceField forceField = this.buildForceField();
            this.motor = new ComboMotor(this, forceField);
            Point target = this.findTarget();
            if (target != null) {
                this.gun.setTarget(target.minus(this.getPosition()));
                this.gun.doTurn();
                this.gun.doFire();
            }
            this.motor.doMotion();
            this.execute();
        }
    }

    private ForceField buildForceField() {
        ForceField ff = new WallField(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        for (Opponent opponent : this.opponents) {
            Point pos = opponent.getPredictedPosition(this.getTime());
            PointField pf = new PointField(pos.x, pos.y);
            ff = ff.plus(pf);
        }
        return ff;
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.opponents.remove(event.getName());
    }

    private void conRadar() {
        this.setTurnRadarRight(360.0);
        this.waitFor((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
    }

    private boolean isInBounds(Point target) {
        return target.x >= 0.0 && target.x <= this.getBattleFieldWidth() && target.y >= 0.0 && target.y <= this.getBattleFieldHeight();
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        double myHeadingRadians = Math.toRadians(this.getHeading());
        double distance = event.getDistance();
        double absoluteBearingRadians = event.getBearingRadians() + myHeadingRadians;
        double x = this.getX() + distance * Math.sin(absoluteBearingRadians);
        double y = this.getY() + distance * Math.cos(absoluteBearingRadians);
        Reading reading = new Reading(this.getTime(), x, y, event.getVelocity(), event.getHeadingRadians(), event.getEnergy());
        this.opponents.addReading(event.getName(), reading);
    }

    public void onHitByBullet(HitByBulletEvent event) {
    }

    public void onHitWall(HitWallEvent e) {
        this.motor.onHitWall(e);
    }

    private Point getPredictedTargetPoint(Opponent opponent) {
        Point target = opponent.getLastPosition();
        double time = this.getTime();
        double prevTime = 0.0;
        for (int i = 0; i < 20; ++i) {
            prevTime = time;
            time = (double)this.getTime() + target.distance(this.getX(), this.getY()) / this.gun.getBulletSpeed();
            target = opponent.getPredictedPosition(time);
        }
        if (time - prevTime > 0.01 || !this.isInBounds(target)) {
            target = null;
        }
        return target;
    }

    Point findTarget() {
        Point targetPoint = null;
        double time = Double.MAX_VALUE;
        for (Opponent opponent : this.opponents) {
            double d;
            Point target = this.getPredictedTargetPoint(opponent);
            if (target == null) continue;
            double tempTime = target.time;
            if (!(d < time)) continue;
            targetPoint = target;
            time = tempTime;
        }
        return targetPoint;
    }
}

