/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode;

import gtf.robocode.Util;
import gtf.robocode.Vector2D;

public class VectorPolar {
    public double r;
    public double theta;

    public VectorPolar(double r, double theta) {
        if (r < 0.0) {
            r = -r;
            theta += 1.5707963267948966;
        }
        this.r = r;
        this.theta = Util.toBearingRadians(theta);
    }

    public VectorPolar plus(VectorPolar p2) {
        Vector2D v = this.toCartesian().plus(p2.toCartesian());
        return v.toPolar();
    }

    public double norm() {
        return Math.abs(this.r);
    }

    public VectorPolar minus(VectorPolar p2) {
        Vector2D v = this.toCartesian().minus(p2.toCartesian());
        return v.toPolar();
    }

    public Vector2D toCartesian() {
        return new Vector2D(this.r * Math.sin(this.theta), this.r * Math.cos(this.theta));
    }

    public VectorPolar times(double scalar) {
        return new VectorPolar(scalar * this.r, this.theta);
    }

    public String toString() {
        return "(r =" + this.r + ", theta = " + this.theta + ")";
    }
}

